/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.common.data;

import o.a.c.sidecar.client.shaded.common.data.ConsistencyLevel;
import o.a.c.sidecar.client.shaded.common.utils.Preconditions;
import o.a.c.sidecar.client.shaded.common.utils.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ConsistencyConfig {
    @Nullable
    public final ConsistencyLevel consistencyLevel;
    @Nullable
    public final String localDatacenter;

    public static ConsistencyConfig parseString(@Nullable String consistencyLevelString, @Nullable String localDatacenter) {
        return new ConsistencyConfig(ConsistencyLevel.fromString(consistencyLevelString), localDatacenter);
    }

    private ConsistencyConfig(@Nullable ConsistencyLevel consistencyLevel, @Nullable String localDatacenter) {
        Preconditions.checkArgument(consistencyLevel == null || !consistencyLevel.isLocalDcOnly || StringUtils.isNotEmpty(localDatacenter), "localDatacenter cannot be empty for consistency level: " + String.valueOf((Object)consistencyLevel));
        this.consistencyLevel = consistencyLevel;
        this.localDatacenter = localDatacenter;
    }
}

