/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.scanner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.bridge.CdcBridge;
import org.apache.cassandra.bridge.TokenRange;
import org.apache.cassandra.cdc.api.CassandraSource;
import org.apache.cassandra.cdc.api.CdcOptions;
import org.apache.cassandra.cdc.api.CommitLog;
import org.apache.cassandra.cdc.api.CommitLogMarkers;
import org.apache.cassandra.cdc.api.CommitLogReader;
import org.apache.cassandra.cdc.api.Marker;
import org.apache.cassandra.cdc.scanner.CdcStreamScanner;
import org.apache.cassandra.cdc.state.CdcState;
import org.apache.cassandra.cdc.stats.ICdcStats;
import org.apache.cassandra.db.commitlog.PartitionUpdateWrapper;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.apache.cassandra.spark.utils.AsyncExecutor;
import org.apache.cassandra.spark.utils.FutureUtils;
import org.apache.cassandra.spark.utils.Pair;
import org.apache.cassandra.util.StatsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdcScannerBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CdcScannerBuilder.class);
    protected final CdcBridge cdcBridge;
    protected final CassandraSource cassandraSource;
    protected final CdcOptions cdcOptions;
    final ICdcStats stats;
    final Map<CassandraInstance, CompletableFuture<List<CommitLogReader.Result>>> futures;
    @Nullable
    private final TokenRange tokenRange;
    @NotNull
    final CdcState startState;
    protected final int partitionId;
    private final long startTimeNanos;
    @NotNull
    private final AsyncExecutor executor;
    private final boolean readCommitLogHeader;
    private final long startTimestampMicroseconds;

    public CdcScannerBuilder(CdcBridge cdcBridge, int partitionId, CdcOptions cdcOptions, ICdcStats stats, @Nullable TokenRange tokenRange, @NotNull CdcState startState, @NotNull AsyncExecutor executor, boolean readCommitLogHeader, @NotNull Map<CassandraInstance, List<CommitLog>> logs, CassandraSource cassandraSource) {
        this.cdcBridge = cdcBridge;
        this.cdcOptions = cdcOptions;
        this.stats = stats;
        this.tokenRange = tokenRange;
        this.startState = startState;
        this.executor = executor;
        this.readCommitLogHeader = readCommitLogHeader;
        this.startTimeNanos = System.nanoTime();
        this.cassandraSource = cassandraSource;
        this.partitionId = partitionId;
        this.startTimestampMicroseconds = cdcOptions.minimumTimestampMicros();
        LOGGER.debug("Opening CdcScanner numInstances={} startTimestampMicroseconds={} maxCommitLogsPerInstance={} partitionId={} samplingRate={} maxCdcState={}", new Object[]{logs.size(), this.startTimestampMicroseconds, cdcOptions.maxCommitLogsPerInstance(), partitionId, cdcOptions.samplingRate(), cdcOptions.maxCdcStateSize()});
        if (LOGGER.isTraceEnabled()) {
            logs.values().stream().flatMap(Collection::stream).forEach(log -> LOGGER.trace("Opening CdcScanner to read log instance={} log={} len={} partitionId={} maxOffset={}", new Object[]{log.instance().nodeName(), log.name(), log.length(), partitionId, log.maxOffset()}));
        }
        this.futures = logs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.openInstance((List)entry.getValue(), cdcOptions.maxCommitLogsPerInstance(), startState.markers, executor)));
    }

    private static boolean greaterThanOrEqualToStartMarker(@NotNull CommitLog log, @NotNull CommitLogMarkers markers, @NotNull ICdcStats stats, int partitionId) {
        Marker startMarker = markers.startMarker(log);
        Long segmentId = CommitLog.extractVersionAndSegmentId((CommitLog)log).map(Pair::getRight).orElse(null);
        Preconditions.checkArgument((boolean)startMarker.instance().equals((Object)log.instance()), (Object)("Start marker should be on the same instance as commit log: " + startMarker.instance().nodeName() + " vs. " + log.instance().nodeName()));
        if (segmentId != null && segmentId >= startMarker.segmentId()) {
            LOGGER.trace("Commit log greater than or equal to startMarker log={} segmentId={} instance={} startMarker={} partitionId={}", new Object[]{log.name(), segmentId, log.instance().nodeName(), startMarker.segmentId(), partitionId});
            return true;
        }
        LOGGER.debug("Commit log before startMarker log={} segmentId={} instance={} startMarker={} partitionId={}", new Object[]{log.name(), log.segmentId(), log.instance().nodeName(), startMarker.segmentId(), partitionId});
        stats.skippedCommitLogsCount(1L);
        return false;
    }

    public static Stream<CommitLog> sortAndLimit(int partitionId, Collection<CommitLog> logs, int maxCommitLogsPerInstance, @NotNull CommitLogMarkers markers, ICdcStats stats) {
        if (maxCommitLogsPerInstance > 0) {
            LOGGER.debug("Sorting and limiting results numLogs={} partitionId={} maxCommitLogsPerInstance={}", new Object[]{logs.size(), partitionId, maxCommitLogsPerInstance});
        }
        return logs.stream().sorted(CommitLog::compareTo).filter(log -> CdcScannerBuilder.greaterThanOrEqualToStartMarker(log, markers, stats, partitionId)).limit(maxCommitLogsPerInstance <= 0 ? Long.MAX_VALUE : (long)maxCommitLogsPerInstance);
    }

    private CompletableFuture<List<CommitLogReader.Result>> openInstance(@NotNull List<CommitLog> logs, int maxCommitLogsPerInstance, @NotNull CommitLogMarkers markers, @NotNull AsyncExecutor executor) {
        logs = CdcScannerBuilder.sortAndLimit(this.partitionId, logs, maxCommitLogsPerInstance, markers, this.stats).collect(Collectors.toList());
        return this.openLogs(0, logs, markers, executor, (ImmutableList<CommitLogReader.Result>)ImmutableList.of());
    }

    private CompletableFuture<List<CommitLogReader.Result>> openLogs(int index, @NotNull List<CommitLog> logs, @NotNull CommitLogMarkers markers, @NotNull AsyncExecutor executor, @NotNull ImmutableList<CommitLogReader.Result> previous) {
        if (index >= logs.size()) {
            return CompletableFuture.completedFuture(ImmutableList.of());
        }
        CommitLog log = logs.get(index);
        return ((CompletableFuture)executor.submit(() -> this.openReader(log, markers)).thenCompose(result -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll((Iterable)previous);
            if (!result.wasSkipped()) {
                builder.add(result);
            }
            ImmutableList merged = builder.build();
            if (result.isFullyRead() && index + 1 < logs.size()) {
                return this.openLogs(index + 1, logs, markers, executor, (ImmutableList<CommitLogReader.Result>)merged);
            }
            return CompletableFuture.completedFuture(merged);
        })).handle((list, throwable) -> {
            if (throwable != null) {
                LOGGER.warn("Failed to open CommitLog instance={} log={} high={} partitionId={}", new Object[]{log.instance().nodeName(), log.name(), markers.startMarker(log), this.partitionId});
                return previous;
            }
            return list;
        });
    }

    @NotNull
    private CommitLogReader.Result openReader(@NotNull CommitLog log, @NotNull CommitLogMarkers markers) {
        LOGGER.debug("Opening BufferingCommitLogReader instance={} log={} high={} partitionId={}", new Object[]{log.instance().nodeName(), log.name(), markers.startMarker(log), this.partitionId});
        return (CommitLogReader.Result)StatsUtil.reportTimeTaken(() -> this.cdcBridge.readLog(log, this.tokenRange, markers, this.partitionId, this.stats, this.executor, null, this.cdcOptions.discardOldMutations() ? Long.valueOf(this.startTimestampMicroseconds) : null, this.readCommitLogHeader), commitLogReadTime -> {
            LOGGER.debug("Finished reading log on instance instance={} log={} partitionId={} timeNanos={}", new Object[]{log.instance().nodeName(), log.name(), this.partitionId, commitLogReadTime});
            this.stats.commitLogReadTime(commitLogReadTime);
            this.stats.commitLogBytesFetched(log.length());
        });
    }

    public CdcStreamScanner build() {
        List updates = this.futures.values().stream().map(future -> FutureUtils.await((CompletableFuture)future, throwable -> LOGGER.warn("Failed to read instance with error", throwable))).filter(FutureUtils.FutureResult::isSuccess).map(FutureUtils.FutureResult::value).filter(Objects::nonNull).flatMap(Collection::stream).flatMap(f -> f.updates().stream()).collect(Collectors.toList());
        this.stats.mutationsReadPerBatch((long)updates.size());
        CdcState.Mutator stateMutator = this.startState.mutate();
        Collection filteredUpdates = (Collection)StatsUtil.reportTimeTaken(() -> this.filterValidUpdates(updates, stateMutator), arg_0 -> ((ICdcStats)this.stats).mutationsFilterTime(arg_0));
        long now = System.currentTimeMillis();
        filteredUpdates.forEach(update -> this.stats.changeReceived(update.keyspace(), update.table(), now - TimeUnit.MICROSECONDS.toMillis(update.maxTimestampMicros())));
        if (stateMutator.isFull(this.cdcOptions)) {
            int cdcStateSize = stateMutator.size();
            this.futures.clear();
            LOGGER.error("Watermarker has exceeded max permitted size watermarkerSize={} maxCdcStateSize={}", (Object)cdcStateSize, (Object)this.cdcOptions.maxCdcStateSize());
            this.stats.watermarkerExceededSize(cdcStateSize);
            throw new RuntimeException("Watermark state has exceeded max permitted size: " + cdcStateSize);
        }
        this.futures.forEach((instance, future) -> {
            if (!future.isCompletedExceptionally()) {
                ((List)future.join()).stream().map(CommitLogReader.Result::marker).max(Marker::compareTo).ifPresent(marker -> stateMutator.advanceMarker(instance, marker));
            }
        });
        this.futures.clear();
        long timeTakenToReadBatch = System.nanoTime() - this.startTimeNanos;
        LOGGER.debug("Processed CdcScanner startTimestampMicroseconds={} partitionId={} timeNanos={} updates={}", new Object[]{this.startTimestampMicroseconds, this.partitionId, timeTakenToReadBatch, updates.size()});
        this.stats.mutationsBatchReadTime(timeTakenToReadBatch);
        CdcState endState = stateMutator.nextEpoch().withRange(this.tokenRange).purge(this.stats, Long.valueOf(this.startTimestampMicroseconds)).build();
        return this.buildStreamScanner(filteredUpdates, endState);
    }

    public CdcStreamScanner buildStreamScanner(Collection<PartitionUpdateWrapper> updates, @NotNull CdcState endState) {
        return this.cdcBridge.openCdcStreamScanner(updates, endState, (Random)ThreadLocalRandom.current(), this.cassandraSource, this.cdcOptions.samplingRate().doubleValue());
    }

    private Collection<PartitionUpdateWrapper> filterValidUpdates(Collection<PartitionUpdateWrapper> updates, CdcState.Mutator stateMutator) {
        if (updates.isEmpty()) {
            return updates;
        }
        Map replicaCopies = updates.stream().collect(Collectors.groupingBy(update -> update, Collectors.toList()));
        return replicaCopies.values().stream().filter(update -> this.filter((List<PartitionUpdateWrapper>)update, stateMutator)).map(update -> (PartitionUpdateWrapper)update.get(0)).collect(Collectors.toList());
    }

    private boolean filter(List<PartitionUpdateWrapper> updates, CdcState.Mutator stateMutator) {
        return CdcScannerBuilder.filter(updates, arg_0 -> ((CdcOptions)this.cdcOptions).minimumReplicas(arg_0), stateMutator, this.stats);
    }

    static boolean filter(List<PartitionUpdateWrapper> updates, Function<String, Integer> minimumReplicas, CdcState.Mutator stateMutator, ICdcStats stats) {
        int minimumReplicasPerMutation;
        if (updates.isEmpty()) {
            throw new IllegalStateException("Should not receive empty list of updates");
        }
        PartitionUpdateWrapper update = updates.get(0);
        int numReplicas = updates.size() + stateMutator.replicaCount(update);
        if (numReplicas < (minimumReplicasPerMutation = minimumReplicas.apply(update.keyspace()).intValue())) {
            LOGGER.warn("Ignore the partition update due to insufficient replicas received. required={} received={} keyspace={} table={} watermarkerSize={}", new Object[]{minimumReplicasPerMutation, numReplicas, update.keyspace(), update.table(), stateMutator.size()});
            stateMutator.recordReplicaCount(update, numReplicas);
            stats.insufficientReplicas(update.keyspace(), update.table());
            return false;
        }
        if (updates.stream().anyMatch(arg_0 -> ((CdcState.Mutator)stateMutator).seenBefore(arg_0))) {
            LOGGER.info("Achieved consistency level for late partition update. required={} received={} keyspace={} table={} watermarkerSize={}", new Object[]{minimumReplicasPerMutation, numReplicas, update.keyspace(), update.table(), stateMutator.size()});
            stateMutator.untrackReplicaCount(update);
            stats.lateChangePublished(update.keyspace(), update.table());
            return true;
        }
        stats.changePublished(update.keyspace(), update.table());
        return true;
    }
}

