/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.FastByteOperations;
import org.apache.cassandra.utils.Hex;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.UUIDGen;

public class ByteBufferUtil {
    public static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.wrap(new byte[0]);
    public static final ByteBuffer UNSET_BYTE_BUFFER = ByteBuffer.wrap(new byte[0]);
    public static final ByteBuffer[] EMPTY_ARRAY = new ByteBuffer[0];

    public static int compareUnsigned(ByteBuffer o1, ByteBuffer o2) {
        return FastByteOperations.compareUnsigned(o1, o2);
    }

    public static int compare(byte[] o1, ByteBuffer o2) {
        return FastByteOperations.compareUnsigned(o1, 0, o1.length, o2);
    }

    public static int compare(ByteBuffer o1, byte[] o2) {
        return FastByteOperations.compareUnsigned(o1, o2, 0, o2.length);
    }

    public static int compare(ByteBuffer o1, int s1, int l1, byte[] o2) {
        return FastByteOperations.compareUnsigned(o1, s1, l1, o2, 0, o2.length);
    }

    public static int compare(byte[] o1, ByteBuffer o2, int s2, int l2) {
        return FastByteOperations.compareUnsigned(o1, 0, o1.length, o2, s2, l2);
    }

    public static String string(ByteBuffer buffer) throws CharacterCodingException {
        return ByteBufferUtil.string(buffer, StandardCharsets.UTF_8);
    }

    public static String string(ByteBuffer buffer, int position, int length) throws CharacterCodingException {
        return ByteBufferUtil.string(buffer, position, length, StandardCharsets.UTF_8);
    }

    public static String string(ByteBuffer buffer, int position, int length, Charset charset) throws CharacterCodingException {
        ByteBuffer copy = buffer.duplicate();
        copy.position(position);
        copy.limit(copy.position() + length);
        return ByteBufferUtil.string(copy, charset);
    }

    public static String string(ByteBuffer buffer, Charset charset) throws CharacterCodingException {
        return charset.newDecoder().decode(buffer.duplicate()).toString();
    }

    public static byte[] getArray(ByteBuffer buffer) {
        return ByteBufferUtil.getArray(buffer, buffer.position(), buffer.remaining());
    }

    public static byte[] getArray(ByteBuffer buffer, int position, int length) {
        if (buffer.hasArray()) {
            int boff = buffer.arrayOffset() + position;
            return Arrays.copyOfRange(buffer.array(), boff, boff + length);
        }
        byte[] bytes = new byte[length];
        ByteBuffer dup = buffer.duplicate();
        dup.position(position).limit(position + length);
        dup.get(bytes);
        return bytes;
    }

    public static int lastIndexOf(ByteBuffer buffer, byte valueToFind, int startIndex) {
        assert (buffer != null);
        if (startIndex < buffer.position()) {
            return -1;
        }
        if (startIndex >= buffer.limit()) {
            startIndex = buffer.limit() - 1;
        }
        for (int i = startIndex; i >= buffer.position(); --i) {
            if (valueToFind != buffer.get(i)) continue;
            return i;
        }
        return -1;
    }

    public static ByteBuffer bytes(String s) {
        return ByteBuffer.wrap(s.getBytes(StandardCharsets.UTF_8));
    }

    public static ByteBuffer bytes(String s, Charset charset) {
        return ByteBuffer.wrap(s.getBytes(charset));
    }

    public static ByteBuffer clone(ByteBuffer buffer) {
        assert (buffer != null);
        if (buffer.remaining() == 0) {
            return EMPTY_BYTE_BUFFER;
        }
        ByteBuffer clone = ByteBuffer.allocate(buffer.remaining());
        if (buffer.hasArray()) {
            System.arraycopy(buffer.array(), buffer.arrayOffset() + buffer.position(), clone.array(), 0, buffer.remaining());
        } else {
            clone.put(buffer.duplicate());
            clone.flip();
        }
        return clone;
    }

    public static void copyBytes(ByteBuffer src, int srcPos, byte[] dst, int dstPos, int length) {
        FastByteOperations.copy(src, srcPos, dst, dstPos, length);
    }

    public static void copyBytes(ByteBuffer src, int srcPos, ByteBuffer dst, int dstPos, int length) {
        FastByteOperations.copy(src, srcPos, dst, dstPos, length);
    }

    public static int put(ByteBuffer src, ByteBuffer trg) {
        int length = Math.min(src.remaining(), trg.remaining());
        ByteBufferUtil.copyBytes(src, src.position(), trg, trg.position(), length);
        trg.position(trg.position() + length);
        src.position(src.position() + length);
        return length;
    }

    public static void writeZeroes(ByteBuffer dest, int count) {
        if (count >= 8) {
            while ((dest.position() & 7) != 0) {
                dest.put((byte)0);
                --count;
            }
        }
        while (count >= 8) {
            dest.putLong(0L);
            count -= 8;
        }
        while (count > 0) {
            dest.put((byte)0);
            --count;
        }
    }

    public static void writeWithLength(ByteBuffer bytes, DataOutputPlus out) throws IOException {
        out.writeInt(bytes.remaining());
        out.write(bytes);
    }

    public static void writeWithVIntLength(ByteBuffer bytes, DataOutputPlus out) throws IOException {
        out.writeUnsignedVInt32(bytes.remaining());
        out.write(bytes);
    }

    public static void writeWithShortLength(ByteBuffer buffer, DataOutputPlus out) throws IOException {
        int length = buffer.remaining();
        assert (0 <= length && length <= 65535) : String.format("Attempted serializing to buffer exceeded maximum of %s bytes: %s", 65535, length);
        out.writeShort(length);
        out.write(buffer);
    }

    public static ByteBuffer readWithLength(DataInput in) throws IOException {
        int length = in.readInt();
        if (length < 0) {
            throw new IOException("Corrupt (negative) value length encountered");
        }
        return ByteBufferUtil.read(in, length);
    }

    public static ByteBuffer readWithVIntLength(DataInputPlus in) throws IOException {
        int length = in.readUnsignedVInt32();
        if (length < 0) {
            throw new IOException("Corrupt (negative) value length encountered");
        }
        return ByteBufferUtil.read(in, length);
    }

    public static int serializedSizeWithLength(ByteBuffer buffer) {
        int size = buffer.remaining();
        return TypeSizes.sizeof(size) + size;
    }

    public static int serializedSizeWithVIntLength(ByteBuffer buffer) {
        int size = buffer.remaining();
        return TypeSizes.sizeofUnsignedVInt(size) + size;
    }

    public static void skipWithVIntLength(DataInputPlus in) throws IOException {
        int length = in.readUnsignedVInt32();
        if (length < 0) {
            throw new IOException("Corrupt (negative) value length encountered");
        }
        in.skipBytesFully(length);
    }

    public static int readShortLength(DataInput in) throws IOException {
        return in.readUnsignedShort();
    }

    public static ByteBuffer readWithShortLength(DataInput in) throws IOException {
        return ByteBufferUtil.read(in, ByteBufferUtil.readShortLength(in));
    }

    public static int serializedSizeWithShortLength(ByteBuffer buffer) {
        int size = buffer.remaining();
        return TypeSizes.sizeof((short)size) + size;
    }

    public static void skipShortLength(DataInputPlus in) throws IOException {
        int skip = ByteBufferUtil.readShortLength(in);
        in.skipBytesFully(skip);
    }

    public static ByteBuffer read(DataInput in, int length) throws IOException {
        if (length == 0) {
            return EMPTY_BYTE_BUFFER;
        }
        byte[] buff = new byte[length];
        in.readFully(buff);
        return ByteBuffer.wrap(buff);
    }

    public static byte[] readBytes(DataInput in, int length) throws IOException {
        assert (length > 0) : "length is not > 0: " + length;
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        return bytes;
    }

    public static byte[] readBytesWithLength(DataInput in) throws IOException {
        int length = in.readInt();
        if (length < 0) {
            throw new IOException("Corrupt (negative) value length encountered");
        }
        return ByteBufferUtil.readBytes(in, length);
    }

    public static int toInt(ByteBuffer bytes) {
        return bytes.getInt(bytes.position());
    }

    public static short toShort(ByteBuffer bytes) {
        return bytes.getShort(bytes.position());
    }

    public static byte toByte(ByteBuffer bytes) {
        return bytes.get(bytes.position());
    }

    public static long toLong(ByteBuffer bytes) {
        return bytes.getLong(bytes.position());
    }

    public static float toFloat(ByteBuffer bytes) {
        return bytes.getFloat(bytes.position());
    }

    public static float getFloat(ByteBuffer bytes, int offset) {
        return bytes.getFloat(offset);
    }

    public static double toDouble(ByteBuffer bytes) {
        return bytes.getDouble(bytes.position());
    }

    public static ByteBuffer objectToBytes(Object obj) {
        if (obj instanceof Integer) {
            return ByteBufferUtil.bytes((Integer)obj);
        }
        if (obj instanceof Byte) {
            return ByteBufferUtil.bytes((Byte)obj);
        }
        if (obj instanceof Short) {
            return ByteBufferUtil.bytes((Short)obj);
        }
        if (obj instanceof Long) {
            return ByteBufferUtil.bytes((Long)obj);
        }
        if (obj instanceof Float) {
            return ByteBufferUtil.bytes(((Float)obj).floatValue());
        }
        if (obj instanceof Double) {
            return ByteBufferUtil.bytes((Double)obj);
        }
        if (obj instanceof UUID) {
            return ByteBufferUtil.bytes((UUID)obj);
        }
        if (obj instanceof InetAddress) {
            return ByteBufferUtil.bytes((InetAddress)obj);
        }
        if (obj instanceof String) {
            return ByteBufferUtil.bytes((String)obj);
        }
        if (obj instanceof byte[]) {
            return ByteBuffer.wrap((byte[])obj);
        }
        if (obj instanceof ByteBuffer) {
            return (ByteBuffer)obj;
        }
        if (obj instanceof Set) {
            Set set = (Set)obj;
            LinkedHashSet<ByteBuffer> bbs = new LinkedHashSet<ByteBuffer>();
            for (Object o : set) {
                if (bbs.add(ByteBufferUtil.objectToBytes(o))) continue;
                throw new IllegalStateException("Object " + o + " maps to a buffer that already exists in the set");
            }
            return SetType.getInstance(BytesType.instance, false).decompose((ByteBuffer)((Object)bbs));
        }
        throw new IllegalArgumentException(String.format("Cannot convert value %s of type %s", obj, obj.getClass()));
    }

    public static ByteBuffer bytes(byte b) {
        return ByteBuffer.allocate(1).put(0, b);
    }

    public static ByteBuffer bytes(short s) {
        return ByteBuffer.allocate(2).putShort(0, s);
    }

    public static ByteBuffer bytes(int i) {
        return ByteBuffer.allocate(4).putInt(0, i);
    }

    public static ByteBuffer bytes(long n) {
        return ByteBuffer.allocate(8).putLong(0, n);
    }

    public static ByteBuffer bytes(float f) {
        return ByteBuffer.allocate(4).putFloat(0, f);
    }

    public static ByteBuffer bytes(double d) {
        return ByteBuffer.allocate(8).putDouble(0, d);
    }

    public static InputStream inputStream(ByteBuffer bytes) {
        final ByteBuffer copy = bytes.duplicate();
        return new InputStream(){

            @Override
            public int read() {
                if (!copy.hasRemaining()) {
                    return -1;
                }
                return copy.get() & 0xFF;
            }

            @Override
            public int read(byte[] bytes, int off, int len) {
                if (!copy.hasRemaining()) {
                    return -1;
                }
                len = Math.min(len, copy.remaining());
                copy.get(bytes, off, len);
                return len;
            }

            @Override
            public int available() {
                return copy.remaining();
            }
        };
    }

    public static String bytesToHex(ByteBuffer bytes) {
        if (bytes.hasArray()) {
            return Hex.bytesToHex(bytes.array(), bytes.arrayOffset() + bytes.position(), bytes.remaining());
        }
        int offset = bytes.position();
        int size = bytes.remaining();
        char[] c = new char[size * 2];
        for (int i = 0; i < size; ++i) {
            byte bint = bytes.get(i + offset);
            c[i * 2] = Hex.byteToChar[(bint & 0xF0) >> 4];
            c[1 + i * 2] = Hex.byteToChar[bint & 0xF];
        }
        return Hex.wrapCharArray(c);
    }

    public static ByteBuffer hexToBytes(String str) {
        return ByteBuffer.wrap(Hex.hexToBytes(str));
    }

    public static int compareSubArrays(ByteBuffer bytes1, int offset1, ByteBuffer bytes2, int offset2, int length) {
        if (bytes1 == null) {
            return bytes2 == null ? 0 : -1;
        }
        if (bytes2 == null) {
            return 1;
        }
        assert (bytes1.limit() >= offset1 + length) : "The first byte array isn't long enough for the specified offset and length.";
        assert (bytes2.limit() >= offset2 + length) : "The second byte array isn't long enough for the specified offset and length.";
        for (int i = 0; i < length; ++i) {
            byte byte2;
            byte byte1 = bytes1.get(offset1 + i);
            if (byte1 == (byte2 = bytes2.get(offset2 + i))) continue;
            return (byte1 & 0xFF) < (byte2 & 0xFF) ? -1 : 1;
        }
        return 0;
    }

    public static ByteBuffer bytes(InetAddress address) {
        return ByteBuffer.wrap(address.getAddress());
    }

    public static ByteBuffer bytes(UUID uuid) {
        return ByteBuffer.wrap(UUIDGen.decompose(uuid));
    }

    public static ByteBuffer bytes(TimeUUID uuid) {
        return ByteBufferUtil.bytes(uuid.asUUID());
    }

    public static boolean isPrefix(ByteBuffer prefix, ByteBuffer value) {
        if (prefix.remaining() > value.remaining()) {
            return false;
        }
        int diff = value.remaining() - prefix.remaining();
        return prefix.equals(value.duplicate().limit(value.remaining() - diff));
    }

    public static boolean canMinimize(ByteBuffer buf) {
        return buf != null && (!buf.hasArray() || buf.array().length > buf.remaining());
    }

    public static ByteBuffer minimalBufferFor(ByteBuffer buf) {
        return !buf.hasArray() || buf.array().length > buf.remaining() ? ByteBuffer.wrap(ByteBufferUtil.getArray(buf)) : buf;
    }

    public static ByteBuffer[] minimizeBuffers(ByteBuffer[] src) {
        ByteBuffer[] dst = new ByteBuffer[src.length];
        for (int i = 0; i < src.length; ++i) {
            dst[i] = src[i] != null ? ByteBufferUtil.minimalBufferFor(src[i]) : null;
        }
        return dst;
    }

    public static boolean canMinimize(ByteBuffer[] src) {
        for (ByteBuffer buffer : src) {
            if (!ByteBufferUtil.canMinimize(buffer)) continue;
            return true;
        }
        return false;
    }

    public static int getUnsignedShort(ByteBuffer bb, int position) {
        return (bb.get(position) & 0xFF) << 8 | bb.get(position + 1) & 0xFF;
    }

    public static int getShortLength(ByteBuffer bb, int position) {
        return ByteBufferUtil.getUnsignedShort(bb, position);
    }

    public static int readShortLength(ByteBuffer bb) {
        int length = (bb.get() & 0xFF) << 8;
        return length | bb.get() & 0xFF;
    }

    public static void writeShortLength(ByteBuffer bb, int length) {
        if (length > 65535) {
            throw new IllegalArgumentException(String.format("Length %d > max length %d", length, 65535));
        }
        bb.put((byte)(length >> 8 & 0xFF));
        bb.put((byte)(length & 0xFF));
    }

    public static ByteBuffer readBytes(ByteBuffer bb, int length) {
        ByteBuffer copy = bb.duplicate();
        copy.limit(copy.position() + length);
        bb.position(bb.position() + length);
        return copy;
    }

    public static ByteBuffer readBytesWithShortLength(ByteBuffer bb) {
        int length = ByteBufferUtil.readShortLength(bb);
        return ByteBufferUtil.readBytes(bb, length);
    }

    public static ByteBuffer ensureCapacity(ByteBuffer buf, int outputLength, boolean allowBufferResize) {
        BufferType bufferType = buf != null ? BufferType.typeOf(buf) : BufferType.ON_HEAP;
        return ByteBufferUtil.ensureCapacity(buf, outputLength, allowBufferResize, bufferType);
    }

    public static ByteBuffer ensureCapacity(ByteBuffer buf, int outputLength, boolean allowBufferResize, BufferType bufferType) {
        if (0 > outputLength) {
            throw new IllegalArgumentException("invalid size for output buffer: " + outputLength);
        }
        if (buf == null || buf.capacity() < outputLength) {
            if (!allowBufferResize) {
                throw new IllegalStateException(String.format("output buffer is not large enough for data: current capacity %d, required %d", buf.capacity(), outputLength));
            }
            FileUtils.clean(buf);
            buf = bufferType.allocate(outputLength);
        } else {
            buf.position(0).limit(outputLength);
        }
        return buf;
    }

    public static boolean contains(ByteBuffer buffer, ByteBuffer subBuffer) {
        int len = subBuffer.remaining();
        if (buffer.remaining() - len < 0) {
            return false;
        }
        byte first = subBuffer.get(subBuffer.position());
        int max = buffer.position() + (buffer.remaining() - len);
        for (int i = buffer.position(); i <= max; ++i) {
            if (buffer.get(i) != first) {
                while (++i <= max && buffer.get(i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + len - 1;
            int k = 1 + subBuffer.position();
            while (j < end && buffer.get(j) == subBuffer.get(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWith(ByteBuffer src, ByteBuffer prefix) {
        return ByteBufferUtil.startsWith(src, prefix, 0);
    }

    public static boolean endsWith(ByteBuffer src, ByteBuffer suffix) {
        return ByteBufferUtil.startsWith(src, suffix, src.remaining() - suffix.remaining());
    }

    private static boolean startsWith(ByteBuffer src, ByteBuffer prefix, int offset) {
        if (offset < 0) {
            return false;
        }
        int sPos = src.position() + offset;
        int pPos = prefix.position();
        if (src.remaining() - offset < prefix.remaining()) {
            return false;
        }
        int len = Math.min(src.remaining() - offset, prefix.remaining());
        while (len-- > 0) {
            if (src.get(sPos++) == prefix.get(pPos++)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsWithShortLength(DataInput in, ByteBuffer toMatch) throws IOException {
        int length = ByteBufferUtil.readShortLength(in);
        if (length != toMatch.remaining()) {
            return false;
        }
        int limit = toMatch.limit();
        for (int i = toMatch.position(); i < limit; ++i) {
            if (toMatch.get(i) == in.readByte()) continue;
            return false;
        }
        return true;
    }

    public static void readFully(FileChannel channel, ByteBuffer dst, long position) throws IOException {
        while (dst.hasRemaining()) {
            int read = channel.read(dst, position);
            if (read == -1) {
                throw new EOFException();
            }
            position += (long)read;
        }
    }
}

