/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.EvpKey;
import com.amazon.corretto.crypto.provider.EvpKeyType;
import com.amazon.corretto.crypto.provider.Loader;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.regex.Pattern;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

class EvpKeyAgreement
extends KeyAgreementSpi {
    private static final int[] AES_KEYSIZES_BYTES = new int[]{16, 24, 32};
    private static final Pattern ALGORITHM_WITH_EXPLICIT_KEYSIZE = Pattern.compile("(\\S+?)(?:\\[(\\d+)\\])?");
    private final AmazonCorrettoCryptoProvider provider_;
    private final EvpKeyType keyType_;
    private final String algorithm_;
    private EvpKey privKey = null;
    private byte[] secret = null;

    private static native byte[] agree(long var0, long var2) throws InvalidKeyException;

    EvpKeyAgreement(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider, String string, EvpKeyType evpKeyType) {
        Loader.checkNativeLibraryAvailability();
        this.provider_ = amazonCorrettoCryptoProvider;
        this.algorithm_ = string;
        this.keyType_ = evpKeyType;
    }

    private byte[] agree(EvpKey evpKey) throws InvalidKeyException {
        return this.privKey.use(l -> evpKey.use(l2 -> EvpKeyAgreement.agree(l, l2)));
    }

    @Override
    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (this.privKey == null) {
            throw new IllegalStateException("KeyAgreement has not been initialized");
        }
        if (!this.keyType_.publicKeyClass.isAssignableFrom(key.getClass())) {
            throw new InvalidKeyException("Expected key of type " + this.keyType_.publicKeyClass + " not " + key.getClass());
        }
        EvpKey evpKey = this.provider_.translateKey(key, this.keyType_);
        try {
            if (bl) {
                this.secret = this.agree(evpKey);
                Key key2 = null;
                return key2;
            }
            this.secret = null;
            throw new IllegalStateException("Only single phase agreement is supported");
        }
        finally {
            evpKey.releaseEphemeral();
        }
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.privKey == null) {
            throw new IllegalStateException("KeyAgreement has not been initialized");
        }
        if (this.secret == null) {
            throw new IllegalStateException("KeyAgreement has not been completed");
        }
        byte[] byArray = this.secret;
        this.reset();
        return byArray;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected SecretKey engineGenerateSecret(String var1_1) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        block10: {
            var2_2 = this.engineGenerateSecret();
            if (var1_1.equalsIgnoreCase("TlsPremasterSecret")) {
                return new SecretKeySpec(var2_2, "TlsPremasterSecret");
            }
            var3_3 = EvpKeyAgreement.ALGORITHM_WITH_EXPLICIT_KEYSIZE.matcher(var1_1);
            if (!var3_3.matches()) break block10;
            var4_4 = var3_3.group(1);
            var5_5 = -1;
            switch (var4_4.hashCode()) {
                case 64687: {
                    if (!var4_4.equals("AES")) break;
                    var5_5 = 0;
                }
            }
            switch (var5_5) {
                case 0: {
                    var6_6 = var3_3.group(2);
                    var7_7 = 0;
                    var8_8 = false;
                    if (var6_6 == null) ** GOTO lbl24
                    var7_7 = Integer.parseInt(var6_6);
                    for (int var12_15 : EvpKeyAgreement.AES_KEYSIZES_BYTES) {
                        if (var12_15 != var7_7) continue;
                        var8_8 = true;
                        ** GOTO lbl29
                    }
                    ** GOTO lbl29
lbl24:
                    // 3 sources

                    for (int var12_16 : EvpKeyAgreement.AES_KEYSIZES_BYTES) {
                        if (var12_16 > var2_2.length) continue;
                        var7_7 = var12_16;
                        var8_8 = true;
                    }
lbl29:
                    // 3 sources

                    if (!var8_8 || var7_7 > var2_2.length) {
                        throw new InvalidKeyException("Invalid key length");
                    }
                    return new SecretKeySpec(var2_2, 0, var7_7, "AES");
                }
            }
            throw new InvalidKeyException("Unsupported algorithm: " + var3_3.group(1));
        }
        throw new InvalidKeyException("Unrecognized algorithm: " + var1_1);
    }

    @Override
    protected int engineGenerateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        byte[] byArray2 = this.engineGenerateSecret();
        if (byArray.length - n < byArray2.length) {
            throw new ShortBufferException();
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        this.reset();
        return byArray2.length;
    }

    @Override
    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (!this.keyType_.privateKeyClass.isAssignableFrom(key.getClass())) {
            throw new InvalidKeyException("Expected key of type " + this.keyType_.privateKeyClass + " not " + key.getClass());
        }
        if (this.privKey != null) {
            this.privKey.releaseEphemeral();
        }
        this.privKey = this.provider_.translateKey(key, this.keyType_);
        this.reset();
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("No algorithm parameter spec expected");
        }
        this.engineInit(key, secureRandom);
    }

    protected void reset() {
        this.secret = null;
    }

    static class ECDH
    extends EvpKeyAgreement {
        ECDH(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, "ECDH", EvpKeyType.EC);
        }
    }
}

