/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.EcUtils;
import com.amazon.corretto.crypto.provider.RuntimeCryptoException;
import com.amazon.corretto.crypto.provider.Utils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public final class EcParameters
extends AlgorithmParametersSpi {
    private EcUtils.ECInfo ecInfo;

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec == null) {
            throw new InvalidParameterSpecException("paramSpec must not be null");
        }
        String string = null;
        if (algorithmParameterSpec instanceof ECParameterSpec) {
            string = EcUtils.getNameBySpec((ECParameterSpec)algorithmParameterSpec);
            if (Utils.getJavaVersion() < 11) {
                string = EcUtils.getOidFromName(string);
            }
        } else if (algorithmParameterSpec instanceof ECGenParameterSpec) {
            string = ((ECGenParameterSpec)algorithmParameterSpec).getName();
        } else if ("sun.security.util.ECKeySizeParameterSpec".equals(algorithmParameterSpec.getClass().getName())) {
            try {
                Method method = algorithmParameterSpec.getClass().getMethod("getKeySize", new Class[0]);
                Integer n = (Integer)Integer.class.cast(method.invoke((Object)algorithmParameterSpec, new Object[0]));
                string = EcUtils.getNameByKeySize(n);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        if (string == null) {
            throw new InvalidParameterSpecException("Only ECParameterSpec and ECGenParameterSpec supported");
        }
        this.ecInfo = EcUtils.getSpecByName(string);
        if (this.ecInfo == null) {
            throw new InvalidParameterSpecException("Unknown curve: " + algorithmParameterSpec);
        }
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        String string = null;
        try {
            string = EcUtils.getNameByEncoded(byArray);
        }
        catch (RuntimeCryptoException runtimeCryptoException) {
            // empty catch block
        }
        if (string == null) {
            throw new IOException("Only named EcParameters supported");
        }
        this.ecInfo = EcUtils.getSpecByName(string);
        if (this.ecInfo == null) {
            throw new IOException("Unknown named curve: " + string);
        }
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        if (clazz.isAssignableFrom(ECParameterSpec.class)) {
            return (T)((AlgorithmParameterSpec)clazz.cast(this.ecInfo.spec));
        }
        if (clazz.isAssignableFrom(ECGenParameterSpec.class)) {
            return (T)((AlgorithmParameterSpec)clazz.cast(new ECGenParameterSpec(this.ecInfo.name)));
        }
        throw new InvalidParameterSpecException("Only ECParameterSpec and ECGenParameterSpec supported");
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        return (byte[])this.ecInfo.encoded.clone();
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        if (this.ecInfo == null) {
            return "Not initialized";
        }
        return this.ecInfo.name;
    }
}

