//
// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to you under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.25.1
// source: requests.proto

package message

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request for Meta#getCatalogs()
type CatalogsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConnectionId string `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
}

func (x *CatalogsRequest) Reset() {
	*x = CatalogsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_requests_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CatalogsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CatalogsRequest) ProtoMessage() {}

func (x *CatalogsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_requests_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CatalogsRequest.ProtoReflect.Descriptor instead.
func (*CatalogsRequest) Descriptor() ([]byte, []int) {
	return file_requests_proto_rawDescGZIP(), []int{0}
}

func (x *CatalogsRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

// Request for Meta#getDatabaseProperties()
type DatabasePropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConnectionId string `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
}

func (x *DatabasePropertyRequest) Reset() {
	*x = DatabasePropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_requests_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabasePropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabasePropertyRequest) ProtoMessage() {}

func (x *DatabasePropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_requests_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabasePropertyRequest.ProtoReflect.Descriptor instead.
func (*DatabasePropertyRequest) Descriptor() ([]byte, []int) {
	return file_requests_proto_rawDescGZIP(), []int{1}
}

func (x *DatabasePropertyRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

// Request for Meta#getSchemas(String, org.apache.calcite.avatica.Meta.Pat)}
type SchemasRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Catalog          string `protobuf:"bytes,1,opt,name=catalog,proto3" json:"catalog,omitempty"`
	SchemaPattern    string `protobuf:"bytes,2,opt,name=schema_pattern,json=schemaPattern,proto3" json:"schema_pattern,omitempty"`
	ConnectionId     string `protobuf:"bytes,3,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
	HasCatalog       bool   `protobuf:"varint,4,opt,name=has_catalog,json=hasCatalog,proto3" json:"has_catalog,omitempty"`
	HasSchemaPattern bool   `protobuf:"varint,5,opt,name=has_schema_pattern,json=hasSchemaPattern,proto3" json:"has_schema_pattern,omitempty"`
}

func (x *SchemasRequest) Reset() {
	*x = SchemasRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_requests_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SchemasRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchemasRequest) ProtoMessage() {}

func (x *SchemasRequest) ProtoReflect() protoreflect.Message {
	mi := &file_requests_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchemasRequest.ProtoReflect.Descriptor instead.
func (*SchemasRequest) Descriptor() ([]byte, []int) {
	return file_requests_proto_rawDescGZIP(), []int{2}
}

func (x *SchemasRequest) GetCatalog() string {
	if x != nil {
		return x.Catalog
	}
	return ""
}

func (x *SchemasRequest) GetSchemaPattern() string {
	if x != nil {
		return x.SchemaPattern
	}
	return ""
}

func (x *SchemasRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

func (x *SchemasRequest) GetHasCatalog() bool {
	if x != nil {
		return x.HasCatalog
	}
	return false
}

func (x *SchemasRequest) GetHasSchemaPattern() bool {
	if x != nil {
		return x.HasSchemaPattern
	}
	return false
}

// Request for Request for Meta#getTables(String, org.apache.calcite.avatica.Meta.Pat,
//
//	org.apache.calcite.avatica.Meta.Pat, java.util.List)
type TablesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Catalog             string   `protobuf:"bytes,1,opt,name=catalog,proto3" json:"catalog,omitempty"`
	SchemaPattern       string   `protobuf:"bytes,2,opt,name=schema_pattern,json=schemaPattern,proto3" json:"schema_pattern,omitempty"`
	TableNamePattern    string   `protobuf:"bytes,3,opt,name=table_name_pattern,json=tableNamePattern,proto3" json:"table_name_pattern,omitempty"`
	TypeList            []string `protobuf:"bytes,4,rep,name=type_list,json=typeList,proto3" json:"type_list,omitempty"`
	HasTypeList         bool     `protobuf:"varint,6,opt,name=has_type_list,json=hasTypeList,proto3" json:"has_type_list,omitempty"` // Having an empty type_list is distinct from a null type_list
	ConnectionId        string   `protobuf:"bytes,7,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
	HasCatalog          bool     `protobuf:"varint,8,opt,name=has_catalog,json=hasCatalog,proto3" json:"has_catalog,omitempty"`
	HasSchemaPattern    bool     `protobuf:"varint,9,opt,name=has_schema_pattern,json=hasSchemaPattern,proto3" json:"has_schema_pattern,omitempty"`
	HasTableNamePattern bool     `protobuf:"varint,10,opt,name=has_table_name_pattern,json=hasTableNamePattern,proto3" json:"has_table_name_pattern,omitempty"`
}

func (x *TablesRequest) Reset() {
	*x = TablesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_requests_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TablesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TablesRequest) ProtoMessage() {}

func (x *TablesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_requests_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TablesRequest.ProtoReflect.Descriptor instead.
func (*TablesRequest) Descriptor() ([]byte, []int) {
	return file_requests_proto_rawDescGZIP(), []int{3}
}

func (x *TablesRequest) GetCatalog() string {
	if x != nil {
		return x.Catalog
	}
	return ""
}

func (x *TablesRequest) GetSchemaPattern() string {
	if x != nil {
		return x.SchemaPattern
	}
	return ""
}

func (x *TablesRequest) GetTableNamePattern() string {
	if x != nil {
		return x.TableNamePattern
	}
	return ""
}

func (x *TablesRequest) GetTypeList() []string {
	if x != nil {
		return x.TypeList
	}
	return nil
}

func (x *TablesRequest) GetHasTypeList() bool {
	if x != nil {
		return x.HasTypeList
	}
	return false
}

func (x *TablesRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

func (x *TablesRequest) GetHasCatalog() bool {
	if x != nil {
		return x.HasCatalog
	}
	return false
}

func (x *TablesRequest) GetHasSchemaPattern() bool {
	if x != nil {
		return x.HasSchemaPattern
	}
	return false
}

func (x *TablesRequest) GetHasTableNamePattern() bool {
	if x != nil {
		return x.HasTableNamePattern
	}
	return false
}

// Request for Meta#getTableTypes()
type TableTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConnectionId string `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
}

func (x *TableTypesRequest) Reset() {
	*x = TableTypesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_requests_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableTypesRequest) ProtoMessage() {}

func (x *TableTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_requests_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableTypesRequest.ProtoReflect.Descriptor instead.
func (*TableTypesRequest) Descriptor() ([]byte, []int) {
	return file_requests_proto_rawDescGZIP(), []int{4}
}

func (x *TableTypesRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

// Request for Meta#getColumns(String, org.apache.calcite.avatica.Meta.Pat,
//
//	org.apache.calcite.avatica.Meta.Pat, org.apache.calcite.avatica.Meta.Pat).
type ColumnsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Catalog              string `protobuf:"bytes,1,opt,name=catalog,proto3" json:"catalog,omitempty"`
	SchemaPattern        string `protobuf:"bytes,2,opt,name=schema_pattern,json=schemaPattern,proto3" json:"schema_pattern,omitempty"`
	TableNamePattern     string `protobuf:"bytes,3,opt,name=table_name_pattern,json=tableNamePattern,proto3" json:"table_name_pattern,omitempty"`
	ColumnNamePattern    string `protobuf:"bytes,4,opt,name=column_name_pattern,json=columnNamePattern,proto3" json:"column_name_pattern,omitempty"`
	ConnectionId         string `protobuf:"bytes,5,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
	HasCatalog           bool   `protobuf:"varint,6,opt,name=has_catalog,json=hasCatalog,proto3" json:"has_catalog,omitempty"`
	HasSchemaPattern     bool   `protobuf:"varint,7,opt,name=has_schema_pattern,json=hasSchemaPattern,proto3" json:"has_schema_pattern,omitempty"`
	HasTableNamePattern  bool   `protobuf:"varint,8,opt,name=has_table_name_pattern,json=hasTableNamePattern,proto3" json:"has_table_name_pattern,omitempty"`
	HasColumnNamePattern bool   `protobuf:"varint,9,opt,name=has_column_name_pattern,json=hasColumnNamePattern,proto3" json:"has_column_name_pattern,omitempty"`
}

func (x *ColumnsRequest) Reset() {
	*x = ColumnsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_requests_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ColumnsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ColumnsRequest) ProtoMessage() {}

func (x *ColumnsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_requests_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ColumnsRequest.ProtoReflect.Descriptor instead.
func (*ColumnsRequest) Descriptor() ([]byte, []int) {
	return file_requests_proto_rawDescGZIP(), []int{5}
}

func (x *ColumnsRequest) GetCatalog() string {
	if x != nil {
		return x.Catalog
	}
	return ""
}

func (x *ColumnsRequest) GetSchemaPattern() string {
	if x != nil {
		return x.SchemaPattern
	}
	return ""
}

func (x *ColumnsRequest) GetTableNamePattern() string {
	if x != nil {
		return x.TableNamePattern
	}
	return ""
}

func (x *ColumnsRequest) GetColumnNamePattern() string {
	if x != nil {
		return x.ColumnNamePattern
	}
	return ""
}

func (x *ColumnsRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

func (x *ColumnsRequest) GetHasCatalog() bool {
	if x != nil {
		return x.HasCatalog
	}
	return false
}

func (x *ColumnsRequest) GetHasSchemaPattern() bool {
	if x != nil {
		return x.HasSchemaPattern
	}
	return false
}

func (x *ColumnsRequest) GetHasTableNamePattern() bool {
	if x != nil {
		return x.HasTableNamePattern
	}
	return false
}

func (x *ColumnsRequest) GetHasColumnNamePattern() bool {
	if x != nil {
		return x.HasColumnNamePattern
	}
	return false
}

// Request for Meta#getTypeInfo()
type TypeInfoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConnectionId string `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
}

func (x *TypeInfoRequest) Reset() {
	*x = TypeInfoRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_requests_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TypeInfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TypeInfoRequest) ProtoMessage() {}

func (x *TypeInfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_requests_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TypeInfoRequest.ProtoReflect.Descriptor instead.
func (*TypeInfoRequest) Descriptor() ([]byte, []int) {
	return file_requests_proto_rawDescGZIP(), []int{6}
}

func (x *TypeInfoRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

// Request for Meta#prepareAndExecute(Meta.StatementHandle, String, long, Meta.PrepareCallback)
type PrepareAndExecuteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConnectionId      string `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
	Sql               string `protobuf:"bytes,2,opt,name=sql,proto3" json:"sql,omitempty"`
	MaxRowCount       uint64 `protobuf:"varint,3,opt,name=max_row_count,json=maxRowCount,proto3" json:"max_row_count,omitempty"` // Deprecated
	StatementId       uint32 `protobuf:"varint,4,opt,name=statement_id,json=statementId,proto3" json:"statement_id,omitempty"`
	MaxRowsTotal      int64  `protobuf:"varint,5,opt,name=max_rows_total,json=maxRowsTotal,proto3" json:"max_rows_total,omitempty"`                  // The maximum number of rows that will be allowed for this query
	FirstFrameMaxSize int32  `protobuf:"varint,6,opt,name=first_frame_max_size,json=firstFrameMaxSize,proto3" json:"first_frame_max_size,omitempty"` // The maximum number of rows that will be returned in the
}

func (x *PrepareAndExecuteRequest) Reset() {
	*x = PrepareAndExecuteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_requests_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrepareAndExecuteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrepareAndExecuteRequest) ProtoMessage() {}

func (x *PrepareAndExecuteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_requests_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrepareAndExecuteRequest.ProtoReflect.Descriptor instead.
func (*PrepareAndExecuteRequest) Descriptor() ([]byte, []int) {
	return file_requests_proto_rawDescGZIP(), []int{7}
}

func (x *PrepareAndExecuteRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

func (x *PrepareAndExecuteRequest) GetSql() string {
	if x != nil {
		return x.Sql
	}
	return ""
}

func (x *PrepareAndExecuteRequest) GetMaxRowCount() uint64 {
	if x != nil {
		return x.MaxRowCount
	}
	return 0
}

func (x *PrepareAndExecuteRequest) GetStatementId() uint32 {
	if x != nil {
		return x.StatementId
	}
	return 0
}

func (x *PrepareAndExecuteRequest) GetMaxRowsTotal() int64 {
	if x != nil {
		return x.MaxRowsTotal
	}
	return 0
}

func (x *PrepareAndExecuteRequest) GetFirstFrameMaxSize() int32 {
	if x != nil {
		return x.FirstFrameMaxSize
	}
	return 0
}

// Request for Meta.prepare(Meta.ConnectionHandle, String, long)
type PrepareRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConnectionId string `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
	Sql          string `protobuf:"bytes,2,opt,name=sql,proto3" json:"sql,omitempty"`
	MaxRowCount  uint64 `protobuf:"varint,3,opt,name=max_row_count,json=maxRowCount,proto3" json:"max_row_count,omitempty"`    // Deprecated
	MaxRowsTotal int64  `protobuf:"varint,4,opt,name=max_rows_total,json=maxRowsTotal,proto3" json:"max_rows_total,omitempty"` // The maximum number of rows that will be allowed for this query
}

func (x *PrepareRequest) Reset() {
	*x = PrepareRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_requests_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrepareRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrepareRequest) ProtoMessage() {}

func (x *PrepareRequest) ProtoReflect() protoreflect.Message {
	mi := &file_requests_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrepareRequest.ProtoReflect.Descriptor instead.
func (*PrepareRequest) Descriptor() ([]byte, []int) {
	return file_requests_proto_rawDescGZIP(), []int{8}
}

func (x *PrepareRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

func (x *PrepareRequest) GetSql() string {
	if x != nil {
		return x.Sql
	}
	return ""
}

func (x *PrepareRequest) GetMaxRowCount() uint64 {
	if x != nil {
		return x.MaxRowCount
	}
	return 0
}

func (x *PrepareRequest) GetMaxRowsTotal() int64 {
	if x != nil {
		return x.MaxRowsTotal
	}
	return 0
}

// Request for Meta#fetch(Meta.StatementHandle, List, long, int)
type FetchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConnectionId     string `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
	StatementId      uint32 `protobuf:"varint,2,opt,name=statement_id,json=statementId,proto3" json:"statement_id,omitempty"`
	Offset           uint64 `protobuf:"varint,3,opt,name=offset,proto3" json:"offset,omitempty"`
	FetchMaxRowCount uint32 `protobuf:"varint,4,opt,name=fetch_max_row_count,json=fetchMaxRowCount,proto3" json:"fetch_max_row_count,omitempty"` // Maximum number of rows to be returned in the frame. Negative means no limit. Deprecated!
	FrameMaxSize     int32  `protobuf:"varint,5,opt,name=frame_max_size,json=frameMaxSize,proto3" json:"frame_max_size,omitempty"`
}

func (x *FetchRequest) Reset() {
	*x = FetchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_requests_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchRequest) ProtoMessage() {}

func (x *FetchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_requests_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchRequest.ProtoReflect.Descriptor instead.
func (*FetchRequest) Descriptor() ([]byte, []int) {
	return file_requests_proto_rawDescGZIP(), []int{9}
}

func (x *FetchRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

func (x *FetchRequest) GetStatementId() uint32 {
	if x != nil {
		return x.StatementId
	}
	return 0
}

func (x *FetchRequest) GetOffset() uint64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *FetchRequest) GetFetchMaxRowCount() uint32 {
	if x != nil {
		return x.FetchMaxRowCount
	}
	return 0
}

func (x *FetchRequest) GetFrameMaxSize() int32 {
	if x != nil {
		return x.FrameMaxSize
	}
	return 0
}

// Request for Meta#createStatement(Meta.ConnectionHandle)
type CreateStatementRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConnectionId string `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
}

func (x *CreateStatementRequest) Reset() {
	*x = CreateStatementRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_requests_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateStatementRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateStatementRequest) ProtoMessage() {}

func (x *CreateStatementRequest) ProtoReflect() protoreflect.Message {
	mi := &file_requests_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateStatementRequest.ProtoReflect.Descriptor instead.
func (*CreateStatementRequest) Descriptor() ([]byte, []int) {
	return file_requests_proto_rawDescGZIP(), []int{10}
}

func (x *CreateStatementRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

// Request for Meta#closeStatement(Meta.StatementHandle)
type CloseStatementRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConnectionId string `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
	StatementId  uint32 `protobuf:"varint,2,opt,name=statement_id,json=statementId,proto3" json:"statement_id,omitempty"`
}

func (x *CloseStatementRequest) Reset() {
	*x = CloseStatementRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_requests_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloseStatementRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseStatementRequest) ProtoMessage() {}

func (x *CloseStatementRequest) ProtoReflect() protoreflect.Message {
	mi := &file_requests_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseStatementRequest.ProtoReflect.Descriptor instead.
func (*CloseStatementRequest) Descriptor() ([]byte, []int) {
	return file_requests_proto_rawDescGZIP(), []int{11}
}

func (x *CloseStatementRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

func (x *CloseStatementRequest) GetStatementId() uint32 {
	if x != nil {
		return x.StatementId
	}
	return 0
}

// Request for Meta#openConnection(Meta.ConnectionHandle, Map<String, String>)
type OpenConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConnectionId string            `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
	Info         map[string]string `protobuf:"bytes,2,rep,name=info,proto3" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *OpenConnectionRequest) Reset() {
	*x = OpenConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_requests_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OpenConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenConnectionRequest) ProtoMessage() {}

func (x *OpenConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_requests_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenConnectionRequest.ProtoReflect.Descriptor instead.
func (*OpenConnectionRequest) Descriptor() ([]byte, []int) {
	return file_requests_proto_rawDescGZIP(), []int{12}
}

func (x *OpenConnectionRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

func (x *OpenConnectionRequest) GetInfo() map[string]string {
	if x != nil {
		return x.Info
	}
	return nil
}

// Request for Meta#closeConnection(Meta.ConnectionHandle)
type CloseConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConnectionId string `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
}

func (x *CloseConnectionRequest) Reset() {
	*x = CloseConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_requests_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloseConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseConnectionRequest) ProtoMessage() {}

func (x *CloseConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_requests_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseConnectionRequest.ProtoReflect.Descriptor instead.
func (*CloseConnectionRequest) Descriptor() ([]byte, []int) {
	return file_requests_proto_rawDescGZIP(), []int{13}
}

func (x *CloseConnectionRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

type ConnectionSyncRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConnectionId string                `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
	ConnProps    *ConnectionProperties `protobuf:"bytes,2,opt,name=conn_props,json=connProps,proto3" json:"conn_props,omitempty"`
}

func (x *ConnectionSyncRequest) Reset() {
	*x = ConnectionSyncRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_requests_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectionSyncRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionSyncRequest) ProtoMessage() {}

func (x *ConnectionSyncRequest) ProtoReflect() protoreflect.Message {
	mi := &file_requests_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionSyncRequest.ProtoReflect.Descriptor instead.
func (*ConnectionSyncRequest) Descriptor() ([]byte, []int) {
	return file_requests_proto_rawDescGZIP(), []int{14}
}

func (x *ConnectionSyncRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

func (x *ConnectionSyncRequest) GetConnProps() *ConnectionProperties {
	if x != nil {
		return x.ConnProps
	}
	return nil
}

// Request for Meta#execute(Meta.ConnectionHandle, list, long)
type ExecuteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StatementHandle             *StatementHandle `protobuf:"bytes,1,opt,name=statementHandle,proto3" json:"statementHandle,omitempty"`
	ParameterValues             []*TypedValue    `protobuf:"bytes,2,rep,name=parameter_values,json=parameterValues,proto3" json:"parameter_values,omitempty"`
	DeprecatedFirstFrameMaxSize uint64           `protobuf:"varint,3,opt,name=deprecated_first_frame_max_size,json=deprecatedFirstFrameMaxSize,proto3" json:"deprecated_first_frame_max_size,omitempty"` // Deprecated, use the signed int instead.
	HasParameterValues          bool             `protobuf:"varint,4,opt,name=has_parameter_values,json=hasParameterValues,proto3" json:"has_parameter_values,omitempty"`
	FirstFrameMaxSize           int32            `protobuf:"varint,5,opt,name=first_frame_max_size,json=firstFrameMaxSize,proto3" json:"first_frame_max_size,omitempty"` // The maximum number of rows to return in the first Frame
}

func (x *ExecuteRequest) Reset() {
	*x = ExecuteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_requests_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteRequest) ProtoMessage() {}

func (x *ExecuteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_requests_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteRequest.ProtoReflect.Descriptor instead.
func (*ExecuteRequest) Descriptor() ([]byte, []int) {
	return file_requests_proto_rawDescGZIP(), []int{15}
}

func (x *ExecuteRequest) GetStatementHandle() *StatementHandle {
	if x != nil {
		return x.StatementHandle
	}
	return nil
}

func (x *ExecuteRequest) GetParameterValues() []*TypedValue {
	if x != nil {
		return x.ParameterValues
	}
	return nil
}

func (x *ExecuteRequest) GetDeprecatedFirstFrameMaxSize() uint64 {
	if x != nil {
		return x.DeprecatedFirstFrameMaxSize
	}
	return 0
}

func (x *ExecuteRequest) GetHasParameterValues() bool {
	if x != nil {
		return x.HasParameterValues
	}
	return false
}

func (x *ExecuteRequest) GetFirstFrameMaxSize() int32 {
	if x != nil {
		return x.FirstFrameMaxSize
	}
	return 0
}

type SyncResultsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConnectionId string      `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
	StatementId  uint32      `protobuf:"varint,2,opt,name=statement_id,json=statementId,proto3" json:"statement_id,omitempty"`
	State        *QueryState `protobuf:"bytes,3,opt,name=state,proto3" json:"state,omitempty"`
	Offset       uint64      `protobuf:"varint,4,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (x *SyncResultsRequest) Reset() {
	*x = SyncResultsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_requests_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SyncResultsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncResultsRequest) ProtoMessage() {}

func (x *SyncResultsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_requests_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncResultsRequest.ProtoReflect.Descriptor instead.
func (*SyncResultsRequest) Descriptor() ([]byte, []int) {
	return file_requests_proto_rawDescGZIP(), []int{16}
}

func (x *SyncResultsRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

func (x *SyncResultsRequest) GetStatementId() uint32 {
	if x != nil {
		return x.StatementId
	}
	return 0
}

func (x *SyncResultsRequest) GetState() *QueryState {
	if x != nil {
		return x.State
	}
	return nil
}

func (x *SyncResultsRequest) GetOffset() uint64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

// Request to invoke a commit on a Connection
type CommitRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConnectionId string `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
}

func (x *CommitRequest) Reset() {
	*x = CommitRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_requests_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitRequest) ProtoMessage() {}

func (x *CommitRequest) ProtoReflect() protoreflect.Message {
	mi := &file_requests_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitRequest.ProtoReflect.Descriptor instead.
func (*CommitRequest) Descriptor() ([]byte, []int) {
	return file_requests_proto_rawDescGZIP(), []int{17}
}

func (x *CommitRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

// Request to invoke rollback on a Connection
type RollbackRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConnectionId string `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
}

func (x *RollbackRequest) Reset() {
	*x = RollbackRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_requests_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollbackRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollbackRequest) ProtoMessage() {}

func (x *RollbackRequest) ProtoReflect() protoreflect.Message {
	mi := &file_requests_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollbackRequest.ProtoReflect.Descriptor instead.
func (*RollbackRequest) Descriptor() ([]byte, []int) {
	return file_requests_proto_rawDescGZIP(), []int{18}
}

func (x *RollbackRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

// Request to prepare and execute a collection of sql statements.
type PrepareAndExecuteBatchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConnectionId string   `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
	StatementId  uint32   `protobuf:"varint,2,opt,name=statement_id,json=statementId,proto3" json:"statement_id,omitempty"`
	SqlCommands  []string `protobuf:"bytes,3,rep,name=sql_commands,json=sqlCommands,proto3" json:"sql_commands,omitempty"`
}

func (x *PrepareAndExecuteBatchRequest) Reset() {
	*x = PrepareAndExecuteBatchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_requests_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrepareAndExecuteBatchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrepareAndExecuteBatchRequest) ProtoMessage() {}

func (x *PrepareAndExecuteBatchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_requests_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrepareAndExecuteBatchRequest.ProtoReflect.Descriptor instead.
func (*PrepareAndExecuteBatchRequest) Descriptor() ([]byte, []int) {
	return file_requests_proto_rawDescGZIP(), []int{19}
}

func (x *PrepareAndExecuteBatchRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

func (x *PrepareAndExecuteBatchRequest) GetStatementId() uint32 {
	if x != nil {
		return x.StatementId
	}
	return 0
}

func (x *PrepareAndExecuteBatchRequest) GetSqlCommands() []string {
	if x != nil {
		return x.SqlCommands
	}
	return nil
}

// Each command is a list of TypedValues
type UpdateBatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ParameterValues []*TypedValue `protobuf:"bytes,1,rep,name=parameter_values,json=parameterValues,proto3" json:"parameter_values,omitempty"`
}

func (x *UpdateBatch) Reset() {
	*x = UpdateBatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_requests_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateBatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBatch) ProtoMessage() {}

func (x *UpdateBatch) ProtoReflect() protoreflect.Message {
	mi := &file_requests_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBatch.ProtoReflect.Descriptor instead.
func (*UpdateBatch) Descriptor() ([]byte, []int) {
	return file_requests_proto_rawDescGZIP(), []int{20}
}

func (x *UpdateBatch) GetParameterValues() []*TypedValue {
	if x != nil {
		return x.ParameterValues
	}
	return nil
}

type ExecuteBatchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConnectionId string         `protobuf:"bytes,1,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
	StatementId  uint32         `protobuf:"varint,2,opt,name=statement_id,json=statementId,proto3" json:"statement_id,omitempty"`
	Updates      []*UpdateBatch `protobuf:"bytes,3,rep,name=updates,proto3" json:"updates,omitempty"` // A batch of updates is a list<list<typevalue>>
}

func (x *ExecuteBatchRequest) Reset() {
	*x = ExecuteBatchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_requests_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteBatchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteBatchRequest) ProtoMessage() {}

func (x *ExecuteBatchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_requests_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteBatchRequest.ProtoReflect.Descriptor instead.
func (*ExecuteBatchRequest) Descriptor() ([]byte, []int) {
	return file_requests_proto_rawDescGZIP(), []int{21}
}

func (x *ExecuteBatchRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

func (x *ExecuteBatchRequest) GetStatementId() uint32 {
	if x != nil {
		return x.StatementId
	}
	return 0
}

func (x *ExecuteBatchRequest) GetUpdates() []*UpdateBatch {
	if x != nil {
		return x.Updates
	}
	return nil
}

var File_requests_proto protoreflect.FileDescriptor

var file_requests_proto_rawDesc = []byte{
	0x0a, 0x0e, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x0c, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x36,
	0x0a, 0x0f, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x3e, 0x0a, 0x17, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0xc5, 0x01, 0x0a, 0x0e, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x70, 0x61,
	0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x1f, 0x0a, 0x0b, 0x68, 0x61, 0x73, 0x5f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x68, 0x61, 0x73, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x12, 0x2c, 0x0a, 0x12, 0x68, 0x61, 0x73, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x70,
	0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x68, 0x61,
	0x73, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x22, 0xe8,
	0x02, 0x0a, 0x0d, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x18, 0x0a, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72,
	0x6e, 0x12, 0x2c, 0x0a, 0x12, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f,
	0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x12,
	0x1b, 0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x08, 0x74, 0x79, 0x70, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0d,
	0x68, 0x61, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0b, 0x68, 0x61, 0x73, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x69, 0x73, 0x74,
	0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x68, 0x61, 0x73, 0x5f, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x68, 0x61, 0x73, 0x43,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0x2c, 0x0a, 0x12, 0x68, 0x61, 0x73, 0x5f, 0x73, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x10, 0x68, 0x61, 0x73, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x50, 0x61, 0x74,
	0x74, 0x65, 0x72, 0x6e, 0x12, 0x33, 0x0a, 0x16, 0x68, 0x61, 0x73, 0x5f, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x68, 0x61, 0x73, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61,
	0x6d, 0x65, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x22, 0x38, 0x0a, 0x11, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23,
	0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x22, 0x8f, 0x03, 0x0a, 0x0e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x12, 0x25, 0x0a, 0x0e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65,
	0x72, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x12, 0x2c, 0x0a, 0x12, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x10, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x50, 0x61,
	0x74, 0x74, 0x65, 0x72, 0x6e, 0x12, 0x2e, 0x0a, 0x13, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x11, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x50, 0x61,
	0x74, 0x74, 0x65, 0x72, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x68, 0x61,
	0x73, 0x5f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0a, 0x68, 0x61, 0x73, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0x2c, 0x0a, 0x12, 0x68,
	0x61, 0x73, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72,
	0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x68, 0x61, 0x73, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x12, 0x33, 0x0a, 0x16, 0x68, 0x61, 0x73,
	0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x74,
	0x65, 0x72, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x68, 0x61, 0x73, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x12, 0x35,
	0x0a, 0x17, 0x68, 0x61, 0x73, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x14, 0x68, 0x61, 0x73, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x50, 0x61,
	0x74, 0x74, 0x65, 0x72, 0x6e, 0x22, 0x36, 0x0a, 0x0f, 0x54, 0x79, 0x70, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0xef, 0x01,
	0x0a, 0x18, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x41, 0x6e, 0x64, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x10, 0x0a, 0x03, 0x73, 0x71, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x73, 0x71,
	0x6c, 0x12, 0x22, 0x0a, 0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x6d, 0x61, 0x78, 0x52, 0x6f, 0x77,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f,
	0x72, 0x6f, 0x77, 0x73, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0c, 0x6d, 0x61, 0x78, 0x52, 0x6f, 0x77, 0x73, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x12, 0x2f,
	0x0a, 0x14, 0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x6d, 0x61,
	0x78, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x66, 0x69,
	0x72, 0x73, 0x74, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x78, 0x53, 0x69, 0x7a, 0x65, 0x22,
	0x91, 0x01, 0x0a, 0x0e, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x71, 0x6c, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x73, 0x71, 0x6c, 0x12, 0x22, 0x0a, 0x0d, 0x6d, 0x61, 0x78,
	0x5f, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x0b, 0x6d, 0x61, 0x78, 0x52, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x24, 0x0a,
	0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x6f, 0x77, 0x73, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x52, 0x6f, 0x77, 0x73, 0x54, 0x6f,
	0x74, 0x61, 0x6c, 0x22, 0xc3, 0x01, 0x0a, 0x0c, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x12, 0x2d, 0x0a, 0x13, 0x66, 0x65, 0x74, 0x63, 0x68, 0x5f, 0x6d, 0x61,
	0x78, 0x5f, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x10, 0x66, 0x65, 0x74, 0x63, 0x68, 0x4d, 0x61, 0x78, 0x52, 0x6f, 0x77, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x0e, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x6d, 0x61, 0x78,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x66, 0x72, 0x61,
	0x6d, 0x65, 0x4d, 0x61, 0x78, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x3d, 0x0a, 0x16, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x5f, 0x0a, 0x15, 0x43, 0x6c, 0x6f, 0x73,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x22, 0xab, 0x01, 0x0a, 0x15, 0x4f, 0x70,
	0x65, 0x6e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x34, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x49,
	0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x1a, 0x37,
	0x0a, 0x09, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x3d, 0x0a, 0x16, 0x43, 0x6c, 0x6f, 0x73, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x72, 0x0a, 0x15, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x79, 0x6e, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x12, 0x34, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x5f, 0x70, 0x72, 0x6f,
	0x70, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52,
	0x09, 0x63, 0x6f, 0x6e, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x73, 0x22, 0xad, 0x02, 0x0a, 0x0e, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a,
	0x0f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x52, 0x0f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x36, 0x0a, 0x10, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x12, 0x44, 0x0a, 0x1f, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x6d, 0x61, 0x78, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x1b, 0x64, 0x65, 0x70, 0x72,
	0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x46, 0x69, 0x72, 0x73, 0x74, 0x46, 0x72, 0x61, 0x6d, 0x65,
	0x4d, 0x61, 0x78, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x68, 0x61, 0x73, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x68, 0x61, 0x73, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x2f, 0x0a, 0x14, 0x66, 0x69, 0x72,
	0x73, 0x74, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x66, 0x69, 0x72, 0x73, 0x74, 0x46, 0x72,
	0x61, 0x6d, 0x65, 0x4d, 0x61, 0x78, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x97, 0x01, 0x0a, 0x12, 0x53,
	0x79, 0x6e, 0x63, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x16, 0x0a, 0x06,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x22, 0x34, 0x0a, 0x0d, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x36, 0x0a, 0x0f, 0x52, 0x6f,
	0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a,
	0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x22, 0x8a, 0x01, 0x0a, 0x1d, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x41, 0x6e,
	0x64, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c,
	0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0b, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x22,
	0x45, 0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x12, 0x36,
	0x0a, 0x10, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x64,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x85, 0x01, 0x0a, 0x13, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23,
	0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x26, 0x0a, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x42, 0x22,
	0x0a, 0x20, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x63, 0x61, 0x6c,
	0x63, 0x69, 0x74, 0x65, 0x2e, 0x61, 0x76, 0x61, 0x74, 0x69, 0x63, 0x61, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_requests_proto_rawDescOnce sync.Once
	file_requests_proto_rawDescData = file_requests_proto_rawDesc
)

func file_requests_proto_rawDescGZIP() []byte {
	file_requests_proto_rawDescOnce.Do(func() {
		file_requests_proto_rawDescData = protoimpl.X.CompressGZIP(file_requests_proto_rawDescData)
	})
	return file_requests_proto_rawDescData
}

var file_requests_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_requests_proto_goTypes = []interface{}{
	(*CatalogsRequest)(nil),               // 0: CatalogsRequest
	(*DatabasePropertyRequest)(nil),       // 1: DatabasePropertyRequest
	(*SchemasRequest)(nil),                // 2: SchemasRequest
	(*TablesRequest)(nil),                 // 3: TablesRequest
	(*TableTypesRequest)(nil),             // 4: TableTypesRequest
	(*ColumnsRequest)(nil),                // 5: ColumnsRequest
	(*TypeInfoRequest)(nil),               // 6: TypeInfoRequest
	(*PrepareAndExecuteRequest)(nil),      // 7: PrepareAndExecuteRequest
	(*PrepareRequest)(nil),                // 8: PrepareRequest
	(*FetchRequest)(nil),                  // 9: FetchRequest
	(*CreateStatementRequest)(nil),        // 10: CreateStatementRequest
	(*CloseStatementRequest)(nil),         // 11: CloseStatementRequest
	(*OpenConnectionRequest)(nil),         // 12: OpenConnectionRequest
	(*CloseConnectionRequest)(nil),        // 13: CloseConnectionRequest
	(*ConnectionSyncRequest)(nil),         // 14: ConnectionSyncRequest
	(*ExecuteRequest)(nil),                // 15: ExecuteRequest
	(*SyncResultsRequest)(nil),            // 16: SyncResultsRequest
	(*CommitRequest)(nil),                 // 17: CommitRequest
	(*RollbackRequest)(nil),               // 18: RollbackRequest
	(*PrepareAndExecuteBatchRequest)(nil), // 19: PrepareAndExecuteBatchRequest
	(*UpdateBatch)(nil),                   // 20: UpdateBatch
	(*ExecuteBatchRequest)(nil),           // 21: ExecuteBatchRequest
	nil,                                   // 22: OpenConnectionRequest.InfoEntry
	(*ConnectionProperties)(nil),          // 23: ConnectionProperties
	(*StatementHandle)(nil),               // 24: StatementHandle
	(*TypedValue)(nil),                    // 25: TypedValue
	(*QueryState)(nil),                    // 26: QueryState
}
var file_requests_proto_depIdxs = []int32{
	22, // 0: OpenConnectionRequest.info:type_name -> OpenConnectionRequest.InfoEntry
	23, // 1: ConnectionSyncRequest.conn_props:type_name -> ConnectionProperties
	24, // 2: ExecuteRequest.statementHandle:type_name -> StatementHandle
	25, // 3: ExecuteRequest.parameter_values:type_name -> TypedValue
	26, // 4: SyncResultsRequest.state:type_name -> QueryState
	25, // 5: UpdateBatch.parameter_values:type_name -> TypedValue
	20, // 6: ExecuteBatchRequest.updates:type_name -> UpdateBatch
	7,  // [7:7] is the sub-list for method output_type
	7,  // [7:7] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_requests_proto_init() }
func file_requests_proto_init() {
	if File_requests_proto != nil {
		return
	}
	file_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_requests_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CatalogsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_requests_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabasePropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_requests_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SchemasRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_requests_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TablesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_requests_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TableTypesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_requests_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ColumnsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_requests_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TypeInfoRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_requests_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrepareAndExecuteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_requests_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrepareRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_requests_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_requests_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateStatementRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_requests_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloseStatementRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_requests_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OpenConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_requests_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloseConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_requests_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConnectionSyncRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_requests_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_requests_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SyncResultsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_requests_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_requests_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollbackRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_requests_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrepareAndExecuteBatchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_requests_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateBatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_requests_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteBatchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_requests_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_requests_proto_goTypes,
		DependencyIndexes: file_requests_proto_depIdxs,
		MessageInfos:      file_requests_proto_msgTypes,
	}.Build()
	File_requests_proto = out.File
	file_requests_proto_rawDesc = nil
	file_requests_proto_goTypes = nil
	file_requests_proto_depIdxs = nil
}
