/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import java.net.URI;
import java.util.Date;
import java.util.List;
import org.jclouds.googlecloud.internal.NullSafeCopies;
import org.jclouds.googlecomputeengine.domain.AttachDisk;
import org.jclouds.googlecomputeengine.domain.AutoValue_Instance;
import org.jclouds.googlecomputeengine.domain.AutoValue_Instance_AttachedDisk;
import org.jclouds.googlecomputeengine.domain.AutoValue_Instance_NetworkInterface;
import org.jclouds.googlecomputeengine.domain.AutoValue_Instance_NetworkInterface_AccessConfig;
import org.jclouds.googlecomputeengine.domain.AutoValue_Instance_Scheduling;
import org.jclouds.googlecomputeengine.domain.AutoValue_Instance_SerialPortOutput;
import org.jclouds.googlecomputeengine.domain.AutoValue_Instance_ServiceAccount;
import org.jclouds.googlecomputeengine.domain.Metadata;
import org.jclouds.googlecomputeengine.domain.Tags;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class Instance {
    public abstract String id();

    @Nullable
    public abstract Date creationTimestamp();

    public abstract URI selfLink();

    public abstract String name();

    @Nullable
    public abstract String description();

    public abstract Tags tags();

    public abstract URI machineType();

    @Nullable
    public abstract Status status();

    @Nullable
    public abstract String statusMessage();

    public abstract URI zone();

    @Nullable
    public abstract Boolean canIpForward();

    public abstract List<NetworkInterface> networkInterfaces();

    public abstract List<AttachedDisk> disks();

    public abstract Metadata metadata();

    public abstract List<ServiceAccount> serviceAccounts();

    public abstract Scheduling scheduling();

    @SerializedNames(value={"id", "creationTimestamp", "selfLink", "name", "description", "tags", "machineType", "status", "statusMessage", "zone", "canIpForward", "networkInterfaces", "disks", "metadata", "serviceAccounts", "scheduling"})
    public static Instance create(String id, Date creationTimestamp, URI selfLink, String name, String description, Tags tags, URI machineType, Status status, String statusMessage, URI zone, Boolean canIpForward, List<NetworkInterface> networkInterfaces, List<AttachedDisk> disks, Metadata metadata, List<ServiceAccount> serviceAccounts, Scheduling scheduling) {
        return new AutoValue_Instance(id, creationTimestamp, selfLink, name, description, tags, machineType, status, statusMessage, zone, canIpForward, NullSafeCopies.copyOf(networkInterfaces), NullSafeCopies.copyOf(disks), metadata, NullSafeCopies.copyOf(serviceAccounts), scheduling);
    }

    Instance() {
    }

    public static enum Status {
        PROVISIONING,
        STAGING,
        RUNNING,
        STOPPING,
        STOPPED,
        TERMINATED;

    }

    public static abstract class Scheduling {
        public abstract OnHostMaintenance onHostMaintenance();

        public abstract boolean automaticRestart();

        public abstract boolean preemptible();

        @SerializedNames(value={"onHostMaintenance", "automaticRestart", "preemptible"})
        public static Scheduling create(OnHostMaintenance onHostMaintenance, boolean automaticRestart, boolean preemptible) {
            return new AutoValue_Instance_Scheduling(onHostMaintenance, automaticRestart, preemptible);
        }

        Scheduling() {
        }

        public static enum OnHostMaintenance {
            MIGRATE,
            TERMINATE;

        }
    }

    public static abstract class ServiceAccount {
        public abstract String email();

        public abstract List<String> scopes();

        @SerializedNames(value={"email", "scopes"})
        public static ServiceAccount create(String email, List<String> scopes) {
            return new AutoValue_Instance_ServiceAccount(email, scopes);
        }

        ServiceAccount() {
        }
    }

    public static abstract class SerialPortOutput {
        @Nullable
        public abstract URI selfLink();

        public abstract String contents();

        @SerializedNames(value={"selfLink", "contents"})
        public static SerialPortOutput create(URI selfLink, String contents) {
            return new AutoValue_Instance_SerialPortOutput(selfLink, contents);
        }

        SerialPortOutput() {
        }
    }

    public static abstract class NetworkInterface {
        public abstract String name();

        public abstract URI network();

        @Nullable
        public abstract String networkIP();

        public abstract List<AccessConfig> accessConfigs();

        @SerializedNames(value={"name", "network", "networkIP", "accessConfigs"})
        public static NetworkInterface create(String name, URI network, String networkIP, List<AccessConfig> accessConfigs) {
            return new AutoValue_Instance_NetworkInterface(name, network, networkIP, NullSafeCopies.copyOf(accessConfigs));
        }

        NetworkInterface() {
        }

        public static abstract class AccessConfig {
            @Nullable
            public abstract String name();

            public abstract Type type();

            @Nullable
            public abstract String natIP();

            @SerializedNames(value={"name", "type", "natIP"})
            public static AccessConfig create(String name, Type type, String natIP) {
                return new AutoValue_Instance_NetworkInterface_AccessConfig(name, type, natIP);
            }

            AccessConfig() {
            }

            public static enum Type {
                ONE_TO_ONE_NAT;

            }
        }
    }

    public static abstract class AttachedDisk {
        public abstract int index();

        public abstract Type type();

        public abstract Mode mode();

        @Nullable
        public abstract URI source();

        @Nullable
        public abstract String deviceName();

        public abstract boolean autoDelete();

        public abstract boolean boot();

        @Nullable
        public abstract AttachDisk.InitializeParams initializeParams();

        @Nullable
        public abstract List<String> licenses();

        @Nullable
        public abstract AttachDisk.DiskInterface diskInterface();

        @SerializedNames(value={"index", "type", "mode", "source", "deviceName", "autoDelete", "boot", "initializeParams", "licenses", "interface"})
        public static AttachedDisk create(int index, Type type, Mode mode, URI source, String deviceName, boolean autoDelete, boolean boot, AttachDisk.InitializeParams initializeParams, List<String> licenses, AttachDisk.DiskInterface diskInterface) {
            return new AutoValue_Instance_AttachedDisk(index, type, mode, source, deviceName, autoDelete, boot, initializeParams, licenses, diskInterface);
        }

        AttachedDisk() {
        }

        public static enum Mode {
            READ_WRITE,
            READ_ONLY;

        }

        public static enum Type {
            PERSISTENT,
            SCRATCH;

        }
    }
}

