/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.software.base;

import com.google.common.base.Optional;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessWinRmDriver;
import org.apache.brooklyn.entity.software.base.EmptyWindowsProcessImpl;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.software.base.VanillaWindowsProcessDriver;
import org.apache.brooklyn.location.winrm.WinRmMachineLocation;
import org.apache.brooklyn.util.core.internal.winrm.WinRmTool;
import org.apache.brooklyn.util.net.UserAndHostAndPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmptyWindowsProcessWinRmDriver
extends AbstractSoftwareProcessWinRmDriver
implements VanillaWindowsProcessDriver {
    private static final Logger LOG = LoggerFactory.getLogger(EmptyWindowsProcessWinRmDriver.class);
    private final AtomicBoolean running = new AtomicBoolean();

    public EmptyWindowsProcessWinRmDriver(EmptyWindowsProcessImpl entity, WinRmMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    @Override
    public void start() {
        WinRmMachineLocation machine = (WinRmMachineLocation)this.location;
        Integer port = (Integer)this.entity.getConfig(WinRmTool.PROP_PORT);
        UserAndHostAndPort winrmAddress = UserAndHostAndPort.fromParts((String)machine.getUser(), (String)machine.getAddress().getHostName(), (Optional)Optional.fromNullable((Object)port));
        this.getEntity().sensors().set(Attributes.WINRM_ADDRESS, (Object)winrmAddress);
        super.start();
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void install() {
    }

    @Override
    public void customize() {
    }

    @Override
    public void copyInstallResources() {
        Map installFiles = (Map)this.entity.getConfig(SoftwareProcess.INSTALL_FILES);
        Map installTemplates = (Map)this.entity.getConfig(SoftwareProcess.INSTALL_TEMPLATES);
        if (installFiles != null && !installFiles.isEmpty() || installTemplates != null && !installTemplates.isEmpty()) {
            super.copyInstallResources();
        }
    }

    @Override
    public void copyRuntimeResources() {
        Map runtimeFiles = (Map)this.entity.getConfig(SoftwareProcess.RUNTIME_FILES);
        Map runtimeTemplates = (Map)this.entity.getConfig(SoftwareProcess.RUNTIME_TEMPLATES);
        if (runtimeFiles != null && !runtimeFiles.isEmpty() || runtimeTemplates != null && !runtimeTemplates.isEmpty()) {
            super.copyRuntimeResources();
        }
    }

    @Override
    public void launch() {
        this.running.set(true);
    }

    @Override
    public void rebind() {
        super.rebind();
        this.running.set(true);
    }

    @Override
    public void stop() {
        this.running.set(false);
    }
}

