/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.external;

import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.mgmt.BrooklynTags;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.steps.variables.SetVariableWorkflowStep;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.json.ShellEnvironmentSerializer;
import org.apache.brooklyn.util.core.predicates.DslPredicates;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.ssh.ConnectionDefinition;
import org.apache.brooklyn.util.core.task.ssh.SshTasks;
import org.apache.brooklyn.util.core.task.ssh.internal.RemoteExecTaskConfigHelper;
import org.apache.brooklyn.util.core.task.system.ProcessTaskFactory;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.text.Strings;

public class SshWorkflowStep
extends WorkflowStepDefinition {
    public static final String SHORTHAND = "[ \"to \" ${endpoint} ] ${command...}";
    public static final ConfigKey<String> ENDPOINT = ConfigKeys.newStringConfigKey("endpoint");
    public static final ConfigKey<String> COMMAND = ConfigKeys.newStringConfigKey("command");
    public static final ConfigKey<Map<String, Object>> ENV = new MapConfigKey.Builder<Object>(Object.class, "env").build();
    public static final ConfigKey<DslPredicates.DslPredicate<Integer>> EXIT_CODE = ConfigKeys.newConfigKey(new TypeToken<DslPredicates.DslPredicate<Integer>>(){}, "exit_code");
    public static final ConfigKey<Integer> OUTPUT_MAX_SIZE = ConfigKeys.newIntegerConfigKey("output_max_size", "Maximum size for stdout and stderr, or -1 for no limit", 100000);
    ConfigKey<SetVariableWorkflowStep.InterpolationMode> INTERPOLATION_MODE = ConfigKeys.newConfigKeyWithDefault(SetVariableWorkflowStep.INTERPOLATION_MODE, SetVariableWorkflowStep.InterpolationMode.FULL);
    ConfigKey<TemplateProcessor.InterpolationErrorMode> INTERPOLATION_ERRORS = ConfigKeys.newConfigKeyWithDefault(SetVariableWorkflowStep.INTERPOLATION_ERRORS, TemplateProcessor.InterpolationErrorMode.IGNORE);

    @Override
    public void populateFromShorthand(String expression) {
        this.populateFromShorthandTemplate(SHORTHAND, expression);
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        RemoteExecTaskConfigHelper.RemoteExecCapability remoteExecCapability;
        String command = (String)new SetVariableWorkflowStep.ConfigurableInterpolationEvaluation(context, TypeToken.of(String.class), this.getInput().get(COMMAND.getName()), context.getInputOrDefault(this.INTERPOLATION_MODE), context.getInputOrDefault(this.INTERPOLATION_ERRORS)).evaluate();
        if (Strings.isBlank((CharSequence)command)) {
            throw new IllegalStateException("'command' is required");
        }
        String endpoint = context.getInput(ENDPOINT);
        if (Strings.isNonBlank((CharSequence)endpoint)) {
            throw new IllegalStateException("Explicit endpoint not currently supported for ssh step");
        }
        ConnectionDefinition cdef = BrooklynTags.findSingleKeyMapValue("connection", ConnectionDefinition.class, (Iterable<Object>)context.getEntity().tags().getTags());
        if (cdef != null) {
            remoteExecCapability = RemoteExecTaskConfigHelper.RemoteExecCapabilityFromDefinition.of(context.getEntity(), cdef);
        } else {
            SshMachineLocation machine = (SshMachineLocation)Locations.findUniqueSshMachineLocation(context.getEntity().getLocations()).orThrow("No SSH location available for workflow at " + context.getEntity() + " and no endpoint specified");
            remoteExecCapability = new RemoteExecTaskConfigHelper.RemoteExecCapabilityFromLocation(machine);
        }
        return ((ProcessTaskWrapper)DynamicTasks.queue(SshWorkflowStep.customizeProcessTaskFactory(context, SshTasks.newSshExecTaskFactory(remoteExecCapability, command)).newTask())).asTask().getUnchecked();
    }

    public static <U, T extends ProcessTaskFactory<U>> ProcessTaskFactory<Map<?, ?>> customizeProcessTaskFactory(WorkflowStepInstanceExecutionContext context, T tf) {
        Map<String, Object> env;
        DslPredicates.DslPredicate<Integer> exitcode = context.getInput(EXIT_CODE);
        if (exitcode != null) {
            tf.allowingNonZeroExitCode();
        }
        if ((env = context.getInput(ENV)) != null) {
            tf.environmentVariables((Map)new ShellEnvironmentSerializer(context.getWorkflowExectionContext().getManagementContext()).serialize(env));
        }
        Integer maxLength = context.getInput(OUTPUT_MAX_SIZE);
        return tf.returning(ptw -> {
            context.setOutput(MutableMap.of((Object)"stdout", (Object)SshWorkflowStep.truncate(ptw.getStdout(), maxLength), (Object)"stderr", (Object)SshWorkflowStep.truncate(ptw.getStderr(), maxLength), (Object)"exit_code", (Object)ptw.getExitCode()));
            SshWorkflowStep.checkExitCode(ptw, exitcode);
            return (Map)context.getOutput();
        });
    }

    protected static void checkExitCode(ProcessTaskWrapper<?> ptw, DslPredicates.DslPredicate<Integer> exitcode) {
        Object implicit;
        Supplier<String> extraInfo = () -> {
            String err = ptw.getStderr();
            if (Strings.isBlank((CharSequence)err)) {
                return "";
            }
            if ((err = err.trim()).length() > 80) {
                err = "..." + err.substring(err.length() - 80, err.length());
            }
            err = Strings.replaceAll((String)err, (String)"\n", (String)" / ");
            return ". Stderr is: " + err;
        };
        if (exitcode == null) {
            if (ptw.getExitCode() != 0) {
                throw new IllegalStateException("Invalid exit code " + ptw.getExitCode() + extraInfo.get());
            }
            return;
        }
        if (exitcode instanceof DslPredicates.DslPredicateBase && (implicit = ((DslPredicates.DslPredicateBase)((Object)exitcode)).implicitEqualsUnwrapped()) != null && "any".equalsIgnoreCase("" + implicit)) {
            return;
        }
        if (!exitcode.apply(ptw.getExitCode())) {
            throw new IllegalStateException("Invalid exit code " + ptw.getExitCode() + "; does not match explicit exit_code requirement" + extraInfo.get());
        }
    }

    public static String truncate(String input, Integer maxLength) {
        if (input == null || maxLength == null || maxLength < 0 || input.length() < maxLength) {
            return input;
        }
        if (maxLength <= 4) {
            return input.substring(input.length() - maxLength);
        }
        return "... " + input.substring(input.length() - maxLength + 4);
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return false;
    }
}

