/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.effector;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.io.Serializable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.AddSensorInitializerAbstractProto;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.time.Duration;

@Beta
public class AddSensorInitializer<T>
extends EntityInitializers.InitializerPatternWithConfigKeys
implements Serializable {
    public static final ConfigKey<String> SENSOR_NAME = ConfigKeys.newStringConfigKey("name", "The name of the sensor to create");
    public static final ConfigKey<Duration> SENSOR_PERIOD = ConfigKeys.newConfigKey(Duration.class, "period", "Period, including units e.g. 1m or 5s or 200ms; default 5 minutes", Duration.FIVE_MINUTES);
    public static final ConfigKey<String> SENSOR_TYPE = ConfigKeys.newStringConfigKey("targetType", "Target type for the value; default String", String.class.getName());
    private String name;
    private Duration period;
    @JsonIgnore
    private String type;
    private AttributeSensor<T> sensor;
    private ConfigBag params;

    protected AddSensorInitializer(ConfigBag params) {
        super(params);
    }

    protected AddSensorInitializer() {
    }

    public void apply(EntityLocal entity) {
        this.addSensor(entity);
    }

    protected AttributeSensor<T> addSensor(EntityLocal entity) {
        AttributeSensor<T> sensor = this.sensor((Entity)entity);
        ((EntityInternal)entity).getMutableEntityType().addSensor((Sensor<?>)sensor);
        return sensor;
    }

    protected AttributeSensor<T> sensor(Entity entity) {
        TypeToken<T> clazz = this.getType(entity, this.initParam(SENSOR_TYPE));
        return Sensors.newSensor(clazz, (String)Preconditions.checkNotNull((Object)this.initParam(SENSOR_NAME)));
    }

    protected TypeToken<T> getType(Entity entity, String className) {
        return AddSensorInitializerAbstractProto.getType(entity, className, this.initParam(SENSOR_NAME));
    }

    @JsonProperty(value="type")
    private void setType(String type) {
        this.type = type;
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.initFromConfigBag(ConfigBag.newInstance().putIfAbsentAndNotNull(SENSOR_NAME, this.name).putIfAbsentAndNotNull(SENSOR_PERIOD, this.period).putIfAbsentAndNotNull(SENSOR_TYPE, this.type));
        this.name = null;
        this.period = null;
        this.type = null;
        this.sensor = null;
        this.params = null;
        return this;
    }
}

