/*
 * Copyright 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.conscrypt;

import java.util.Collections;
import java.util.List;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;

/**
 * This is an adapter that wraps the active session with {@link ExtendedSSLSession}, if running
 * on Java 8+.
 */
class Java8ExtendedSSLSession extends Java7ExtendedSSLSession {

  public Java8ExtendedSSLSession(ConscryptSession delegate) {
    super(delegate);
  }

  @Override
  public final List<SNIServerName> getRequestedServerNames() {
      String requestedServerName = getDelegate().getRequestedServerName();
      if (requestedServerName == null) {
        return null;
      }

      return Collections.singletonList((SNIServerName) new SNIHostName(requestedServerName));
  }
}
