/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.ui.modularity.module.registry;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.brooklyn.ui.modularity.module.api.UiModule;
import org.apache.brooklyn.ui.modularity.module.api.UiModuleRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiModuleRegistryImpl
implements UiModuleRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(UiModuleRegistryImpl.class);
    private final ConcurrentHashMap<String, UiModule> registry = new ConcurrentHashMap();

    public void register(UiModule uiModule) {
        if (uiModule.getId() == null) {
            LOG.error("Skipping invalid Brooklyn UI module " + uiModule, new Throwable("source of error"));
            return;
        }
        LOG.info("Registering new Brooklyn web component [{}] [{}]", (Object)uiModule.getId(), (Object)uiModule.getName());
        this.registry.put(uiModule.getId(), uiModule);
    }

    public void unregister(UiModule uiModule) {
        if (uiModule != null) {
            LOG.info("Unregistered new Brooklyn web component [{}] [{}]", (Object)uiModule.getId(), (Object)uiModule.getName());
            this.registry.remove(uiModule.getId());
        }
    }

    public Collection<UiModule> getRegisteredModules() {
        return this.registry.values();
    }
}

