/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.appmodel;

import com.google.common.collect.Iterables;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.BrooklynObjectType;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.EntityAdjuncts;
import org.apache.brooklyn.core.resolve.jackson.BeanWithTypeUtils;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepResolution;
import org.apache.brooklyn.core.workflow.steps.appmodel.HasBlueprintWorkflowStep;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.FlagUtils;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.yaml.Yamls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddPolicyWorkflowStep
extends WorkflowStepDefinition
implements HasBlueprintWorkflowStep {
    private static final Logger LOG = LoggerFactory.getLogger(AddPolicyWorkflowStep.class);
    public static final String SHORTHAND = "[ ${type} ] [ \" at \" ${entity} ] [ \" unique-tag \" ${uniqueTag} ]";
    public static final ConfigKey<String> UNIQUE_TAG = ConfigKeys.newStringConfigKey("uniqueTag");
    public static final ConfigKey<Object> ENTITY = ConfigKeys.newConfigKey(Object.class, "entity");

    @Override
    public Logger logger() {
        return LOG;
    }

    @Override
    public void populateFromShorthand(String expression) {
        this.populateFromShorthandTemplate(SHORTHAND, expression);
    }

    @Override
    public void validateStep(@Nullable ManagementContext mgmt, @Nullable WorkflowExecutionContext workflow) {
        super.validateStep(mgmt, workflow);
        this.validateStepBlueprint(mgmt, workflow);
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        BrooklynObject result;
        String uniqueTag;
        Object entityToFind = context.getInput(ENTITY);
        Entity entity = entityToFind != null ? (Entity)WorkflowStepResolution.findEntity(context, entityToFind).get() : context.getEntity();
        Object blueprint = this.resolveBlueprint(context);
        AbstractBrooklynObjectSpec spec = null;
        EntityAdjunct inst = null;
        try {
            Object yo;
            Maybe<AbstractBrooklynObjectSpec> spec0;
            if (!(blueprint instanceof String)) {
                blueprint = BeanWithTypeUtils.newYamlMapper(null, false, null, false).writeValueAsString(blueprint);
            }
            if ((spec0 = TypeCoercions.tryCoerce(yo = Iterables.getOnlyElement((Iterable)Yamls.parseAll((String)((String)blueprint))), AbstractBrooklynObjectSpec.class)).isAbsent()) {
                inst = (EntityAdjunct)TypeCoercions.tryCoerce(yo, EntityAdjunct.class).orNull();
                if (inst == null) {
                    spec = context.getManagementContext().getTypeRegistry().createSpecFromPlan(null, blueprint, null, AbstractBrooklynObjectSpec.class);
                }
            } else {
                spec = (AbstractBrooklynObjectSpec)spec0.get();
            }
        }
        catch (Exception e) {
            throw Exceptions.propagateAnnotated((String)"Cannot make policy or adjunct from blueprint", (Throwable)e);
        }
        boolean uniqueTagSet = this.input.containsKey(UNIQUE_TAG.getName());
        String string = uniqueTag = uniqueTagSet ? context.getInput(UNIQUE_TAG) : (String)Strings.firstNonBlank((CharSequence[])new String[]{context.getWorkflowExectionContext().getName(), context.getWorkflowExectionContext().getRetentionHash()}) + " - " + (context.getStepIndex() + 1);
        if (spec != null) {
            if (uniqueTagSet || !spec.getFlags().containsKey("uniqueTag")) {
                spec.configure((CharSequence)"uniqueTag", (Object)uniqueTag);
            }
            result = EntityAdjuncts.addAdjunct(entity, spec);
        } else {
            if (uniqueTagSet || inst.getUniqueTag() == null) {
                FlagUtils.setFieldFromFlag(inst, "uniqueTag", uniqueTag);
            }
            result = EntityAdjuncts.addAdjunct(entity, inst);
        }
        return MutableMap.of((Object)BrooklynObjectType.of((BrooklynObject)result).toCamelCase(), (Object)result, (Object)"result", (Object)result);
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return true;
    }
}

