/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.resolve.entity;

import java.util.Set;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.core.resolve.entity.EntitySpecResolver;
import org.apache.brooklyn.util.text.Strings;

public abstract class AbstractEntitySpecResolver
implements EntitySpecResolver {
    private static final String PREFIX_DELIMITER = ":";
    protected final String name;
    protected final String prefix;
    protected ManagementContext mgmt;

    public AbstractEntitySpecResolver(String name) {
        this.name = name;
        this.prefix = name + PREFIX_DELIMITER;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean accepts(String type, BrooklynClassLoadingContext loader) {
        return type.startsWith(this.prefix) && this.canResolve(type, loader);
    }

    protected boolean canResolve(String type, BrooklynClassLoadingContext loader) {
        return true;
    }

    protected String getLocalType(String type) {
        return Strings.removeFromStart((String)type, (String)this.prefix).trim();
    }

    @Override
    public void setManagementContext(ManagementContext mgmt) {
        this.mgmt = mgmt;
    }

    @Override
    public abstract EntitySpec<?> resolve(String var1, BrooklynClassLoadingContext var2, Set<String> var3);
}

