/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.rebind.dto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.io.ByteSource;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.brooklyn.api.mgmt.rebind.mementos.ManagedBundleMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.Memento;
import org.apache.brooklyn.core.mgmt.rebind.dto.AbstractMemento;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE)
public class BasicManagedBundleMemento
extends AbstractMemento
implements ManagedBundleMemento,
Serializable {
    private static final long serialVersionUID = -2040630288193425950L;
    private String symbolicName;
    private String version;
    private String format;
    private String url;
    private String checksum;
    private Boolean deleteable;
    private transient ByteSource jarContent;

    public static Builder builder() {
        return new Builder();
    }

    private BasicManagedBundleMemento() {
    }

    protected BasicManagedBundleMemento(Builder builder) {
        super(builder);
        this.symbolicName = builder.symbolicName;
        this.version = builder.version;
        this.format = builder.format;
        this.url = builder.url;
        this.checksum = builder.checksum;
        this.deleteable = builder.deleteable;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getFormat() {
        return this.format;
    }

    public String getUrl() {
        return this.url;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public Boolean getDeleteable() {
        return this.deleteable;
    }

    public ByteSource getJarContent() {
        return this.jarContent;
    }

    public void setJarContent(ByteSource byteSource) {
        this.jarContent = byteSource;
    }

    @Override
    protected void setCustomFields(Map<String, Object> fields) {
        if (!fields.isEmpty()) {
            throw new UnsupportedOperationException("Cannot set custom fields on " + this + ". Fields=" + Joiner.on((String)", ").join(fields.keySet()));
        }
    }

    @Override
    public Map<String, ? extends Object> getCustomFields() {
        return Collections.emptyMap();
    }

    @Override
    protected MoreObjects.ToStringHelper newVerboseStringHelper() {
        return super.newVerboseStringHelper().add("symbolicName", (Object)this.getSymbolicName()).add("version", (Object)this.getVersion()).add("format", (Object)this.getFormat()).add("url", (Object)this.getUrl()).add("checksum", (Object)this.getChecksum()).add("deleteable", (Object)this.getDeleteable());
    }

    @Override
    public String toString() {
        return this.toVerboseString();
    }

    public static class Builder
    extends AbstractMemento.Builder<Builder> {
        protected String symbolicName;
        protected String version;
        protected String format;
        protected String url;
        protected String checksum;
        protected Boolean deleteable;

        public Builder symbolicName(String symbolicName) {
            this.symbolicName = symbolicName;
            return (Builder)this.self();
        }

        public Builder version(String version) {
            this.version = version;
            return (Builder)this.self();
        }

        public Builder format(String format) {
            this.format = format;
            return (Builder)this.self();
        }

        public Builder url(String url) {
            this.url = url;
            return (Builder)this.self();
        }

        public Builder checksum(String checksum) {
            this.checksum = checksum;
            return (Builder)this.self();
        }

        public Builder deleteable(Boolean deleteable) {
            this.deleteable = deleteable;
            return (Builder)this.self();
        }

        public Builder from(ManagedBundleMemento other) {
            super.from((Memento)other);
            this.symbolicName = other.getSymbolicName();
            this.version = other.getVersion();
            this.format = other.getFormat();
            this.url = other.getUrl();
            this.checksum = other.getChecksum();
            this.deleteable = other.getDeleteable();
            return (Builder)this.self();
        }

        public BasicManagedBundleMemento build() {
            return new BasicManagedBundleMemento(this);
        }
    }
}

