/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.internal;

import com.google.common.annotations.Beta;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.brooklyn.core.location.PortRanges;
import org.apache.brooklyn.util.core.crypto.SecureKeys;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.net.Networking;

@Beta
public class BrooklynInitialization {
    private static AtomicBoolean done = new AtomicBoolean(false);

    public static void initTypeCoercionStandardAdapters() {
        TypeCoercions.initStandardAdapters();
    }

    public static void initSecureKeysBouncyCastleProvider() {
        SecureKeys.initBouncyCastleProvider();
    }

    public static void initNetworking() {
        Networking.init();
    }

    public static void initPortRanges() {
        PortRanges.init();
    }

    public static void initAll() {
        if (done.compareAndSet(false, true)) {
            BrooklynInitialization.initTypeCoercionStandardAdapters();
            BrooklynInitialization.initSecureKeysBouncyCastleProvider();
            BrooklynInitialization.initNetworking();
            BrooklynInitialization.initPortRanges();
        }
    }

    public static synchronized void reinitAll() {
        done.set(false);
        BrooklynInitialization.initAll();
    }
}

