/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.effector.ssh;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.effector.ParameterType;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.effector.AddEffectorInitializerAbstract;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.sensor.ssh.SshCommandSensor;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.json.ShellEnvironmentSerializer;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.core.task.system.internal.AbstractProcessTaskFactory;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;

public final class SshCommandEffector
extends AddEffectorInitializerAbstract {
    public static final ConfigKey<String> EFFECTOR_COMMAND = ConfigKeys.newStringConfigKey("command");
    public static final ConfigKey<String> EFFECTOR_EXECUTION_DIR = SshCommandSensor.SENSOR_EXECUTION_DIR;
    public static final MapConfigKey<Object> EFFECTOR_SHELL_ENVIRONMENT = BrooklynConfigKeys.SHELL_ENVIRONMENT;
    public static final ConfigKey<ExecutionTarget> EXECUTION_TARGET = ConfigKeys.newConfigKey(ExecutionTarget.class, "executionTarget", "Where this command should run; by default on this 'entity'; alternatively on all 'children' or all 'members' (if it's a group); in the latter cases the sets are filtered by entities which have a machine and are not stopping.", ExecutionTarget.ENTITY);

    public SshCommandEffector() {
    }

    public SshCommandEffector(ConfigBag params) {
        super(params);
    }

    public Effectors.EffectorBuilder<String> newEffectorBuilder() {
        Effectors.EffectorBuilder<String> eff = this.newAbstractEffectorBuilder(String.class);
        eff.impl(new Body(eff.buildAbstract(), this.initParams()));
        return eff;
    }

    protected static class Body
    extends EffectorBody<String> {
        private final Effector<?> effector;
        private final String command;
        private final Map<String, Object> shellEnv;
        private final String executionDir;
        private final ExecutionTarget executionTarget;

        public Body(Effector<?> eff, ConfigBag params) {
            this.effector = eff;
            this.command = (String)Preconditions.checkNotNull((Object)params.get(EFFECTOR_COMMAND), (Object)"SSH command must be supplied when defining this effector");
            this.shellEnv = (Map)params.get(EFFECTOR_SHELL_ENVIRONMENT);
            this.executionDir = params.get(EFFECTOR_EXECUTION_DIR);
            this.executionTarget = params.get(EXECUTION_TARGET);
        }

        @Override
        public String call(ConfigBag params) {
            switch (this.executionTarget) {
                case ENTITY: {
                    return this.callOne(params);
                }
                case MEMBERS: {
                    return this.callMany(((Group)this.entity()).getMembers(), params);
                }
                case CHILDREN: {
                    return this.callMany(this.entity().getChildren(), params);
                }
            }
            throw new IllegalStateException("Unknown value passed as execution target: " + (Object)((Object)this.executionTarget));
        }

        public String callOne(ConfigBag params) {
            return (String)((ProcessTaskWrapper)this.queue(this.makePartialTaskFactory(params, (Entity)this.entity()).summary("effector " + this.effector.getName() + " ssh call"))).get();
        }

        public String callMany(Collection<Entity> targets, ConfigBag params) {
            TaskBuilder ptb = Tasks.builder().parallel(true).displayName("effector " + this.effector.getName() + " ssh to targets");
            for (Entity target : targets) {
                Maybe<SshMachineLocation> machine;
                Lifecycle state;
                if (Entities.isNoLongerManaged(target) || (state = (Lifecycle)((Object)target.getAttribute(Attributes.SERVICE_STATE_ACTUAL))) == Lifecycle.STOPPING || state == Lifecycle.STOPPED || (machine = Locations.findUniqueSshMachineLocation(target.getLocations())).isAbsent()) continue;
                SshEffectorTasks.SshEffectorTaskFactory<String> t = this.makePartialTaskFactory(params, target);
                t.summary("effector " + this.effector.getName() + " at " + target);
                t.machine((MachineLocation)machine.get());
                ptb.add((TaskAdaptable<?>)t.newTask());
            }
            this.queue(ptb.build()).getUnchecked();
            return null;
        }

        public SshEffectorTasks.SshEffectorTaskFactory<String> makePartialTaskFactory(ConfigBag params, Entity entity) {
            Map effectorEnv;
            String sshCommand = SshCommandSensor.makeCommandExecutingInDirectory(this.command, this.executionDir, entity);
            MutableMap env = MutableMap.of();
            for (ParameterType param : this.effector.getParameters()) {
                if (Objects.equals(param.getName(), EFFECTOR_SHELL_ENVIRONMENT.getName())) continue;
                env.addIfNotNull((Object)param.getName(), params.get(Effectors.asConfigKey(param)));
            }
            env.putAll((Map)entity.config().get(BrooklynConfigKeys.SHELL_ENVIRONMENT));
            env.putAll(Maps.filterKeys(params.getAllConfig(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)EFFECTOR_SHELL_ENVIRONMENT.getName()))));
            if (this.shellEnv != null) {
                env.putAll(this.shellEnv);
            }
            if ((effectorEnv = (Map)params.get(EFFECTOR_SHELL_ENVIRONMENT)) != null) {
                env.putAll(effectorEnv);
            }
            try {
                env = MutableMap.copyOf(this.resolveEnv((MutableMap<String, Object>)env));
            }
            catch (InterruptedException | ExecutionException e) {
                Exceptions.propagateIfFatal((Throwable)e);
            }
            ShellEnvironmentSerializer serializer = new ShellEnvironmentSerializer(this.entity().getManagementContext());
            return (SshEffectorTasks.SshEffectorTaskFactory)((AbstractProcessTaskFactory)SshEffectorTasks.ssh(sshCommand).requiringZeroAndReturningStdout()).environmentVariables((Map)serializer.serialize((Map<?, ?>)env));
        }

        private Map<String, Object> resolveEnv(MutableMap<String, Object> env) throws ExecutionException, InterruptedException {
            return (Map)Tasks.resolveDeepValueWithoutCoercion(env, this.entity().getExecutionContext());
        }
    }

    public static enum ExecutionTarget {
        ENTITY,
        MEMBERS,
        CHILDREN;

    }
}

