/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.framework;

import com.google.common.reflect.TypeToken;
import java.util.Map;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.test.framework.BaseTest;
import org.apache.brooklyn.test.framework.TestHttpCallImpl;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;

@ImplementedBy(value=TestHttpCallImpl.class)
public interface TestHttpCall
extends BaseTest {
    @SetFromFlag(nullable=false)
    public static final ConfigKey<String> TARGET_URL = ConfigKeys.newStringConfigKey((String)"url", (String)"URL to test");
    @SetFromFlag(nullable=false)
    public static final ConfigKey<HttpMethod> TARGET_METHOD = ConfigKeys.builder(HttpMethod.class).name("method").description("Method to request the URL: GET, POST, PUT, DELETE, etc").defaultValue((Object)HttpMethod.GET).build();
    public static final ConfigKey<Boolean> TRUST_ALL = ConfigKeys.newBooleanConfigKey((String)"trustAll", (String)"Trust all certificates used to sign this request", (Boolean)true);
    public static final ConfigKey<Map<String, String>> TARGET_HEADERS = ConfigKeys.builder((TypeToken)new TypeToken<Map<String, String>>(){}).name("headers").description("Headers to add to the request").build();
    public static final ConfigKey<String> TARGET_BODY = ConfigKeys.newStringConfigKey((String)"body", (String)"The request body to send (only for POST and PUT requests)");
    public static final ConfigKey<HttpAssertionTarget> ASSERTION_TARGET = ConfigKeys.newConfigKey(HttpAssertionTarget.class, (String)"applyAssertionTo", (String)"The HTTP field to apply the assertion to [body,status]", (Object)((Object)HttpAssertionTarget.body));
    public static final ConfigKey<Integer> MAX_ATTEMPTS = ConfigKeys.newIntegerConfigKey((String)"maxAttempts", (String)"Maximum number of attempts");

    public static enum HttpAssertionTarget {
        body("body"),
        status("status");

        private final String httpAssertionTarget;

        private HttpAssertionTarget(String httpAssertionTarget) {
            this.httpAssertionTarget = httpAssertionTarget;
        }

        public String toString() {
            return this.httpAssertionTarget;
        }
    }

    public static enum HttpMethod {
        GET(HttpGet.class),
        POST(HttpPost.class),
        PUT(HttpPut.class),
        DELETE(HttpDelete.class),
        HEAD(HttpHead.class),
        OPTIONS(HttpOptions.class),
        TRACE(HttpTrace.class);

        public final Class<? extends HttpRequestBase> requestClass;

        private HttpMethod(Class<? extends HttpRequestBase> requestClass) {
            this.requestClass = requestClass;
        }

        public String toString() {
            return this.name();
        }
    }
}

