/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.enricher;

import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.enricher.stock.AbstractTypeTransformingEnricher;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Catalog(name="Time-fraction Delta", description="Converts an absolute measure of time into a fraction of time, based on the delta between consecutive values and the elapsed time between those values.")
public class TimeFractionDeltaEnricher<T extends Number>
extends AbstractTypeTransformingEnricher<T, Double> {
    private static final Logger LOG = LoggerFactory.getLogger(TimeFractionDeltaEnricher.class);
    @SetFromFlag
    @Deprecated
    private Long nanosPerOrigUnit;
    @SetFromFlag
    private Duration durationPerOrigUnit;
    protected Number lastValue;
    protected long lastTimestamp = -1L;

    public TimeFractionDeltaEnricher() {
    }

    @Deprecated
    public TimeFractionDeltaEnricher(Entity producer, Sensor<T> source, Sensor<Double> target, TimeUnit origUnits) {
        this(producer, source, target, origUnits.toNanos(1L));
    }

    @Deprecated
    public TimeFractionDeltaEnricher(Entity producer, Sensor<T> source, Sensor<Double> target, long nanosPerOrigUnit) {
        super(producer, source, target);
        this.nanosPerOrigUnit = nanosPerOrigUnit;
        if (source != null && target != null) {
            this.uniqueTag = JavaClassNames.simpleClassName(((Object)((Object)this)).getClass()) + ":" + source.getName() + "*" + Duration.nanos((Number)nanosPerOrigUnit) + "->" + target.getName();
        }
    }

    public void init() {
        super.init();
        if (this.durationPerOrigUnit == null) {
            this.durationPerOrigUnit = this.nanosPerOrigUnit != null ? Duration.nanos((Number)this.nanosPerOrigUnit) : Duration.nanos((Number)1);
        }
        this.nanosPerOrigUnit = null;
        if (this.uniqueTag == null && this.source != null && this.target != null) {
            this.uniqueTag = JavaClassNames.simpleClassName(((Object)((Object)this)).getClass()) + ":" + this.source.getName() + "*" + this.durationPerOrigUnit + "->" + this.target.getName();
        }
    }

    public void rebind() {
        super.rebind();
        if (this.durationPerOrigUnit == null) {
            this.durationPerOrigUnit = this.nanosPerOrigUnit != null ? Duration.nanos((Number)this.nanosPerOrigUnit) : Duration.nanos((Number)1);
        }
        this.nanosPerOrigUnit = null;
    }

    public void onEvent(SensorEvent<T> event) {
        this.onEvent(event, event.getTimestamp());
    }

    public void onEvent(SensorEvent<T> event, long eventTimestamp) {
        Number current = (Number)event.getValue();
        if (current == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("ignoring null value in {}, at {}", new Object[]{this, eventTimestamp});
            }
            return;
        }
        if (eventTimestamp > this.lastTimestamp) {
            if (this.lastValue == null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{} received event but no last value so will not emit, null -> {} at {}", new Object[]{this, current, eventTimestamp});
                }
            } else if (this.lastTimestamp < 0L) {
                LOG.warn("{} has lastValue {} but last timestamp {}; new value is {} at {}; not publishing", new Object[]{this, this.lastValue, this.lastTimestamp, current, eventTimestamp});
            } else {
                long duration = eventTimestamp - this.lastTimestamp;
                double fraction = this.toNanos(current.doubleValue() - this.lastValue.doubleValue(), this.durationPerOrigUnit.nanos()) / (double)TimeUnit.MILLISECONDS.toNanos(duration);
                this.entity.sensors().set((AttributeSensor)this.target, (Object)fraction);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("set {} to {}, {} -> {} at {} (previous at {})", new Object[]{this, fraction, this.lastValue, current, eventTimestamp, this.lastTimestamp});
                }
            }
            this.lastValue = current;
            this.lastTimestamp = eventTimestamp;
        }
    }

    private double toNanos(double val, long nanosPerOrigUnit) {
        return val * (double)nanosPerOrigUnit;
    }
}

