/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.machine.pool;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationDefinition;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.NoMachinesAvailableException;
import org.apache.brooklyn.api.mgmt.LocationManager;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.location.Machines;
import org.apache.brooklyn.core.location.dynamic.DynamicLocation;
import org.apache.brooklyn.core.mgmt.internal.LocalLocationManager;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import org.apache.brooklyn.entity.group.DynamicClusterImpl;
import org.apache.brooklyn.entity.machine.pool.ServerPool;
import org.apache.brooklyn.entity.machine.pool.ServerPoolLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerPoolImpl
extends DynamicClusterImpl
implements ServerPool {
    private static final Logger LOG = LoggerFactory.getLogger(ServerPoolImpl.class);
    private static final AttributeSensor<MachinePoolMemberStatus> SERVER_STATUS = Sensors.newSensor(MachinePoolMemberStatus.class, (String)"pool.serverStatus", (String)"The status of an entity in the pool");
    public static final AttributeSensor<Map<Entity, MachineLocation>> ENTITY_MACHINE = Sensors.newSensor((TypeToken)new TypeToken<Map<Entity, MachineLocation>>(){}, (String)"pool.entityMachineMap", (String)"A mapping of entities and their machine locations");
    public static final AttributeSensor<Map<MachineLocation, Entity>> MACHINE_ENTITY = Sensors.newSensor((TypeToken)new TypeToken<Map<MachineLocation, Entity>>(){}, (String)"pool.machineEntityMap", (String)"A mapping of machine locations and their entities");
    public static final ConfigKey<Boolean> REMOVABLE = ConfigKeys.newBooleanConfigKey((String)"pool.member.removable", (String)"Whether a pool member is removable from the cluster. Used to denote additional existing machines that were manually added to the pool", (Boolean)true);
    private MemberTrackingPolicy membershipTracker;
    private final Function<Collection<Entity>, Entity> UNCLAIMED_REMOVAL_STRATEGY = new Function<Collection<Entity>, Entity>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Entity apply(Collection<Entity> members) {
            Object object = ServerPoolImpl.this.mutex;
            synchronized (object) {
                Optional choice = Lifecycle.STOPPING.equals(ServerPoolImpl.this.getAttribute(Attributes.SERVICE_STATE_ACTUAL)) ? Optional.of((Object)members.iterator().next()) : ServerPoolImpl.this.getMemberWithStatusExcludingUnremovable(members, MachinePoolMemberStatus.UNUSABLE).or(ServerPoolImpl.this.getMemberWithStatusExcludingUnremovable(members, MachinePoolMemberStatus.AVAILABLE));
                if (!choice.isPresent()) {
                    LOG.warn("{} has no machines available to remove!", (Object)this);
                    return null;
                }
                LOG.info("{} selected entity to remove from pool: {}", (Object)this, choice.get());
                ((Entity)choice.get()).getAttribute(SERVER_STATUS);
                ServerPoolImpl.this.setEntityStatus((Entity)choice.get(), null);
                MachineLocation entityLocation = (MachineLocation)ServerPoolImpl.this.getEntityMachineMap().remove(choice.get());
                if (entityLocation != null) {
                    ServerPoolImpl.this.getMachineEntityMap().remove(entityLocation);
                }
                return (Entity)choice.get();
            }
        }
    };

    public void init() {
        super.init();
        this.sensors().set(AVAILABLE_COUNT, (Object)0);
        this.sensors().set(CLAIMED_COUNT, (Object)0);
        this.sensors().set(ENTITY_MACHINE, (Object)Maps.newHashMap());
        this.sensors().set(MACHINE_ENTITY, (Object)Maps.newHashMap());
    }

    public void start(Collection<? extends Location> locations) {
        super.start(locations);
        this.createLocation();
        this.addMembershipTrackerPolicy();
    }

    public void rebind() {
        super.rebind();
        this.addMembershipTrackerPolicy();
        this.createLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        super.stop();
        this.deleteLocation();
        Object object = this.mutex;
        synchronized (object) {
            this.sensors().set(AVAILABLE_COUNT, (Object)0);
            this.sensors().set(CLAIMED_COUNT, (Object)0);
            ((Map)this.sensors().get(ENTITY_MACHINE)).clear();
            ((Map)this.sensors().get(MACHINE_ENTITY)).clear();
        }
    }

    private void addMembershipTrackerPolicy() {
        this.membershipTracker = (MemberTrackingPolicy)this.policies().add((PolicySpec)((PolicySpec)PolicySpec.create(MemberTrackingPolicy.class).displayName(this.getDisplayName() + " membership tracker")).configure((CharSequence)"group", (Object)this));
    }

    public ServerPoolLocation getDynamicLocation() {
        return (ServerPoolLocation)((Object)this.getAttribute(DYNAMIC_LOCATION));
    }

    protected ServerPoolLocation createLocation() {
        return this.createLocation((Map<String, ?>)MutableMap.builder().putAll((Map)this.getConfig(LOCATION_FLAGS)).put((Object)DynamicLocation.OWNER.getName(), (Object)this).build());
    }

    public ServerPoolLocation createLocation(Map<String, ?> flags) {
        String locationName = (String)this.getConfig((ConfigKey.HasConfigKey)LOCATION_NAME);
        if (locationName == null) {
            String prefix = (String)this.getConfig(LOCATION_NAME_PREFIX);
            String suffix = (String)this.getConfig(LOCATION_NAME_SUFFIX);
            locationName = Joiner.on((String)"-").skipNulls().join((Object)prefix, (Object)this.getId(), new Object[]{suffix});
        }
        ServerPoolLocation location = (ServerPoolLocation)this.getManagementContext().getLocationManager().createLocation((LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)LocationSpec.create(ServerPoolLocation.class).displayName("Server Pool(" + this.getId() + ")")).configure(flags)).configure((CharSequence)"owner", (Object)this.getProxy())).configure((CharSequence)"locationName", (Object)locationName));
        LocationDefinition definition = location.register();
        LOG.info("Resolved and registered dynamic location {} for server pool {}: {}", new Object[]{locationName, this, location});
        this.sensors().set(LOCATION_SPEC, (Object)definition.getSpec());
        this.sensors().set((AttributeSensor)LOCATION_NAME, (Object)locationName);
        this.sensors().set(DYNAMIC_LOCATION, (Object)location);
        return location;
    }

    public void deleteLocation() {
        LocationManager mgr = this.getManagementContext().getLocationManager();
        ServerPoolLocation location = this.getDynamicLocation();
        if (location != null && mgr.isManaged((Location)location)) {
            LOG.debug("{} deleting and unmanaging location {}", (Object)this, (Object)location);
            location.deregister();
            mgr.unmanage((Location)location);
        }
        this.sensors().set(LOCATION_SPEC, null);
        this.sensors().set(DYNAMIC_LOCATION, null);
        this.sensors().set((AttributeSensor)LOCATION_NAME, null);
    }

    public boolean isLocationAvailable() {
        return this.getDynamicLocation() != null;
    }

    @Override
    public MachineLocation claimMachine(Map<?, ?> flags) throws NoMachinesAvailableException {
        LOG.info("Obtaining machine with flags: {}", (Object)Joiner.on((String)", ").withKeyValueSeparator("=").join(flags));
        Object object = this.mutex;
        synchronized (object) {
            Optional<Entity> claimed = this.getMemberWithStatus(MachinePoolMemberStatus.AVAILABLE);
            if (claimed.isPresent()) {
                this.setEntityStatus((Entity)claimed.get(), MachinePoolMemberStatus.CLAIMED);
                this.updateCountSensors();
                LOG.debug("{} has been claimed in {}", claimed, (Object)this);
                return this.getEntityMachineMap().get(claimed.get());
            }
            throw new NoMachinesAvailableException("No machines available in " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseMachine(MachineLocation machine) {
        Object object = this.mutex;
        synchronized (object) {
            Entity entity = this.getMachineEntityMap().get(machine);
            if (entity == null) {
                LOG.warn("{} releasing machine {} but its owning entity is not known!", (Object)this, (Object)machine);
            } else {
                this.setEntityStatus(entity, MachinePoolMemberStatus.AVAILABLE);
                this.updateCountSensors();
                LOG.debug("{} has been released in {}", (Object)machine, (Object)this);
            }
        }
    }

    @Override
    public Entity addExistingMachine(MachineLocation machine) {
        LOG.info("Adding additional machine to {}: {}", (Object)this, (Object)machine);
        Entity added = this.addNode((Location)machine, (Map)MutableMap.of(REMOVABLE, (Object)false));
        ImmutableMap args = ImmutableMap.of((Object)"locations", (Object)ImmutableList.of((Object)machine));
        Task task = Effectors.invocation((Entity)added, (Effector)Startable.START, (Map)args).asTask();
        DynamicTasks.queueIfPossible((TaskAdaptable)task).orSubmitAsync((Entity)this);
        return added;
    }

    @Override
    public Collection<Entity> addExistingMachinesFromSpec(String spec) {
        Location location = this.getManagementContext().getLocationManager().createLocation((LocationSpec)((LocationSpec)this.getManagementContext().getLocationRegistry().getLocationSpec(spec).get()).configure(LocalLocationManager.CREATE_UNMANAGED, (Object)true));
        LinkedList additions = Lists.newLinkedList();
        if (location == null) {
            LOG.warn("Spec was unresolvable: {}", (Object)spec);
        } else {
            FluentIterable machines = FluentIterable.from((Iterable)location.getChildren()).filter(MachineLocation.class);
            LOG.info("{} adding additional machines: {}", (Object)this, (Object)machines);
            for (MachineLocation machine : machines) {
                additions.add(this.addExistingMachine(machine));
            }
            LOG.debug("{} added additional machines", (Object)this);
        }
        return additions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Entity> shrink(int delta) {
        if (Lifecycle.STOPPING.equals(this.getAttribute(Attributes.SERVICE_STATE_ACTUAL))) {
            return super.shrink(delta);
        }
        Object object = this.mutex;
        synchronized (object) {
            int removable = 0;
            for (Entity entity : this.getMembers()) {
                if (Boolean.FALSE.equals(entity.getConfig(REMOVABLE)) || MachinePoolMemberStatus.CLAIMED.equals(entity.getAttribute(SERVER_STATUS))) continue;
                --removable;
            }
            if (delta < removable) {
                LOG.warn("Too few removable machines in {} to shrink by delta {}. Altered delta to {}", new Object[]{this, delta, removable});
                delta = removable;
            }
            Collection removed = super.shrink(delta);
            this.updateCountSensors();
            return removed;
        }
    }

    private Map<Entity, MachineLocation> getEntityMachineMap() {
        return (Map)this.getAttribute(ENTITY_MACHINE);
    }

    private Map<MachineLocation, Entity> getMachineEntityMap() {
        return (Map)this.getAttribute(MACHINE_ENTITY);
    }

    public Function<Collection<Entity>, Entity> getRemovalStrategy() {
        return this.UNCLAIMED_REMOVAL_STRATEGY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverAdded(Entity member) {
        Maybe machine = Machines.findUniqueMachineLocation((Iterable)member.getLocations());
        if (member.getAttribute(SERVER_STATUS) != null) {
            LOG.debug("Skipped addition of machine already in the pool: {}", (Object)member);
        } else if (machine.isPresentAndNonNull()) {
            MachineLocation m = (MachineLocation)machine.get();
            LOG.info("New machine in {}: {}", (Object)this, (Object)m);
            this.setEntityStatus(member, MachinePoolMemberStatus.AVAILABLE);
            Object object = this.mutex;
            synchronized (object) {
                this.getEntityMachineMap().put(member, m);
                this.getMachineEntityMap().put(m, member);
                this.updateCountSensors();
            }
        } else {
            LOG.warn("Member added to {} that does not have a machine location; it will not be used by the pool: {}", (Object)this, (Object)member);
            this.setEntityStatus(member, MachinePoolMemberStatus.UNUSABLE);
        }
    }

    private void setEntityStatus(Entity entity, MachinePoolMemberStatus status) {
        ((EntityInternal)entity).sensors().set(SERVER_STATUS, (Object)status);
    }

    private Optional<Entity> getMemberWithStatus(MachinePoolMemberStatus status) {
        return this.getMemberWithStatus0(this.getMembers(), status, true);
    }

    private Optional<Entity> getMemberWithStatusExcludingUnremovable(Collection<Entity> entities, MachinePoolMemberStatus status) {
        return this.getMemberWithStatus0(entities, status, false);
    }

    private Optional<Entity> getMemberWithStatus0(Collection<Entity> entities, final MachinePoolMemberStatus status, final boolean includeUnremovableMachines) {
        return Iterables.tryFind(entities, (Predicate)new Predicate<Entity>(){

            public boolean apply(Entity input) {
                return (includeUnremovableMachines || ServerPoolImpl.this.isRemovable(input)) && status.equals(input.getAttribute(SERVER_STATUS));
            }
        });
    }

    private boolean isRemovable(Entity entity) {
        return !Boolean.FALSE.equals(entity.getConfig(REMOVABLE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCountSensors() {
        Object object = this.mutex;
        synchronized (object) {
            int available = 0;
            int claimed = 0;
            for (Entity member : this.getMembers()) {
                MachinePoolMemberStatus status = (MachinePoolMemberStatus)((Object)member.getAttribute(SERVER_STATUS));
                if (MachinePoolMemberStatus.AVAILABLE.equals((Object)status)) {
                    ++available;
                    continue;
                }
                if (!MachinePoolMemberStatus.CLAIMED.equals((Object)status)) continue;
                ++claimed;
            }
            this.sensors().set(AVAILABLE_COUNT, (Object)available);
            this.sensors().set(CLAIMED_COUNT, (Object)claimed);
        }
    }

    public static class MemberTrackingPolicy
    extends AbstractMembershipTrackingPolicy {
        protected void onEntityEvent(AbstractMembershipTrackingPolicy.EventType type, Entity member) {
            Boolean isUp = (Boolean)member.getAttribute(Attributes.SERVICE_UP);
            LOG.info("{} in {}: {} service up is {}", new Object[]{type.name(), this.entity, member, isUp});
            this.defaultHighlightAction(type, (Entity)this.entity, "Update on %s %s (service " + (isUp == Boolean.TRUE ? "up" : (isUp == Boolean.FALSE ? "not up" : "up value not known")) + ")");
            if (type.equals((Object)AbstractMembershipTrackingPolicy.EventType.ENTITY_ADDED) || type.equals((Object)AbstractMembershipTrackingPolicy.EventType.ENTITY_CHANGE)) {
                if (Boolean.TRUE.equals(isUp)) {
                    ((ServerPoolImpl)this.entity).serverAdded(member);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("{} observed event {} but {} is not up (yet) and will not be used by the pool", new Object[]{this.entity, type.name(), member});
                }
            }
        }
    }

    private static enum MachinePoolMemberStatus {
        AVAILABLE,
        CLAIMED,
        UNUSABLE;

    }
}

