/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.policy.Policies;
import org.apache.brooklyn.rest.api.PolicyApi;
import org.apache.brooklyn.rest.domain.PolicySummary;
import org.apache.brooklyn.rest.domain.Status;
import org.apache.brooklyn.rest.domain.SummaryComparators;
import org.apache.brooklyn.rest.filter.HaHotStateRequired;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.transform.ApplicationTransformer;
import org.apache.brooklyn.rest.transform.PolicyTransformer;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HaHotStateRequired
@Deprecated
public class PolicyResource
extends AbstractBrooklynRestResource
implements PolicyApi {
    private static final Logger log = LoggerFactory.getLogger(PolicyResource.class);
    @Context
    private UriInfo ui;

    public List<PolicySummary> list(String application, String entityToken) {
        final Entity entity = this.brooklyn().getEntity(application, entityToken);
        return FluentIterable.from((Iterable)entity.policies()).transform((Function)new Function<Policy, PolicySummary>(){

            public PolicySummary apply(Policy policy) {
                return PolicyTransformer.policySummary(entity, policy, PolicyResource.this.ui.getBaseUriBuilder());
            }
        }).toSortedList(SummaryComparators.nameComparator());
    }

    public Map<String, Boolean> batchConfigRead(String application, String entityToken) {
        Entity entity = this.brooklyn().getEntity(application, entityToken);
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Policy p : entity.policies()) {
            result.put(p.getId(), !p.isSuspended());
        }
        return result;
    }

    public PolicySummary addPolicy(String application, String entityToken, String policyTypeName, Map<String, String> config) {
        PolicySpec policySpec;
        Entity entity = this.brooklyn().getEntity(application, entityToken);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.ADD_POLICY, (Object)Entitlements.StringAndArgument.of((String)policyTypeName, (Object)"create"))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to add policies", Entitlements.getEntitlementContext().user());
        }
        try {
            ManagementContext managementContext = this.mgmt();
            Maybe maybePolicy = managementContext.getTypeRegistry().getMaybe(policyTypeName, null).map(registeredType -> managementContext.getTypeRegistry().get(policyTypeName));
            if (maybePolicy.isPresent()) {
                RegisteredType registeredType2 = (RegisteredType)maybePolicy.get();
                policySpec = (PolicySpec)managementContext.getTypeRegistry().createSpec(registeredType2, null, PolicySpec.class);
            } else {
                Class policyType = new ClassLoaderUtils((Object)this, this.mgmt()).loadClass(policyTypeName);
                policySpec = PolicySpec.create((Class)policyType);
            }
        }
        catch (ClassCastException e) {
            throw WebResourceUtils.badRequest("No policy with type %s found", policyTypeName);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
        policySpec.configure(config);
        Policy policy = entity.policies().add(policySpec);
        log.debug("REST API added policy " + policy + " to " + entity);
        return PolicyTransformer.policySummary(entity, policy, this.ui.getBaseUriBuilder());
    }

    public Status getStatus(String application, String entityToken, String policyId) {
        Policy policy = this.brooklyn().getPolicy(application, entityToken, policyId);
        return ApplicationTransformer.statusFromLifecycle(Policies.getPolicyStatus((Policy)policy));
    }

    public Response start(String application, String entityToken, String policyId) {
        Policy policy = this.brooklyn().getPolicy(application, entityToken, policyId);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.START_POLICY, (Object)policy)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to start policy '%s'", Entitlements.getEntitlementContext().user(), policy);
        }
        policy.resume();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response stop(String application, String entityToken, String policyId) {
        Policy policy = this.brooklyn().getPolicy(application, entityToken, policyId);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.STOP_POLICY, (Object)policy)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to stop the policy '%s'", Entitlements.getEntitlementContext().user(), policy);
        }
        policy.suspend();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response destroy(String application, String entityToken, String policyToken) {
        Entity entity = this.brooklyn().getEntity(application, entityToken);
        Policy policy = this.brooklyn().getPolicy(entity, policyToken);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.DELETE_POLICY, (Object)policy)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to remove policy '%s'", Entitlements.getEntitlementContext().user(), policy);
        }
        policy.suspend();
        entity.policies().remove(policy);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

