/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.internal;

import com.google.common.base.Predicate;
import java.util.Set;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.internal.NonDeploymentManagementContext;
import org.apache.brooklyn.core.mgmt.usage.ApplicationUsage;
import org.apache.brooklyn.core.mgmt.usage.LocationUsage;
import org.apache.brooklyn.core.mgmt.usage.UsageListener;
import org.apache.brooklyn.core.mgmt.usage.UsageManager;

public class NonDeploymentUsageManager
implements UsageManager {
    private final ManagementContextInternal initialManagementContext;

    public NonDeploymentUsageManager(ManagementContextInternal initialManagementContext) {
        this.initialManagementContext = initialManagementContext;
    }

    private boolean isInitialManagementContextReal() {
        return this.initialManagementContext != null && !(this.initialManagementContext instanceof NonDeploymentManagementContext);
    }

    @Override
    public void recordApplicationEvent(Application app, Lifecycle state) {
        if (!this.isInitialManagementContextReal()) {
            throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
        }
        this.initialManagementContext.getUsageManager().recordApplicationEvent(app, state);
    }

    @Override
    public void recordLocationEvent(Location loc, Lifecycle state) {
        if (!this.isInitialManagementContextReal()) {
            throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
        }
        this.initialManagementContext.getUsageManager().recordLocationEvent(loc, state);
    }

    @Override
    public LocationUsage getLocationUsage(String locationId) {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getUsageManager().getLocationUsage(locationId);
        }
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
    }

    @Override
    public Set<LocationUsage> getLocationUsage(Predicate<? super LocationUsage> filter) {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getUsageManager().getLocationUsage(filter);
        }
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
    }

    @Override
    public ApplicationUsage getApplicationUsage(String appId) {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getUsageManager().getApplicationUsage(appId);
        }
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
    }

    @Override
    public Set<ApplicationUsage> getApplicationUsage(Predicate<? super ApplicationUsage> filter) {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getUsageManager().getApplicationUsage(filter);
        }
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
    }

    @Override
    public void addUsageListener(UsageListener listener) {
        if (!this.isInitialManagementContextReal()) {
            throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
        }
        this.initialManagementContext.getUsageManager().addUsageListener(listener);
    }

    @Override
    public void removeUsageListener(UsageListener listener) {
        if (!this.isInitialManagementContextReal()) {
            throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
        }
        this.initialManagementContext.getUsageManager().removeUsageListener(listener);
    }
}

