/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.logging.Logger;
import org.jclouds.softlayer.compute.functions.VirtualGuestToHardware;
import org.jclouds.softlayer.compute.functions.VirtualGuestToImage;
import org.jclouds.softlayer.domain.Password;
import org.jclouds.softlayer.domain.TagReference;
import org.jclouds.softlayer.domain.VirtualGuest;

@Singleton
public class VirtualGuestToNodeMetadata
implements Function<VirtualGuest, NodeMetadata> {
    @Resource
    protected Logger logger = Logger.NULL;
    public static final Map<VirtualGuest.State, NodeMetadata.Status> serverStateToNodeStatus = ImmutableMap.builder().put((Object)VirtualGuest.State.HALTED, (Object)NodeMetadata.Status.PENDING).put((Object)VirtualGuest.State.PAUSED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)VirtualGuest.State.RUNNING, (Object)NodeMetadata.Status.RUNNING).put((Object)VirtualGuest.State.UNRECOGNIZED, (Object)NodeMetadata.Status.UNRECOGNIZED).build();
    private final Supplier<Set<? extends Location>> locations;
    private final GroupNamingConvention nodeNamingConvention;
    private final VirtualGuestToImage virtualGuestToImage;
    private final VirtualGuestToHardware virtualGuestToHardware;

    @Inject
    VirtualGuestToNodeMetadata(@Memoized Supplier<Set<? extends Location>> locations, GroupNamingConvention.Factory namingConvention, VirtualGuestToImage virtualGuestToImage, VirtualGuestToHardware virtualGuestToHardware) {
        this.nodeNamingConvention = ((GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"namingConvention")).createWithoutPrefix();
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
        this.virtualGuestToImage = (VirtualGuestToImage)Preconditions.checkNotNull((Object)virtualGuestToImage, (Object)"virtualGuestToImage");
        this.virtualGuestToHardware = (VirtualGuestToHardware)Preconditions.checkNotNull((Object)virtualGuestToHardware, (Object)"virtualGuestToHardware");
    }

    public NodeMetadata apply(VirtualGuest from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getId() + "");
        builder.name(from.getHostname());
        builder.hostname(from.getFullyQualifiedDomainName());
        if (from.getDatacenter() != null) {
            builder.location((Location)FluentIterable.from((Iterable)((Iterable)this.locations.get())).firstMatch(LocationPredicates.idEquals((String)from.getDatacenter().getName())).orNull());
        }
        builder.group(this.nodeNamingConvention.groupInUniqueNameOrNull(from.getHostname()));
        builder.hardware(this.virtualGuestToHardware.apply(from));
        Image image = this.virtualGuestToImage.apply(from);
        if (image != null) {
            builder.imageId(image.getId());
            builder.operatingSystem(image.getOperatingSystem());
        }
        if (from.getPowerState() != null) {
            builder.status(serverStateToNodeStatus.get((Object)from.getPowerState().getKeyName()));
        }
        if (from.getPrimaryIpAddress() != null) {
            builder.publicAddresses((Iterable)ImmutableSet.of((Object)from.getPrimaryIpAddress()));
        }
        if (from.getPrimaryBackendIpAddress() != null) {
            builder.privateAddresses((Iterable)ImmutableSet.of((Object)from.getPrimaryBackendIpAddress()));
        }
        if (from.getOperatingSystem() != null && from.getOperatingSystem().getPasswords() != null && !from.getOperatingSystem().getPasswords().isEmpty()) {
            Password password = this.getBestPassword(from.getOperatingSystem().getPasswords(), from);
            builder.credentials(LoginCredentials.builder().identity(password.getUsername()).credential(password.getPassword()).build());
        }
        if (from.getTagReferences() != null && !from.getTagReferences().isEmpty()) {
            ArrayList tags = Lists.newArrayList();
            for (TagReference tagReference : from.getTagReferences()) {
                if (tagReference == null) continue;
                tags.add(tagReference.getTag().getName());
            }
            builder.tags((Iterable)tags);
        }
        return builder.build();
    }

    @VisibleForTesting
    Password getBestPassword(Set<Password> passwords, VirtualGuest context) {
        if (passwords == null || passwords.isEmpty()) {
            throw new IllegalStateException("No credentials declared for " + context);
        }
        if (passwords.size() == 1) {
            return (Password)Iterables.getOnlyElement(passwords);
        }
        Password bestPassword = null;
        LinkedHashSet alternates = Sets.newLinkedHashSet();
        int bestScore = -1;
        for (Password p : passwords) {
            int score = -1;
            if ("root".equals(p.getUsername())) {
                score = 10;
            } else if ("root".equalsIgnoreCase(p.getUsername())) {
                score = 4;
            } else if ("ubuntu".equals(p.getUsername())) {
                score = 8;
            } else if ("ubuntu".equalsIgnoreCase(p.getUsername())) {
                score = 3;
            } else if ("administrator".equals(p.getUsername())) {
                score = 5;
            } else if ("administrator".equalsIgnoreCase(p.getUsername())) {
                score = 2;
            } else if (p.getUsername() != null && p.getUsername().length() > 1) {
                score = 1;
            }
            if (score <= 0) continue;
            if (score > bestScore) {
                bestPassword = p;
                alternates.clear();
                bestScore = score;
                continue;
            }
            if (score != bestScore) continue;
            alternates.add(p);
        }
        if (bestPassword == null) {
            throw new IllegalStateException("No valid credentials available for " + context + "; found: " + passwords);
        }
        if (!alternates.isEmpty()) {
            this.logger.warn("Multiple credentials for " + bestPassword.getUsername() + "@" + context + "; using first declared " + bestPassword + " and ignoring " + alternates, new Object[0]);
        } else {
            this.logger.debug("Multiple credentials for " + context + "; using preferred username " + bestPassword.getUsername(), new Object[0]);
        }
        return bestPassword;
    }
}

