/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.text;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Chars;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.brooklyn.util.collections.MutableSet;

public class Identifiers {
    public static final String UPPER_CASE_ALPHA = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String LOWER_CASE_ALPHA = "abcdefghijklmnopqrstuvwxyz";
    public static final String NUMERIC = "1234567890";
    public static final String NON_ALPHA_NUMERIC = "!@$%^&*()-_=+[]{};:\\|/?,.<>~";
    public static final String JAVA_GOOD_START_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_";
    public static final String JAVA_GOOD_NONSTART_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_1234567890";
    public static final String JAVA_GOOD_SEGMENT_REGEX = "[ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_][ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_1234567890]*";
    public static final String JAVA_GOOD_PACKAGE_OR_CLASS_REGEX = "([ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_][ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_1234567890]*\\.)*[ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_][ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_1234567890]*";
    public static final String JAVA_GOOD_BINARY_REGEX = "([ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_][ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_1234567890]*\\.)*[ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_][ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_1234567890]*(\\$[ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_1234567890]+)*";
    public static final String JAVA_GENERATED_IDENTIFIER_START_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String JAVA_GENERATED_IDENTIFIERNONSTART_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890";
    public static final String BASE64_VALID_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890+=";
    public static final String ID_VALID_START_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String ID_VALID_NONSTART_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890";
    public static final String PASSWORD_VALID_CHARS = "!@$%^&*()-_=+[]{};:\\|/?,.<>~ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890";
    private static Random secureRandom = null;
    private static Random random = null;

    private static String makeRandomId(int l, String validStartChars, String validNonStartChars) {
        if (l <= 0) {
            return "";
        }
        char[] id = new char[l];
        int s = validStartChars.length();
        int n = validNonStartChars.length();
        int d = random.nextInt(s * n * n * n);
        int i = 0;
        id[i] = validStartChars.charAt(d % s);
        d /= s;
        if (++i < l) {
            while (true) {
                id[i] = validNonStartChars.charAt(d % n);
                if (++i >= l) break;
                if (i % 4 == 0) {
                    d = random.nextInt(n * n * n * n);
                    continue;
                }
                d /= n;
            }
        }
        return new String(id);
    }

    public static String makeRandomId(int l) {
        return Identifiers.makeRandomId(l, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890");
    }

    public static String makeRandomLowercaseId(int l) {
        return Identifiers.makeRandomId(l, LOWER_CASE_ALPHA, "abcdefghijklmnopqrstuvwxyz1234567890");
    }

    public static String makeRandomPassword(int length) {
        return Identifiers.makeRandomPassword(length, UPPER_CASE_ALPHA, LOWER_CASE_ALPHA, NUMERIC, NON_ALPHA_NUMERIC, PASSWORD_VALID_CHARS);
    }

    public static String makeRandomPassword(int length, String ... passwordValidCharsPool) {
        Preconditions.checkState((length >= passwordValidCharsPool.length ? 1 : 0) != 0);
        int l = 0;
        Character[] password = new Character[length];
        for (int i = 0; i < passwordValidCharsPool.length; ++i) {
            password[l++] = Character.valueOf(Identifiers.pickRandomCharFrom(passwordValidCharsPool[i]));
        }
        String remainingValidChars = Identifiers.mergeCharacterSets(passwordValidCharsPool);
        while (l < length) {
            password[l++] = Character.valueOf(Identifiers.pickRandomCharFrom(remainingValidChars));
        }
        List<Character> list = Arrays.asList(password);
        Collections.shuffle(list);
        return Joiner.on((String)"").join(list);
    }

    protected static String mergeCharacterSets(String ... s) {
        MutableSet characters = MutableSet.of();
        for (String characterSet : s) {
            for (char c : characterSet.toCharArray()) {
                characters.add(Character.valueOf(c));
            }
        }
        return new String(Chars.toArray(characters));
    }

    public static String makeIdFromHash(long d) {
        StringBuffer result = new StringBuffer();
        if (d < 0L) {
            d = -d;
        }
        if (d < 0L) {
            d = -(d + 1000L);
        }
        result.append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".charAt((int)(d % 52L)));
        d /= 52L;
        while (d != 0L) {
            result.append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890".charAt((int)(d % 62L)));
            d /= 62L;
        }
        return result.toString();
    }

    public static String makeRandomJavaId(int l) {
        return Identifiers.makeRandomId(l, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890");
    }

    public static double randomDouble() {
        return random.nextDouble();
    }

    public static long randomLong() {
        return random.nextLong();
    }

    public static boolean randomBoolean() {
        return random.nextBoolean();
    }

    public static int randomInt() {
        return random.nextInt();
    }

    public static int randomInt(int upbound) {
        return random.nextInt(upbound);
    }

    public static byte[] randomBytes(byte[] buf) {
        random.nextBytes(buf);
        return buf;
    }

    public static byte[] randomBytes(int length) {
        byte[] buf = new byte[length];
        return Identifiers.randomBytes(buf);
    }

    public static String makeRandomBase64Id(int length) {
        StringBuilder s = new StringBuilder();
        while (length > 0) {
            Identifiers.appendBase64IdFromValueOfLength(Identifiers.randomLong(), length > 10 ? 10 : length, s);
            length -= 10;
        }
        return s.toString();
    }

    public static String getBase64IdFromValue(long value) {
        return Identifiers.getBase64IdFromValue(value, 10);
    }

    public static String getBase64IdFromValue(long value, int length) {
        StringBuilder s = new StringBuilder();
        Identifiers.appendBase64IdFromValueOfLength(value, length, s);
        return s.toString();
    }

    public static void appendBase64IdFromValueOfLength(long value, int length, StringBuffer sb) {
        if (length > 11) {
            throw new IllegalArgumentException("can't get a Base64 string longer than 11 chars from a long");
        }
        long idx = value;
        for (int i = 0; i < length; ++i) {
            byte x = (byte)(idx & 0x3FL);
            sb.append(BASE64_VALID_CHARS.charAt(x));
            idx >>= 6;
        }
    }

    public static void appendBase64IdFromValueOfLength(long value, int length, StringBuilder sb) {
        if (length > 11) {
            throw new IllegalArgumentException("can't get a Base64 string longer than 11 chars from a long");
        }
        long idx = value;
        for (int i = 0; i < length; ++i) {
            byte x = (byte)(idx & 0x3FL);
            sb.append(BASE64_VALID_CHARS.charAt(x));
            idx >>= 6;
        }
    }

    public static boolean isValidToken(String token, String validStartChars, String validSubsequentChars) {
        if (token == null || token.length() == 0) {
            return false;
        }
        if (validStartChars.indexOf(token.charAt(0)) == -1) {
            return false;
        }
        for (int i = 1; i < token.length(); ++i) {
            if (validSubsequentChars.indexOf(token.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    private static char pickRandomCharFrom(String validChars) {
        return validChars.charAt(Identifiers.getSecureRandom().nextInt(validChars.length()));
    }

    private static Random getSecureRandom() {
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        return secureRandom;
    }

    static {
        Long seed = Long.getLong("brooklyn.experimental.feature.random_seed");
        random = seed != null ? new Random(seed) : new Random();
    }
}

