/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.net.HostAndPort;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.time.Duration;
import org.jclouds.domain.LoginCredentials;

@Beta
public class ConnectivityResolverOptions {
    private final boolean isWindows;
    private final boolean waitForConnectable;
    private final boolean pollForReachableAddresses;
    private final Predicate<? super HostAndPort> reachableAddressPredicate;
    private final boolean propagatePollForReachableFailure;
    private final Duration reachableAddressTimeout;
    private final LoginCredentials initialCredentials;
    private final LoginCredentials userCredentials;
    private final int defaultLoginPort;
    private final boolean usePortForwarding;
    private final HostAndPort portForwardSshOverride;
    private final boolean isRebinding;
    private final boolean skipJcloudsSshing;

    public static Builder builder() {
        return new Builder();
    }

    protected ConnectivityResolverOptions(boolean isWindows, boolean waitForConnectable, boolean pollForReachableAddresses, Predicate<? super HostAndPort> reachableAddressPredicate, boolean propagatePollForReachableFailure, Duration reachableAddressTimeout, LoginCredentials initialCredentials, LoginCredentials userCredentials, int defaultLoginPort, boolean usePortForwarding, HostAndPort portForwardSshOverride, boolean isRebinding, boolean skipJcloudsSshing) {
        this.isWindows = isWindows;
        this.waitForConnectable = waitForConnectable;
        this.pollForReachableAddresses = pollForReachableAddresses;
        this.reachableAddressPredicate = reachableAddressPredicate;
        this.propagatePollForReachableFailure = propagatePollForReachableFailure;
        this.reachableAddressTimeout = reachableAddressTimeout;
        this.initialCredentials = initialCredentials;
        this.userCredentials = userCredentials;
        this.defaultLoginPort = defaultLoginPort;
        this.usePortForwarding = usePortForwarding;
        this.portForwardSshOverride = portForwardSshOverride;
        this.isRebinding = isRebinding;
        this.skipJcloudsSshing = skipJcloudsSshing;
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public boolean waitForConnectable() {
        return this.waitForConnectable;
    }

    public boolean pollForReachableAddresses() {
        return this.pollForReachableAddresses;
    }

    public Predicate<? super HostAndPort> reachableAddressPredicate() {
        return this.reachableAddressPredicate;
    }

    public Duration reachableAddressTimeout() {
        return this.reachableAddressTimeout;
    }

    public boolean propagatePollForReachableFailure() {
        return this.propagatePollForReachableFailure;
    }

    public Optional<LoginCredentials> initialCredentials() {
        return Optional.fromNullable((Object)this.initialCredentials);
    }

    public Optional<LoginCredentials> userCredentials() {
        return Optional.fromNullable((Object)this.userCredentials);
    }

    public boolean usePortForwarding() {
        return this.usePortForwarding;
    }

    public Optional<HostAndPort> portForwardSshOverride() {
        return Optional.fromNullable((Object)this.portForwardSshOverride);
    }

    public int defaultLoginPort() {
        return this.defaultLoginPort;
    }

    public boolean skipJcloudsSshing() {
        return this.skipJcloudsSshing;
    }

    public boolean isRebinding() {
        return this.isRebinding;
    }

    public Builder toBuilder() {
        Builder builder = ConnectivityResolverOptions.builder().isWindows(this.isWindows).waitForConnectable(this.waitForConnectable).usePortForwarding(this.usePortForwarding).portForwardSshOverride(this.portForwardSshOverride).skipJcloudsSshing(this.skipJcloudsSshing).initialCredentials(this.initialCredentials).userCredentials(this.userCredentials).isRebinding(this.isRebinding).defaultLoginPort(this.defaultLoginPort);
        if (this.pollForReachableAddresses) {
            builder.pollForReachableAddresses(this.reachableAddressPredicate, this.reachableAddressTimeout, this.propagatePollForReachableFailure);
        } else {
            builder.noPollForReachableAddresses();
        }
        return builder;
    }

    public static class Builder {
        private boolean isWindows = false;
        private boolean waitForConnectable;
        private boolean pollForReachableAddresses;
        private Predicate<? super HostAndPort> reachableAddressPredicate;
        private Duration reachableAddressTimeout;
        private boolean propagatePollForReachableFailure;
        private LoginCredentials initialCredentials;
        private LoginCredentials userCredentials;
        private int defaultLoginPort;
        private boolean usePortForwarding;
        private HostAndPort portForwardSshOverride;
        private boolean isRebinding;
        private boolean skipJcloudsSshing;

        public Builder pollForReachableAddresses(@Nonnull Predicate<? super HostAndPort> reachable, @Nonnull Duration timeout, boolean propagatePollFailure) {
            this.pollForReachableAddresses = true;
            this.reachableAddressPredicate = reachable;
            this.reachableAddressTimeout = timeout;
            this.propagatePollForReachableFailure = propagatePollFailure;
            return this;
        }

        public Builder noPollForReachableAddresses() {
            this.pollForReachableAddresses = false;
            this.reachableAddressPredicate = null;
            this.reachableAddressTimeout = null;
            this.propagatePollForReachableFailure = false;
            return this;
        }

        public Builder initialCredentials(@Nullable LoginCredentials initialCredentials) {
            this.initialCredentials = initialCredentials;
            return this;
        }

        public Builder userCredentials(@Nullable LoginCredentials userCredentials) {
            this.userCredentials = userCredentials;
            return this;
        }

        public Builder isWindows(boolean windows) {
            this.isWindows = windows;
            return this;
        }

        public Builder portForwardSshOverride(@Nullable HostAndPort hostAndPortOverride) {
            this.portForwardSshOverride = hostAndPortOverride;
            return this;
        }

        public Builder isRebinding(boolean isRebinding) {
            this.isRebinding = isRebinding;
            return this;
        }

        public Builder skipJcloudsSshing(boolean skipJcloudsSshing) {
            this.skipJcloudsSshing = skipJcloudsSshing;
            return this;
        }

        public Builder defaultLoginPort(int defaultLoginPort) {
            this.defaultLoginPort = defaultLoginPort;
            return this;
        }

        public Builder usePortForwarding(boolean usePortForwarding) {
            this.usePortForwarding = usePortForwarding;
            return this;
        }

        public Builder waitForConnectable(boolean waitForConnectable) {
            this.waitForConnectable = waitForConnectable;
            return this;
        }

        public ConnectivityResolverOptions build() {
            return new ConnectivityResolverOptions(this.isWindows, this.waitForConnectable, this.pollForReachableAddresses, this.reachableAddressPredicate, this.propagatePollForReachableFailure, this.reachableAddressTimeout, this.initialCredentials, this.userCredentials, this.defaultLoginPort, this.usePortForwarding, this.portForwardSshOverride, this.isRebinding, this.skipJcloudsSshing);
        }
    }
}

