/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.kafka;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.entity.java.JavaSoftwareProcessSshDriver;
import org.apache.brooklyn.entity.messaging.kafka.KafkaZooKeeperSshDriver;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractfKafkaSshDriver
extends JavaSoftwareProcessSshDriver {
    private static final Logger log = LoggerFactory.getLogger(KafkaZooKeeperSshDriver.class);

    public AbstractfKafkaSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    protected abstract Map<String, Integer> getPortMap();

    protected abstract ConfigKey<String> getConfigTemplateKey();

    protected abstract String getConfigFileName();

    protected abstract String getLaunchScriptName();

    protected abstract String getTopicsScriptName();

    protected abstract String getProcessIdentifier();

    protected String getLogFileLocation() {
        return Os.mergePaths((String[])new String[]{this.getRunDir(), "console.out"});
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        LinkedList<String> commands = new LinkedList<String>();
        commands.addAll(BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs));
        commands.add(BashCommands.INSTALL_TAR);
        commands.add("tar xzfv " + saveAs);
        commands.add("cd " + this.getExpandedInstallDir());
        this.newScript((String)"installing").body.append(commands).execute();
    }

    public void customize() {
        Networking.checkPortsValid(this.getPortMap());
        this.newScript((String)"customizing").failOnNonZeroResultCode().body.append((CharSequence)String.format("cp -R %s/* %s", this.getExpandedInstallDir(), this.getRunDir())).execute();
        String config = (String)this.entity.getConfig(this.getConfigTemplateKey());
        this.copyTemplate(config, this.getConfigFileName());
    }

    public void launch() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), (String)"launching").failOnNonZeroResultCode().body.append((CharSequence)String.format("nohup ./bin/%s ./%s > console.out 2>&1 &", this.getLaunchScriptName(), this.getConfigFileName())).execute();
    }

    public String getPidFile() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "kafka.pid"});
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "check-running").execute() == 0;
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"stopping").body.append((CharSequence)String.format((String)"ps ax | grep %s | awk '{print $1}' | xargs kill", (Object[])new Object[]{this.getProcessIdentifier()})).body.append((CharSequence)String.format("ps ax | grep %s | awk '{print $1}' | xargs kill -9", this.getProcessIdentifier())).execute();
    }

    public Map<String, String> getShellEnvironment() {
        return MutableMap.builder().putAll(super.getShellEnvironment()).renameKey((Object)"JAVA_OPTS", (Object)"KAFKA_JMX_OPTS").build();
    }
}

