/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jclouds.googlecomputeengine.domain.AutoValue_Operation;
import org.jclouds.googlecomputeengine.domain.AutoValue_Operation_Error;
import org.jclouds.googlecomputeengine.domain.AutoValue_Operation_Error_Entry;
import org.jclouds.googlecomputeengine.domain.Warning;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class Operation {
    public abstract String id();

    @Nullable
    public abstract Date creationTimestamp();

    public abstract URI selfLink();

    public abstract String name();

    @Nullable
    public abstract String description();

    public abstract URI targetLink();

    @Nullable
    public abstract String targetId();

    @Nullable
    public abstract String clientOperationId();

    public abstract Status status();

    @Nullable
    public abstract String statusMessage();

    @Nullable
    public abstract String user();

    @Nullable
    public abstract Integer progress();

    public abstract Date insertTime();

    @Nullable
    public abstract Date startTime();

    @Nullable
    public abstract Date endTime();

    @Nullable
    public abstract Integer httpErrorStatusCode();

    @Nullable
    public abstract String httpErrorMessage();

    public abstract String operationType();

    public abstract Error error();

    @Nullable
    public abstract List<Warning> warnings();

    @Nullable
    public abstract URI region();

    @Nullable
    public abstract URI zone();

    @SerializedNames(value={"id", "creationTimestamp", "selfLink", "name", "description", "targetLink", "targetId", "clientOperationId", "status", "statusMessage", "user", "progress", "insertTime", "startTime", "endTime", "httpErrorStatusCode", "httpErrorMessage", "operationType", "error", "warnings", "region", "zone"})
    public static Operation create(String id, Date creationTimestamp, URI selfLink, String name, String description, URI targetLink, String targetId, String clientOperationId, Status status, String statusMessage, String user, Integer progress, Date insertTime, Date startTime, Date endTime, Integer httpErrorStatusCode, String httpErrorMessage, String operationType, Error error, List<Warning> warnings, URI region, URI zone) {
        return new AutoValue_Operation(id, creationTimestamp, selfLink, name, description, targetLink, targetId, clientOperationId, status, statusMessage, user, progress, insertTime, startTime, endTime, httpErrorStatusCode, httpErrorMessage, operationType, error != null ? error : Error.empty(), warnings, region, zone);
    }

    Operation() {
    }

    public static enum Status {
        PENDING,
        RUNNING,
        DONE;

    }

    public static abstract class Error {
        public abstract List<Entry> errors();

        @SerializedNames(value={"errors"})
        public static Error create(List<Entry> errors) {
            return new AutoValue_Operation_Error(errors != null ? errors : new ArrayList());
        }

        public static Error empty() {
            return Error.create(null);
        }

        Error() {
        }

        public static abstract class Entry {
            public abstract String code();

            @Nullable
            public abstract String location();

            @Nullable
            public abstract String message();

            @SerializedNames(value={"code", "location", "message"})
            public static Entry create(String code, String location, String message) {
                return new AutoValue_Operation_Error_Entry(code, location, message);
            }

            Entry() {
            }
        }
    }
}

