/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.byon;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationRegistry;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.core.location.AbstractLocationResolver;
import org.apache.brooklyn.core.location.LocationConfigUtils;
import org.apache.brooklyn.core.location.LocationPropertiesFromBrooklynProperties;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.location.byon.SingleMachineProvisioningLocation;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.KeyValueParser;

public class HostLocationResolver
extends AbstractLocationResolver {
    private static final String HOST = "host";

    @Override
    public LocationSpec<?> newLocationSpecFromString(String spec, Map<?, ?> locationFlags, LocationRegistry registry) {
        AbstractLocationResolver.ParsedSpec parsedSpec = this.specParser.parse(spec);
        ImmutableMap argsMap = parsedSpec.argsMap;
        if (argsMap.isEmpty()) {
            throw new IllegalArgumentException("Invalid host spec (no host supplied): " + spec);
        }
        if (argsMap.size() == 1 && Iterables.get(argsMap.values(), (int)0) == null) {
            argsMap = ImmutableMap.of((Object)"hosts", (Object)Iterables.get(argsMap.keySet(), (int)0));
        } else if (!argsMap.containsKey(HOST) && !argsMap.containsKey("hosts")) {
            throw new IllegalArgumentException("Invalid host spec (no host supplied): " + spec);
        }
        Map globalProperties = registry.getProperties();
        String namedLocation = (String)locationFlags.get(LocationInternal.NAMED_SPEC_NAME.getName());
        Map<String, Object> filteredProperties = new LocationPropertiesFromBrooklynProperties().getLocationProperties(null, namedLocation, globalProperties);
        ConfigBag flags = ConfigBag.newInstance(locationFlags).putIfAbsent(filteredProperties);
        flags.remove(LocationInternal.NAMED_SPEC_NAME);
        String target = "byon(" + KeyValueParser.toLine((Map)argsMap) + ")";
        Maybe testResolve = this.managementContext.getLocationRegistry().getLocationSpec(target);
        if (!testResolve.isPresent()) {
            throw new IllegalArgumentException("Invalid target location '" + target + "' for location '" + HOST + "': " + Exceptions.collapseText((Throwable)Maybe.getException((Maybe)testResolve)), Maybe.getException((Maybe)testResolve));
        }
        return (LocationSpec)((LocationSpec)((LocationSpec)LocationSpec.create(SingleMachineProvisioningLocation.class).configure((CharSequence)"location", (Object)target)).configure((CharSequence)"locationFlags", flags.getAllConfig())).configure(LocationConfigUtils.finalAndOriginalSpecs(spec, locationFlags, globalProperties, namedLocation));
    }

    public String getPrefix() {
        return HOST;
    }

    @Override
    protected Class<? extends Location> getLocationType() {
        return SingleMachineProvisioningLocation.class;
    }

    @Override
    protected AbstractLocationResolver.SpecParser getSpecParser() {
        return new AbstractLocationResolver.SpecParser(this.getPrefix()).setExampleUsage("\"host(1.1.1.1)\" or \"host(host=1.1.1.1,name=myname)\"");
    }
}

