/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.http.parser.image;

import org.jclouds.profitbricks.domain.Image;
import org.jclouds.profitbricks.domain.Location;
import org.jclouds.profitbricks.domain.OsType;
import org.jclouds.profitbricks.http.parser.BaseProfitBricksResponseHandler;

public abstract class BaseImageResponseHandler<T>
extends BaseProfitBricksResponseHandler<T> {
    protected Image.Builder builder = Image.builder();

    BaseImageResponseHandler() {
    }

    @Override
    protected void setPropertyOnEndTag(String qName) {
        if ("imageId".equals(qName)) {
            this.builder.id(this.textToStringValue());
        } else if ("imageName".equals(qName)) {
            this.builder.name(this.textToStringValue());
        } else if ("imageSize".equals(qName)) {
            this.builder.size(this.textToFloatValue().floatValue());
        } else if ("imageType".equals(qName)) {
            this.builder.type(Image.Type.fromValue(this.textToStringValue()));
        } else if ("location".equals(qName)) {
            this.builder.location(Location.fromId(this.textToStringValue()));
        } else if ("osType".equals(qName)) {
            this.builder.osType(OsType.fromValue(this.textToStringValue()));
        } else if ("public".equals(qName)) {
            this.builder.isPublic(this.textToBooleanValue());
        } else if ("writeable".equals(qName)) {
            this.builder.isWriteable(this.textToBooleanValue());
        } else if ("bootable".equals(qName)) {
            this.builder.isBootable(this.textToBooleanValue());
        } else if ("cpuHotPlug".equals(qName)) {
            this.builder.isCpuHotPlug(this.textToBooleanValue());
        } else if ("cpuHotUnPlug".equals(qName)) {
            this.builder.isCpuHotUnPlug(this.textToBooleanValue());
        } else if ("ramHotPlug".equals(qName)) {
            this.builder.isRamHotPlug(this.textToBooleanValue());
        } else if ("ramHotUnPlug".equals(qName)) {
            this.builder.isRamHotUnPlug(this.textToBooleanValue());
        } else if ("nicHotPlug".equals(qName)) {
            this.builder.isNicHotPlug(this.textToBooleanValue());
        } else if ("nicHotUnPlug".equals(qName)) {
            this.builder.isNicHotUnPlug(this.textToBooleanValue());
        } else if ("discVirtioHotPlug".equals(qName)) {
            this.builder.isDiscVirtioHotPlug(this.textToBooleanValue());
        } else if ("discVirtioHotUnPlug".equals(qName)) {
            this.builder.isDiscVirtioHotUnPlug(this.textToBooleanValue());
        }
    }
}

