/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.tools;

import com.google.common.util.concurrent.RateLimiter;
import com.twitter.finagle.builder.ClientBuilder;
import com.twitter.finagle.thrift.ClientId$;
import com.twitter.util.Await;
import com.twitter.util.Awaitable;
import com.twitter.util.Duration;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.client.monitor.MonitorServiceClient;
import org.apache.distributedlog.client.serverset.DLZkServerSet;
import org.apache.distributedlog.service.ClientUtils;
import org.apache.distributedlog.service.DLSocketAddress;
import org.apache.distributedlog.service.DistributedLogClient;
import org.apache.distributedlog.service.DistributedLogClientBuilder;
import org.apache.distributedlog.tools.Tool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyTool
extends Tool {
    private static final Logger logger = LoggerFactory.getLogger(ProxyTool.class);

    public ProxyTool() {
        this.addCommand((Tool.Command)new ReleaseCommand());
        this.addCommand((Tool.Command)new TruncateCommand());
        this.addCommand((Tool.Command)new AcceptNewStreamCommand());
    }

    protected String getName() {
        return "proxy_tool";
    }

    static class AcceptNewStreamCommand
    extends ProxyCommand {
        boolean enabled = false;

        AcceptNewStreamCommand() {
            super("accept-new-stream", "Enable/Disable accepting new streams for one proxy");
            this.options.addOption("e", "enabled", true, "Enable/Disable accepting new streams");
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            super.parseCommandLine(cmdline);
            if (!cmdline.hasOption("e")) {
                throw new ParseException("No action 'enable/disable' provided");
            }
            this.enabled = Boolean.parseBoolean(cmdline.getOptionValue("e"));
        }

        @Override
        protected int runCmd(Pair<DistributedLogClient, MonitorServiceClient> client) throws Exception {
            Await.result((Awaitable)((MonitorServiceClient)client.getRight()).setAcceptNewStream(this.enabled));
            return 0;
        }

        protected String getUsage() {
            return "accept-new-stream [options]";
        }
    }

    protected static abstract class ProxyCommand
    extends Tool.OptsCommand {
        protected Options options = new Options();
        protected InetSocketAddress address;

        protected ProxyCommand(String name, String description) {
            super(name, description);
            this.options.addOption("H", "host", true, "Single Proxy Address");
        }

        protected Options getOptions() {
            return this.options;
        }

        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            if (!cmdline.hasOption("H")) {
                throw new ParseException("No proxy address provided");
            }
            this.address = DLSocketAddress.parseSocketAddress((String)cmdline.getOptionValue("H"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int runCmd(CommandLine commandLine) throws Exception {
            try {
                this.parseCommandLine(commandLine);
            }
            catch (ParseException pe) {
                System.err.println("ERROR: failed to parse commandline : '" + pe.getMessage() + "'");
                this.printUsage();
                return -1;
            }
            DistributedLogClientBuilder clientBuilder = DistributedLogClientBuilder.newBuilder().name("proxy_tool").clientId(ClientId$.MODULE$.apply("proxy_tool")).maxRedirects(2).host((SocketAddress)this.address).clientBuilder(ClientBuilder.get().connectionTimeout(Duration.fromSeconds((int)2)).tcpConnectTimeout(Duration.fromSeconds((int)2)).requestTimeout(Duration.fromSeconds((int)10)).hostConnectionLimit(1).hostConnectionCoresize(1).keepAlive(true).failFast(false));
            Pair<DistributedLogClient, MonitorServiceClient> clientPair = ClientUtils.buildClient(clientBuilder);
            try {
                int n = this.runCmd(clientPair);
                return n;
            }
            finally {
                ((DistributedLogClient)clientPair.getLeft()).close();
            }
        }

        protected abstract int runCmd(Pair<DistributedLogClient, MonitorServiceClient> var1) throws Exception;
    }

    static class TruncateCommand
    extends ClusterCommand {
        DLSN dlsn = DLSN.InitialDLSN;

        TruncateCommand() {
            super("truncate", "Truncate streams until given dlsn.");
            this.options.addOption("d", "dlsn", true, "DLSN to truncate until");
        }

        @Override
        protected int runCmd(DistributedLogClient client) throws Exception {
            System.out.println("Truncating streams : " + this.streams);
            for (String stream : this.streams) {
                boolean success = (Boolean)Await.result((Awaitable)client.truncate(stream, this.dlsn));
                System.out.println("Truncate " + stream + " to " + this.dlsn + " : " + success);
            }
            return 0;
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            super.parseCommandLine(cmdline);
            if (!cmdline.hasOption("d")) {
                throw new ParseException("No DLSN provided");
            }
            String[] dlsnStrs = cmdline.getOptionValue("d").split(",");
            if (dlsnStrs.length != 3) {
                throw new ParseException("Invalid DLSN : " + cmdline.getOptionValue("d"));
            }
            this.dlsn = new DLSN(Long.parseLong(dlsnStrs[0]), Long.parseLong(dlsnStrs[1]), Long.parseLong(dlsnStrs[2]));
        }

        protected String getUsage() {
            return "truncate [options]";
        }
    }

    static class ReleaseCommand
    extends ClusterCommand {
        double rate = 100.0;

        ReleaseCommand() {
            super("release", "Release Stream Ownerships");
            this.options.addOption("t", "rate", true, "Rate to release streams");
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            super.parseCommandLine(cmdline);
            if (cmdline.hasOption("t")) {
                this.rate = Double.parseDouble(cmdline.getOptionValue("t", "100"));
            }
        }

        @Override
        protected int runCmd(DistributedLogClient client) throws Exception {
            RateLimiter rateLimiter = RateLimiter.create((double)this.rate);
            for (String stream : this.streams) {
                rateLimiter.acquire();
                try {
                    Await.result((Awaitable)client.release(stream));
                    System.out.println("Release ownership of stream " + stream);
                }
                catch (Exception e) {
                    System.err.println("Failed to release ownership of stream " + stream);
                    throw e;
                }
            }
            return 0;
        }

        protected String getUsage() {
            return "release [options]";
        }
    }

    protected static abstract class ClusterCommand
    extends Tool.OptsCommand {
        protected Options options = new Options();
        protected URI uri;
        protected final List<String> streams = new ArrayList<String>();

        protected ClusterCommand(String name, String description) {
            super(name, description);
            this.options.addOption("u", "uri", true, "DistributedLog URI");
            this.options.addOption("r", "prefix", true, "Prefix of stream name. E.g. 'QuantumLeapTest-'.");
            this.options.addOption("e", "expression", true, "Expression to generate stream suffix. Currently we support range '0-9', list '1,2,3' and name '143'");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int runCmd(CommandLine commandLine) throws Exception {
            try {
                this.parseCommandLine(commandLine);
            }
            catch (ParseException pe) {
                System.err.println("ERROR: failed to parse commandline : '" + pe.getMessage() + "'");
                this.printUsage();
                return -1;
            }
            logger.info("Created serverset for {}", (Object)this.uri);
            try (DLZkServerSet serverSet = DLZkServerSet.of((URI)this.uri, (int)60000);){
                int n;
                DistributedLogClient client = DistributedLogClientBuilder.newBuilder().name("proxy_tool").clientId(ClientId$.MODULE$.apply("proxy_tool")).maxRedirects(2).serverSet(serverSet.getServerSet()).clientBuilder(ClientBuilder.get().connectionTimeout(Duration.fromSeconds((int)2)).tcpConnectTimeout(Duration.fromSeconds((int)2)).requestTimeout(Duration.fromSeconds((int)10)).hostConnectionLimit(1).hostConnectionCoresize(1).keepAlive(true).failFast(false)).build();
                try {
                    n = this.runCmd(client);
                }
                catch (Throwable throwable) {
                    client.close();
                    throw throwable;
                }
                client.close();
                return n;
            }
        }

        protected abstract int runCmd(DistributedLogClient var1) throws Exception;

        protected Options getOptions() {
            return this.options;
        }

        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            if (!cmdline.hasOption("u")) {
                throw new ParseException("No distributedlog uri provided.");
            }
            this.uri = URI.create(cmdline.getOptionValue("u"));
            String streamPrefix = cmdline.hasOption("r") ? cmdline.getOptionValue("r") : "";
            String streamExpression = null;
            if (cmdline.hasOption("e")) {
                streamExpression = cmdline.getOptionValue("e");
            }
            if (null == streamPrefix || null == streamExpression) {
                throw new ParseException("Please specify stream prefix & expression.");
            }
            if (streamExpression.contains("-")) {
                String[] parts = streamExpression.split("-");
                if (parts.length != 2) {
                    throw new ParseException("Invalid stream index range : " + streamExpression);
                }
                try {
                    int start = Integer.parseInt(parts[0]);
                    int end = Integer.parseInt(parts[1]);
                    if (start > end) {
                        throw new ParseException("Invalid stream index range : " + streamExpression);
                    }
                    for (int i = start; i <= end; ++i) {
                        this.streams.add(streamPrefix + i);
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("Invalid stream index range : " + streamExpression);
                }
            } else if (streamExpression.contains(",")) {
                String[] parts = streamExpression.split(",");
                try {
                    for (String part : parts) {
                        this.streams.add(streamPrefix + part);
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("Invalid stream suffix list : " + streamExpression);
                }
            } else {
                this.streams.add(streamPrefix + streamExpression);
            }
        }
    }
}

