/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.util;

import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.openjdk.tools.javac.api.DiagnosticFormatter;
import org.openjdk.tools.javac.code.Lint;
import org.openjdk.tools.javac.tree.EndPosTable;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.BasicDiagnosticFormatter;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.DiagnosticSource;
import org.openjdk.tools.javac.util.JavacMessages;
import org.openjdk.tools.javac.util.List;
import org.openjdk.tools.javac.util.Options;

public class JCDiagnostic
implements Diagnostic<JavaFileObject> {
    private final DiagnosticSource source;
    private final DiagnosticPosition position;
    private final DiagnosticInfo diagnosticInfo;
    private final Set<DiagnosticFlag> flags;
    private final Lint.LintCategory lintCategory;
    private SourcePosition sourcePosition;
    private DiagnosticFormatter<JCDiagnostic> defaultFormatter;
    @Deprecated
    private static DiagnosticFormatter<JCDiagnostic> fragmentFormatter;

    @Deprecated
    public static JCDiagnostic fragment(String key, Object ... args) {
        return new JCDiagnostic(JCDiagnostic.getFragmentFormatter(), DiagnosticInfo.of(DiagnosticType.FRAGMENT, "compiler", key, args), null, EnumSet.noneOf(DiagnosticFlag.class), null, null);
    }

    @Deprecated
    public static DiagnosticFormatter<JCDiagnostic> getFragmentFormatter() {
        if (fragmentFormatter == null) {
            fragmentFormatter = new BasicDiagnosticFormatter(JavacMessages.getDefaultMessages());
        }
        return fragmentFormatter;
    }

    protected JCDiagnostic(DiagnosticFormatter<JCDiagnostic> formatter, DiagnosticInfo diagnosticInfo, Lint.LintCategory lc, Set<DiagnosticFlag> flags, DiagnosticSource source, DiagnosticPosition pos) {
        if (source == null && pos != null && pos.getPreferredPosition() != -1) {
            throw new IllegalArgumentException();
        }
        this.defaultFormatter = formatter;
        this.diagnosticInfo = diagnosticInfo;
        this.lintCategory = lc;
        this.flags = flags;
        this.source = source;
        this.position = pos;
    }

    public DiagnosticType getType() {
        return this.diagnosticInfo.type;
    }

    public List<JCDiagnostic> getSubdiagnostics() {
        return List.nil();
    }

    public boolean isMultiline() {
        return false;
    }

    public boolean isMandatory() {
        return this.flags.contains((Object)DiagnosticFlag.MANDATORY);
    }

    public boolean hasLintCategory() {
        return this.lintCategory != null;
    }

    public Lint.LintCategory getLintCategory() {
        return this.lintCategory;
    }

    @Override
    public JavaFileObject getSource() {
        if (this.source == null) {
            return null;
        }
        return this.source.getFile();
    }

    public DiagnosticSource getDiagnosticSource() {
        return this.source;
    }

    protected int getIntStartPosition() {
        return this.position == null ? -1 : this.position.getStartPosition();
    }

    protected int getIntPosition() {
        return this.position == null ? -1 : this.position.getPreferredPosition();
    }

    protected int getIntEndPosition() {
        return this.position == null ? -1 : this.position.getEndPosition(this.source.getEndPosTable());
    }

    @Override
    public long getStartPosition() {
        return this.getIntStartPosition();
    }

    @Override
    public long getPosition() {
        return this.getIntPosition();
    }

    @Override
    public long getEndPosition() {
        return this.getIntEndPosition();
    }

    public DiagnosticPosition getDiagnosticPosition() {
        return this.position;
    }

    @Override
    public long getLineNumber() {
        if (this.sourcePosition == null) {
            this.sourcePosition = new SourcePosition();
        }
        return this.sourcePosition.getLineNumber();
    }

    @Override
    public long getColumnNumber() {
        if (this.sourcePosition == null) {
            this.sourcePosition = new SourcePosition();
        }
        return this.sourcePosition.getColumnNumber();
    }

    public Object[] getArgs() {
        return this.diagnosticInfo.args;
    }

    public String getPrefix() {
        return this.getPrefix(this.diagnosticInfo.type);
    }

    public String getPrefix(DiagnosticType dt) {
        return this.defaultFormatter.formatKind(this, Locale.getDefault());
    }

    public String toString() {
        return this.defaultFormatter.format(this, Locale.getDefault());
    }

    @Override
    public Diagnostic.Kind getKind() {
        switch (this.diagnosticInfo.type) {
            case NOTE: {
                return Diagnostic.Kind.NOTE;
            }
            case WARNING: {
                return this.flags.contains((Object)DiagnosticFlag.MANDATORY) ? Diagnostic.Kind.MANDATORY_WARNING : Diagnostic.Kind.WARNING;
            }
            case ERROR: {
                return Diagnostic.Kind.ERROR;
            }
        }
        return Diagnostic.Kind.OTHER;
    }

    @Override
    public String getCode() {
        return this.diagnosticInfo.key();
    }

    @Override
    public String getMessage(Locale locale) {
        return this.defaultFormatter.formatMessage(this, locale);
    }

    public void setFlag(DiagnosticFlag flag) {
        this.flags.add(flag);
        if (this.diagnosticInfo.type == DiagnosticType.ERROR) {
            switch (flag) {
                case SYNTAX: {
                    this.flags.remove((Object)DiagnosticFlag.RECOVERABLE);
                    break;
                }
                case RESOLVE_ERROR: {
                    this.flags.add(DiagnosticFlag.RECOVERABLE);
                }
            }
        }
    }

    public boolean isFlagSet(DiagnosticFlag flag) {
        return this.flags.contains((Object)flag);
    }

    public static class MultilineDiagnostic
    extends JCDiagnostic {
        private final List<JCDiagnostic> subdiagnostics;

        public MultilineDiagnostic(JCDiagnostic other, List<JCDiagnostic> subdiagnostics) {
            super(other.defaultFormatter, other.diagnosticInfo, other.getLintCategory(), other.flags, other.getDiagnosticSource(), other.position);
            this.subdiagnostics = subdiagnostics;
        }

        @Override
        public List<JCDiagnostic> getSubdiagnostics() {
            return this.subdiagnostics;
        }

        @Override
        public boolean isMultiline() {
            return true;
        }
    }

    public static final class Fragment
    extends DiagnosticInfo {
        public Fragment(String prefix, String key, Object ... args) {
            super(DiagnosticType.FRAGMENT, prefix, key, args);
        }
    }

    public static final class Note
    extends DiagnosticInfo {
        public Note(String prefix, String key, Object ... args) {
            super(DiagnosticType.NOTE, prefix, key, args);
        }
    }

    public static final class Warning
    extends DiagnosticInfo {
        public Warning(String prefix, String key, Object ... args) {
            super(DiagnosticType.WARNING, prefix, key, args);
        }
    }

    public static final class Error
    extends DiagnosticInfo {
        public Error(String prefix, String key, Object ... args) {
            super(DiagnosticType.ERROR, prefix, key, args);
        }
    }

    public static abstract class DiagnosticInfo {
        DiagnosticType type;
        String prefix;
        String code;
        Object[] args;

        private DiagnosticInfo(DiagnosticType type, String prefix, String code, Object ... args) {
            this.type = type;
            this.prefix = prefix;
            this.code = code;
            this.args = args;
        }

        public String key() {
            return this.prefix + "." + this.type.key + "." + this.code;
        }

        public static DiagnosticInfo of(DiagnosticType type, String prefix, String code, Object ... args) {
            switch (type) {
                case ERROR: {
                    return new Error(prefix, code, args);
                }
                case WARNING: {
                    return new Warning(prefix, code, args);
                }
                case NOTE: {
                    return new Note(prefix, code, args);
                }
                case FRAGMENT: {
                    return new Fragment(prefix, code, args);
                }
            }
            Assert.error("Wrong diagnostic type: " + (Object)((Object)type));
            return null;
        }
    }

    class SourcePosition {
        private final int line;
        private final int column;

        SourcePosition() {
            int n;
            int n2 = n = JCDiagnostic.this.position == null ? -1 : JCDiagnostic.this.position.getPreferredPosition();
            if (n == -1 || JCDiagnostic.this.source == null) {
                this.column = -1;
                this.line = -1;
            } else {
                this.line = JCDiagnostic.this.source.getLineNumber(n);
                this.column = JCDiagnostic.this.source.getColumnNumber(n, true);
            }
        }

        public int getLineNumber() {
            return this.line;
        }

        public int getColumnNumber() {
            return this.column;
        }
    }

    public static enum DiagnosticFlag {
        MANDATORY,
        RESOLVE_ERROR,
        SYNTAX,
        RECOVERABLE,
        NON_DEFERRABLE,
        COMPRESSED,
        MULTIPLE;

    }

    public static class SimpleDiagnosticPosition
    implements DiagnosticPosition {
        private final int pos;

        public SimpleDiagnosticPosition(int pos) {
            this.pos = pos;
        }

        @Override
        public JCTree getTree() {
            return null;
        }

        @Override
        public int getStartPosition() {
            return this.pos;
        }

        @Override
        public int getPreferredPosition() {
            return this.pos;
        }

        @Override
        public int getEndPosition(EndPosTable endPosTable) {
            return this.pos;
        }
    }

    public static interface DiagnosticPosition {
        public JCTree getTree();

        public int getStartPosition();

        public int getPreferredPosition();

        public int getEndPosition(EndPosTable var1);
    }

    public static enum DiagnosticType {
        FRAGMENT("misc"),
        NOTE("note"),
        WARNING("warn"),
        ERROR("err");

        final String key;

        private DiagnosticType(String key) {
            this.key = key;
        }
    }

    public static class Factory {
        protected static final Context.Key<Factory> diagnosticFactoryKey = new Context.Key();
        DiagnosticFormatter<JCDiagnostic> formatter;
        final String prefix;
        final Set<DiagnosticFlag> defaultErrorFlags;

        public static Factory instance(Context context) {
            Factory instance = context.get(diagnosticFactoryKey);
            if (instance == null) {
                instance = new Factory(context);
            }
            return instance;
        }

        protected Factory(Context context) {
            this(JavacMessages.instance(context), "compiler");
            context.put(diagnosticFactoryKey, this);
            final Options options = Options.instance(context);
            this.initOptions(options);
            options.addListener(new Runnable(){

                @Override
                public void run() {
                    this.initOptions(options);
                }
            });
        }

        private void initOptions(Options options) {
            if (options.isSet("onlySyntaxErrorsUnrecoverable")) {
                this.defaultErrorFlags.add(DiagnosticFlag.RECOVERABLE);
            }
        }

        public Factory(JavacMessages messages, String prefix) {
            this.prefix = prefix;
            this.formatter = new BasicDiagnosticFormatter(messages);
            this.defaultErrorFlags = EnumSet.of(DiagnosticFlag.MANDATORY);
        }

        public JCDiagnostic error(DiagnosticFlag flag, DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return this.error(flag, source, pos, this.errorKey(key, args));
        }

        public JCDiagnostic error(DiagnosticFlag flag, DiagnosticSource source, DiagnosticPosition pos, Error errorKey) {
            JCDiagnostic diag = this.create(null, EnumSet.copyOf(this.defaultErrorFlags), source, pos, errorKey);
            if (flag != null) {
                diag.setFlag(flag);
            }
            return diag;
        }

        public JCDiagnostic mandatoryWarning(Lint.LintCategory lc, DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return this.mandatoryWarning(lc, source, pos, this.warningKey(key, args));
        }

        public JCDiagnostic mandatoryWarning(Lint.LintCategory lc, DiagnosticSource source, DiagnosticPosition pos, Warning warningKey) {
            return this.create(lc, EnumSet.of(DiagnosticFlag.MANDATORY), source, pos, warningKey);
        }

        public JCDiagnostic warning(Lint.LintCategory lc, DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return this.warning(lc, source, pos, this.warningKey(key, args));
        }

        public JCDiagnostic warning(Lint.LintCategory lc, DiagnosticSource source, DiagnosticPosition pos, Warning warningKey) {
            return this.create(lc, EnumSet.noneOf(DiagnosticFlag.class), source, pos, warningKey);
        }

        public JCDiagnostic mandatoryNote(DiagnosticSource source, String key, Object ... args) {
            return this.mandatoryNote(source, this.noteKey(key, args));
        }

        public JCDiagnostic mandatoryNote(DiagnosticSource source, Note noteKey) {
            return this.create(null, EnumSet.of(DiagnosticFlag.MANDATORY), source, null, noteKey);
        }

        public JCDiagnostic note(DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return this.note(source, pos, this.noteKey(key, args));
        }

        public JCDiagnostic note(DiagnosticSource source, DiagnosticPosition pos, Note noteKey) {
            return this.create(null, EnumSet.noneOf(DiagnosticFlag.class), source, pos, noteKey);
        }

        public JCDiagnostic fragment(String key, Object ... args) {
            return this.fragment(this.fragmentKey(key, args));
        }

        public JCDiagnostic fragment(Fragment fragmentKey) {
            return this.create(null, EnumSet.noneOf(DiagnosticFlag.class), null, null, fragmentKey);
        }

        public JCDiagnostic create(DiagnosticType kind, DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return this.create(null, EnumSet.noneOf(DiagnosticFlag.class), source, pos, DiagnosticInfo.of(kind, this.prefix, key, args));
        }

        public JCDiagnostic create(DiagnosticSource source, DiagnosticPosition pos, DiagnosticInfo diagnosticInfo) {
            return this.create(null, EnumSet.noneOf(DiagnosticFlag.class), source, pos, diagnosticInfo);
        }

        public JCDiagnostic create(DiagnosticType kind, Lint.LintCategory lc, Set<DiagnosticFlag> flags, DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return this.create(lc, flags, source, pos, DiagnosticInfo.of(kind, this.prefix, key, args));
        }

        public JCDiagnostic create(Lint.LintCategory lc, Set<DiagnosticFlag> flags, DiagnosticSource source, DiagnosticPosition pos, DiagnosticInfo diagnosticInfo) {
            return new JCDiagnostic(this.formatter, this.normalize(diagnosticInfo), lc, flags, source, pos);
        }

        DiagnosticInfo normalize(DiagnosticInfo diagnosticInfo) {
            return DiagnosticInfo.of(diagnosticInfo.type, diagnosticInfo.prefix, diagnosticInfo.code, Stream.of(diagnosticInfo.args).map(o -> o instanceof Fragment ? this.fragment((Fragment)o) : o).toArray());
        }

        Error errorKey(String code, Object ... args) {
            return (Error)DiagnosticInfo.of(DiagnosticType.ERROR, this.prefix, code, args);
        }

        Warning warningKey(String code, Object ... args) {
            return (Warning)DiagnosticInfo.of(DiagnosticType.WARNING, this.prefix, code, args);
        }

        Note noteKey(String code, Object ... args) {
            return (Note)DiagnosticInfo.of(DiagnosticType.NOTE, this.prefix, code, args);
        }

        Fragment fragmentKey(String code, Object ... args) {
            return (Fragment)DiagnosticInfo.of(DiagnosticType.FRAGMENT, this.prefix, code, args);
        }
    }
}

