/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.stream;

import com.twitter.finagle.util.HashedWheelTimer;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.distributedlog.service.FatalErrorHandler;
import org.apache.distributedlog.service.config.ServerConfiguration;
import org.apache.distributedlog.service.config.StreamConfigProvider;
import org.apache.distributedlog.service.stream.Stream;
import org.apache.distributedlog.service.stream.StreamFactory;
import org.apache.distributedlog.service.stream.StreamImpl;
import org.apache.distributedlog.service.stream.StreamManager;
import org.apache.distributedlog.service.stream.StreamOpStats;
import org.apache.distributedlog.service.streamset.StreamPartitionConverter;
import org.apache.distributedlog.util.OrderedScheduler;
import org.jboss.netty.util.Timer;

public class StreamFactoryImpl
implements StreamFactory {
    private final String clientId;
    private final StreamOpStats streamOpStats;
    private final ServerConfiguration serverConfig;
    private final DistributedLogConfiguration dlConfig;
    private final FeatureProvider featureProvider;
    private final StreamConfigProvider streamConfigProvider;
    private final StreamPartitionConverter streamPartitionConverter;
    private final Namespace dlNamespace;
    private final OrderedScheduler scheduler;
    private final FatalErrorHandler fatalErrorHandler;
    private final org.jboss.netty.util.HashedWheelTimer requestTimer;
    private final com.twitter.util.Timer futureTimer;

    public StreamFactoryImpl(String clientId, StreamOpStats streamOpStats, ServerConfiguration serverConfig, DistributedLogConfiguration dlConfig, FeatureProvider featureProvider, StreamConfigProvider streamConfigProvider, StreamPartitionConverter streamPartitionConverter, Namespace dlNamespace, OrderedScheduler scheduler, FatalErrorHandler fatalErrorHandler, org.jboss.netty.util.HashedWheelTimer requestTimer) {
        this.clientId = clientId;
        this.streamOpStats = streamOpStats;
        this.serverConfig = serverConfig;
        this.dlConfig = dlConfig;
        this.featureProvider = featureProvider;
        this.streamConfigProvider = streamConfigProvider;
        this.streamPartitionConverter = streamPartitionConverter;
        this.dlNamespace = dlNamespace;
        this.scheduler = scheduler;
        this.fatalErrorHandler = fatalErrorHandler;
        this.requestTimer = requestTimer;
        this.futureTimer = new HashedWheelTimer((Timer)requestTimer);
    }

    @Override
    public Stream create(String name, DynamicDistributedLogConfiguration streamConf, StreamManager streamManager) {
        return new StreamImpl(name, this.streamPartitionConverter.convert(name), this.clientId, streamManager, this.streamOpStats, this.serverConfig, this.dlConfig, streamConf, this.featureProvider, this.streamConfigProvider, this.dlNamespace, this.scheduler, this.fatalErrorHandler, this.requestTimer, this.futureTimer);
    }
}

