/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.benchmark.stream;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.LogReader;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.benchmark.stream.AbstractReaderBenchmark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncReaderBenchmark
extends AbstractReaderBenchmark {
    private static final Logger logger = LoggerFactory.getLogger(SyncReaderBenchmark.class);

    @Override
    protected void benchmark(Namespace namespace, String streamName, StatsLogger statsLogger) {
        DistributedLogManager dlm = null;
        while (null == dlm) {
            try {
                dlm = namespace.openLog(streamName);
            }
            catch (IOException ioe) {
                logger.warn("Failed to create dlm for stream {} : ", (Object)streamName, (Object)ioe);
            }
            if (null != dlm) continue;
            try {
                TimeUnit.MILLISECONDS.sleep(this.conf.getZKSessionTimeoutMilliseconds());
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted from sleep while creating dlm for stream {} : ", (Object)streamName, (Object)e);
            }
        }
        OpStatsLogger openReaderStats = statsLogger.getOpStatsLogger("open_reader");
        OpStatsLogger nonBlockingReadStats = statsLogger.getOpStatsLogger("non_blocking_read");
        OpStatsLogger blockingReadStats = statsLogger.getOpStatsLogger("blocking_read");
        Counter nullReadCounter = statsLogger.getCounter("null_read");
        logger.info("Created dlm for stream {}.", (Object)streamName);
        LogReader reader = null;
        Long lastTxId = null;
        block21: while (null == reader) {
            if (null == lastTxId) {
                switch (this.readMode) {
                    case OLDEST: {
                        lastTxId = 0L;
                        break;
                    }
                    case LATEST: {
                        try {
                            lastTxId = dlm.getLastTxId();
                            break;
                        }
                        catch (IOException ioe) {
                            continue block21;
                        }
                    }
                    case REWIND: {
                        lastTxId = System.currentTimeMillis() - this.rewindMs;
                        break;
                    }
                    case POSITION: {
                        lastTxId = this.fromTxId;
                        break;
                    }
                    default: {
                        logger.warn("Unsupported mode {}", (Object)this.readMode);
                        this.printUsage();
                        System.exit(0);
                    }
                }
                logger.info("Reading from transaction id {}", (Object)lastTxId);
            }
            Stopwatch stopwatch = Stopwatch.createStarted();
            try {
                reader = dlm.getInputStream(lastTxId.longValue());
                long elapsedMs = stopwatch.elapsed(TimeUnit.MICROSECONDS);
                openReaderStats.registerSuccessfulEvent(elapsedMs, TimeUnit.MICROSECONDS);
                logger.info("It took {} ms to position the reader to transaction id {}", (Object)lastTxId);
            }
            catch (IOException ioe) {
                openReaderStats.registerFailedEvent(stopwatch.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
                logger.warn("Failed to create reader for stream {} reading from {}.", (Object)streamName, (Object)lastTxId);
            }
            if (null == reader) {
                try {
                    TimeUnit.MILLISECONDS.sleep(this.conf.getZKSessionTimeoutMilliseconds());
                }
                catch (InterruptedException e) {
                    logger.warn("Interrupted from sleep after reader was reassigned null for stream {} : ", (Object)streamName, (Object)e);
                }
                continue;
            }
            boolean nonBlocking = false;
            stopwatch = Stopwatch.createUnstarted();
            long numCatchupReads = 0L;
            long numCatchupBytes = 0L;
            Stopwatch catchupStopwatch = Stopwatch.createStarted();
            try {
                while (true) {
                    stopwatch.start();
                    LogRecordWithDLSN record = reader.readNext(nonBlocking);
                    if (null != record) {
                        long elapsedMicros = stopwatch.stop().elapsed(TimeUnit.MICROSECONDS);
                        if (nonBlocking) {
                            nonBlockingReadStats.registerSuccessfulEvent(elapsedMicros, TimeUnit.MICROSECONDS);
                        } else {
                            numCatchupBytes += (long)record.getPayload().length;
                            ++numCatchupReads;
                            blockingReadStats.registerSuccessfulEvent(elapsedMicros, TimeUnit.MICROSECONDS);
                        }
                        lastTxId = record.getTransactionId();
                    } else {
                        nullReadCounter.inc();
                    }
                    if (null == record && !nonBlocking) {
                        nonBlocking = true;
                        catchupStopwatch.stop();
                        logger.info("Catchup {} records (total {} bytes) in {} milliseconds", new Object[]{numCatchupReads, numCatchupBytes, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
                    }
                    stopwatch.reset();
                }
            }
            catch (IOException e) {
                logger.warn("Encountered reading record from stream {} : ", (Object)streamName, (Object)e);
                reader = null;
                try {
                    TimeUnit.MILLISECONDS.sleep(this.conf.getZKSessionTimeoutMilliseconds());
                }
                catch (InterruptedException e2) {
                    logger.warn("Interrupted from sleep while creating reader for stream {} : ", (Object)streamName, (Object)e2);
                }
            }
        }
    }
}

