/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.client.routing;

import com.twitter.finagle.NoBrokersAvailableException;
import com.twitter.finagle.stats.StatsReceiver;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.distributedlog.client.resolver.RegionResolver;
import org.apache.distributedlog.thrift.service.StatusCode;

public interface RoutingService {
    public void startService();

    public void stopService();

    public RoutingService registerListener(RoutingListener var1);

    public RoutingService unregisterListener(RoutingListener var1);

    public Set<SocketAddress> getHosts();

    public SocketAddress getHost(String var1, RoutingContext var2) throws NoBrokersAvailableException;

    public void removeHost(SocketAddress var1, Throwable var2);

    public static class RoutingContext {
        final RegionResolver regionResolver;
        final Map<SocketAddress, StatusCode> triedHosts;
        final Set<String> unavailableRegions;

        public static RoutingContext of(RegionResolver resolver) {
            return new RoutingContext(resolver);
        }

        private RoutingContext(RegionResolver regionResolver) {
            this.regionResolver = regionResolver;
            this.triedHosts = new HashMap<SocketAddress, StatusCode>();
            this.unavailableRegions = new HashSet<String>();
        }

        public synchronized String toString() {
            return "(tried hosts=" + this.triedHosts + ")";
        }

        public synchronized RoutingContext addTriedHost(SocketAddress socketAddress, StatusCode code) {
            this.triedHosts.put(socketAddress, code);
            if (StatusCode.REGION_UNAVAILABLE == code) {
                this.unavailableRegions.add(this.regionResolver.resolveRegion(socketAddress));
            }
            return this;
        }

        public synchronized boolean isTriedHost(SocketAddress address) {
            return this.triedHosts.containsKey(address);
        }

        public synchronized boolean hasUnavailableRegions() {
            return !this.unavailableRegions.isEmpty();
        }

        public synchronized boolean isUnavailableRegion(String region) {
            return this.unavailableRegions.contains(region);
        }
    }

    public static interface RoutingListener {
        public void onServerLeft(SocketAddress var1);

        public void onServerJoin(SocketAddress var1);
    }

    public static interface Builder {
        public Builder statsReceiver(StatsReceiver var1);

        public RoutingService build();
    }
}

