/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.collections;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class Iterables2 {
    private Iterables2() {
    }

    public static <T> Iterable<List<T>> zip(final Iterable<Iterable<T>> iterables, final T defaultValue) {
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return new ZippingIterator<Object>(iterables, defaultValue);
            }
        };
    }

    public static <T> Iterable<List<T>> zip(T defaultValue, Iterable<T> ... iterables) {
        return Iterables2.zip(Arrays.asList(iterables), defaultValue);
    }

    private static class ZippingIterator<T>
    implements Iterator<List<T>> {
        private final Iterable<Iterable<T>> iterables;
        private final T defaultValue;
        private List<Iterator<T>> iterators = null;
        private final LoadingCache<Iterator<T>, Boolean> overflowing = CacheBuilder.newBuilder().build(new CacheLoader<Iterator<T>, Boolean>(){

            public Boolean load(Iterator<T> iterator) {
                return false;
            }
        });

        ZippingIterator(Iterable<Iterable<T>> iterables, T defaultValue) {
            this.iterables = iterables;
            this.defaultValue = defaultValue;
        }

        private void init() {
            if (this.iterators == null) {
                this.iterators = ImmutableList.copyOf((Iterable)Iterables.transform(this.iterables, (Function)new Function<Iterable<T>, Iterator<T>>(){

                    public Iterator<T> apply(Iterable<T> it) {
                        return it.iterator();
                    }
                }));
            }
        }

        @Override
        public boolean hasNext() {
            this.init();
            for (Iterator<T> it : this.iterators) {
                if (!it.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<T> next() {
            this.init();
            ArrayList<T> data = new ArrayList<T>(this.iterators.size());
            for (Iterator<T> it : this.iterators) {
                if (it.hasNext()) {
                    data.add(it.next());
                    continue;
                }
                this.overflowing.asMap().put(it, true);
                data.add(this.defaultValue);
            }
            return data;
        }

        @Override
        public void remove() {
            this.init();
            for (Iterator<T> it : this.iterators) {
                if (((Boolean)this.overflowing.getUnchecked(it)).booleanValue()) continue;
                it.remove();
            }
        }

        public String toString() {
            return Lists.newArrayList(this.iterables).toString();
        }
    }
}

