/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle;

import com.twitter.finagle.Deadline;
import com.twitter.finagle.context.Contexts$;
import com.twitter.finagle.context.MarshalledContext;
import com.twitter.finagle.util.ByteArrays$;
import com.twitter.io.Buf;
import com.twitter.util.Duration;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import com.twitter.util.TimeLike;
import com.twitter.util.Try;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class Deadline$
extends MarshalledContext.Key<Deadline>
implements Serializable {
    public static final Deadline$ MODULE$;

    static {
        new Deadline$();
    }

    public Option<Deadline> current() {
        return Contexts$.MODULE$.broadcast().get(this);
    }

    public Deadline ofTimeout(Duration timeout2) {
        Time now = Time$.MODULE$.now();
        return new Deadline(now, (Time)now.$plus(timeout2));
    }

    public Deadline combined(Deadline d1, Deadline d2) {
        return new Deadline((Time)d1.timestamp().max((TimeLike)d2.timestamp()), (Time)d1.deadline().min((TimeLike)d2.deadline()));
    }

    @Override
    public Buf marshal(Deadline deadline) {
        byte[] bytes = new byte[16];
        ByteArrays$.MODULE$.put64be(bytes, 0, deadline.timestamp().inNanoseconds());
        ByteArrays$.MODULE$.put64be(bytes, 8, deadline.deadline().inNanoseconds());
        return Buf.ByteArray$.Owned$.MODULE$.apply(bytes);
    }

    @Override
    public Try<Deadline> tryUnmarshal(Buf body) {
        if (body.length() != 16) {
            return new Throw((Throwable)new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid body. Length ", " but required 16"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)body.length())}))));
        }
        byte[] bytes = Buf.ByteArray$.Owned$.MODULE$.extract(body);
        long timestamp = ByteArrays$.MODULE$.get64be(bytes, 0);
        long deadline = ByteArrays$.MODULE$.get64be(bytes, 8);
        return new Return((Object)new Deadline(Time$.MODULE$.fromNanoseconds(timestamp), Time$.MODULE$.fromNanoseconds(deadline)));
    }

    public Deadline apply(Time timestamp, Time deadline) {
        return new Deadline(timestamp, deadline);
    }

    public Option<Tuple2<Time, Time>> unapply(Deadline x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.timestamp(), (Object)x$0.deadline()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Deadline$() {
        super(Contexts$.MODULE$.broadcast(), "com.twitter.finagle.Deadline");
        MODULE$ = this;
    }
}

