/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base.event;

import java.util.LinkedList;
import java.util.List;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.transport.base.event.TransportError;
import org.apache.axis2.transport.base.event.TransportErrorListener;
import org.apache.axis2.transport.base.event.TransportErrorSource;

public class TransportErrorSourceSupport
implements TransportErrorSource {
    private final Object source;
    private final List<TransportErrorListener> listeners = new LinkedList<TransportErrorListener>();

    public TransportErrorSourceSupport(Object source) {
        this.source = source;
    }

    @Override
    public synchronized void addErrorListener(TransportErrorListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeErrorListener(TransportErrorListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void error(AxisService service, Throwable ex) {
        if (!this.listeners.isEmpty()) {
            TransportError error = new TransportError(this.source, service, ex);
            for (TransportErrorListener listener : this.listeners) {
                listener.error(error);
            }
        }
    }
}

