/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.axiom.soap.RolePlayer;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.handler.BaseMessageContext;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.databinding.JAXBBlockContext;
import org.apache.axis2.jaxws.message.factory.JAXBBlockFactory;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SoapMessageContext
extends BaseMessageContext
implements SOAPMessageContext {
    private static final Log log = LogFactory.getLog(SoapMessageContext.class);
    Message cachedMessage = null;
    SOAPMessage cachedSoapMessage = null;
    SOAPPart cachedSoapPart = null;
    SOAPEnvelope cachedSoapEnvelope = null;
    List<AttachmentPart> cachedAttachmentParts = new ArrayList<AttachmentPart>();

    public SoapMessageContext(MessageContext messageCtx) {
        super(messageCtx);
    }

    public Object[] getHeaders(QName qname, JAXBContext jaxbcontext, boolean allRoles) {
        List<Block> blockList;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting all Headers for Qname: " + qname));
        }
        if (qname == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invalid QName, QName cannot be null");
            }
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"soapMessageContextErr1"));
        }
        if (jaxbcontext == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invalid JAXBContext, JAXBContext cannot be null");
            }
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"soapMessageContextErr2"));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        String namespace = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        JAXBBlockFactory blockFactory = (JAXBBlockFactory)FactoryRegistry.getFactory(JAXBBlockFactory.class);
        Message m = this.messageCtx.getMessage();
        JAXBBlockContext jbc = new JAXBBlockContext(jaxbcontext);
        RolePlayer rolePlayer = null;
        if (!allRoles) {
            rolePlayer = this.getRolePlayer();
        }
        if (m.getNumHeaderBlocks() > 0 && (blockList = m.getHeaderBlocks(namespace, localPart, jbc, blockFactory, rolePlayer)) != null && blockList.size() > 0) {
            try {
                for (Block block : blockList) {
                    Object bo = block.getBusinessObject(false);
                    if (bo == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Extracted BO from Header Block");
                    }
                    list.add(bo);
                }
            }
            catch (XMLStreamException e) {
                throw ExceptionFactory.makeWebServiceException((Throwable)e);
            }
        }
        return list.toArray(new Object[0]);
    }

    public SOAPMessage getMessage() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getMessage - accessing message.");
        }
        this.put("jaxws.isMessageAccessed", (Object)true);
        Message msg = this.messageCtx.getMEPContext().getMessageObject();
        if (msg != this.cachedMessage) {
            this.cachedMessage = msg;
            this.cachedSoapMessage = msg.getAsSOAPMessage();
            this.cacheSOAPMessageInfo(this.cachedSoapMessage);
        }
        return this.cachedSoapMessage;
    }

    public void checkAndUpdate() {
        boolean match;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start:checkAndUpdate");
        }
        if (this.cachedSoapMessage != null && !(match = this.checkSOAPMessageInfo(this.cachedSoapMessage))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"checkAndUpdate detected a mismatch..");
            }
            this.setMessage(this.cachedSoapMessage);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End:checkAndUpdate");
        }
    }

    private void cacheSOAPMessageInfo(SOAPMessage sm) {
        block5: {
            this.cachedSoapPart = null;
            this.cachedSoapEnvelope = null;
            this.cachedAttachmentParts.clear();
            try {
                this.cachedSoapPart = sm.getSOAPPart();
                if (this.cachedSoapPart != null) {
                    this.cachedSoapEnvelope = this.cachedSoapPart.getEnvelope();
                }
                if (sm.countAttachments() > 0) {
                    Iterator it = sm.getAttachments();
                    while (it != null && it.hasNext()) {
                        AttachmentPart ap = (AttachmentPart)it.next();
                        this.cachedAttachmentParts.add(ap);
                    }
                }
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)"Ignoring ", t);
            }
        }
    }

    private boolean checkSOAPMessageInfo(SOAPMessage sm) {
        block18: {
            block17: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("checkSOAPMessageInfo with " + JavaUtils.getObjectIdentity((Object)sm)));
                }
                SOAPPart currentSoapPart = null;
                SOAPEnvelope currentSoapEnvelope = null;
                try {
                    currentSoapPart = sm.getSOAPPart();
                    if (currentSoapPart != null) {
                        currentSoapEnvelope = this.cachedSoapPart.getEnvelope();
                    }
                    if (this.cachedSoapPart != currentSoapPart) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"checkSOAPMessageInfo returns false due to: mismatched SOAPParts");
                        }
                        return false;
                    }
                    if (this.cachedSoapEnvelope != currentSoapEnvelope) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"checkSOAPMessageInfo returns false due to: mismatched SOAPEnvelopes");
                        }
                        return false;
                    }
                }
                catch (Throwable t) {
                    if (!log.isDebugEnabled()) break block17;
                    log.debug((Object)"checkSOAPMessageInfo returns false due to: ", t);
                }
            }
            try {
                int currentNumAttachmentParts = sm.countAttachments();
                if (currentNumAttachmentParts != this.cachedAttachmentParts.size()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("checkSOAPMessageInfo returns false due to: current number of AttachmentParts is " + currentNumAttachmentParts + " versus cached number is " + this.cachedAttachmentParts.size()));
                    }
                    return false;
                }
                if (currentNumAttachmentParts > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("checkSOAPMessageInfo detected " + currentNumAttachmentParts + "AttachmentParts"));
                    }
                    Iterator<AttachmentPart> cachedIT = this.cachedAttachmentParts.iterator();
                    Iterator currentIT = sm.getAttachments();
                    while (currentIT.hasNext() && cachedIT.hasNext()) {
                        AttachmentPart cachedAP;
                        AttachmentPart currentAP = (AttachmentPart)currentIT.next();
                        if (currentAP == (cachedAP = cachedIT.next())) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("checkSOAPMessageInfo returns false due to: current AttachmentParts is " + JavaUtils.getObjectIdentity((Object)currentAP) + " and cached is " + JavaUtils.getObjectIdentity((Object)cachedAP)));
                        }
                        return false;
                    }
                }
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block18;
                log.debug((Object)"checkSOAPMessageInfo returns false due to: ", t);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"checkSOAPMessageInfo returns true");
        }
        return true;
    }

    public Set<String> getRoles() {
        HashSet<String> roles = new HashSet<String>(3);
        roles.add("http://schemas.xmlsoap.org/soap/actor/next");
        roles.add("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver");
        roles.add("http://www.w3.org/2003/05/soap-envelope/role/next");
        return roles;
    }

    public void setMessage(SOAPMessage soapMessage) {
        block3: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("setMessage new=" + JavaUtils.getObjectIdentity((Object)soapMessage) + " existing=" + JavaUtils.getObjectIdentity((Object)this.cachedSoapMessage)));
            }
            try {
                Message msg = ((MessageFactory)FactoryRegistry.getFactory(MessageFactory.class)).createFrom(soapMessage);
                this.messageCtx.getMEPContext().setMessage(msg);
                this.cachedMessage = msg;
                this.cachedSoapMessage = soapMessage;
                this.cacheSOAPMessageInfo(this.cachedSoapMessage);
            }
            catch (XMLStreamException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("Ignoring exception " + e));
            }
        }
    }

    private RolePlayer getRolePlayer() {
        ArrayList<String> roles = new ArrayList<String>(this.getRoles());
        return new SMCRolePlayer(roles);
    }

    class SMCRolePlayer
    implements RolePlayer {
        private List roles;

        SMCRolePlayer(List roles) {
            this.roles = roles;
        }

        public List getRoles() {
            return this.roles;
        }

        public boolean isUltimateDestination() {
            return true;
        }
    }
}

