/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.Map;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.protocolrecords.NodePublishVolumeRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ValidateVolumeCapabilitiesRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.proto.CsiAdaptorProtos;
import org.apache.hadoop.yarn.proto.YarnProtos;

public class NodePublishVolumeRequestPBImpl
extends NodePublishVolumeRequest {
    private CsiAdaptorProtos.NodePublishVolumeRequest.Builder builder;

    public NodePublishVolumeRequestPBImpl() {
        this.builder = CsiAdaptorProtos.NodePublishVolumeRequest.newBuilder();
    }

    public NodePublishVolumeRequestPBImpl(CsiAdaptorProtos.NodePublishVolumeRequest request) {
        this.builder = request.toBuilder();
    }

    public CsiAdaptorProtos.NodePublishVolumeRequest getProto() {
        Preconditions.checkNotNull(this.builder);
        return this.builder.build();
    }

    @Override
    public void setVolumeId(String volumeId) {
        Preconditions.checkNotNull(this.builder);
        this.builder.setVolumeId(volumeId);
    }

    @Override
    public String getVolumeId() {
        Preconditions.checkNotNull(this.builder);
        return this.builder.getVolumeId();
    }

    @Override
    public void setReadonly(boolean readonly) {
        Preconditions.checkNotNull(this.builder);
        this.builder.setReadonly(readonly);
    }

    @Override
    public boolean getReadOnly() {
        Preconditions.checkNotNull(this.builder);
        return this.builder.getReadonly();
    }

    @Override
    public void setSecrets(Map<String, String> secrets) {
        if (secrets != null) {
            Preconditions.checkNotNull(this.builder);
            for (Map.Entry<String, String> entry : secrets.entrySet()) {
                YarnProtos.StringStringMapProto mapEntry = YarnProtos.StringStringMapProto.newBuilder().setKey(entry.getKey()).setValue(entry.getValue()).build();
                this.builder.addSecrets(mapEntry);
            }
        }
    }

    @Override
    public Map<String, String> getSecrets() {
        Preconditions.checkNotNull(this.builder);
        return this.builder.getSecretsCount() > 0 ? ProtoUtils.convertStringStringMapProtoListToMap(this.builder.getSecretsList()) : ImmutableMap.of();
    }

    @Override
    public String getTargetPath() {
        Preconditions.checkNotNull(this.builder);
        return this.builder.getTargetPath();
    }

    @Override
    public void setStagingPath(String stagingPath) {
        Preconditions.checkNotNull(this.builder);
        this.builder.setStagingTargetPath(stagingPath);
    }

    @Override
    public String getStagingPath() {
        Preconditions.checkNotNull(this.builder);
        return this.builder.getStagingTargetPath();
    }

    @Override
    public void setPublishContext(Map<String, String> publishContext) {
        if (publishContext != null) {
            Preconditions.checkNotNull(this.builder);
            for (Map.Entry<String, String> entry : publishContext.entrySet()) {
                YarnProtos.StringStringMapProto mapEntry = YarnProtos.StringStringMapProto.newBuilder().setKey(entry.getKey()).setValue(entry.getValue()).build();
                this.builder.addPublishContext(mapEntry);
            }
        }
    }

    @Override
    public Map<String, String> getPublishContext() {
        Preconditions.checkNotNull(this.builder);
        return this.builder.getPublishContextCount() > 0 ? ProtoUtils.convertStringStringMapProtoListToMap(this.builder.getPublishContextList()) : ImmutableMap.of();
    }

    @Override
    public void setTargetPath(String targetPath) {
        if (targetPath != null) {
            Preconditions.checkNotNull(this.builder);
            this.builder.setTargetPath(targetPath);
        }
    }

    @Override
    public void setVolumeCapability(ValidateVolumeCapabilitiesRequest.VolumeCapability capability) {
        if (capability != null) {
            CsiAdaptorProtos.VolumeCapability vc = CsiAdaptorProtos.VolumeCapability.newBuilder().setAccessMode(CsiAdaptorProtos.VolumeCapability.AccessMode.forNumber(capability.getAccessMode().ordinal())).setVolumeType(CsiAdaptorProtos.VolumeCapability.VolumeType.forNumber(capability.getVolumeType().ordinal())).addAllMountFlags(capability.getMountFlags()).build();
            this.builder.setVolumeCapability(vc);
        }
    }

    @Override
    public ValidateVolumeCapabilitiesRequest.VolumeCapability getVolumeCapability() {
        CsiAdaptorProtos.VolumeCapability cap0 = this.builder.getVolumeCapability();
        if (this.builder.hasVolumeCapability()) {
            return new ValidateVolumeCapabilitiesRequest.VolumeCapability(ValidateVolumeCapabilitiesRequest.AccessMode.valueOf(cap0.getAccessMode().name()), ValidateVolumeCapabilitiesRequest.VolumeType.valueOf(cap0.getVolumeType().name()), cap0.getMountFlagsList());
        }
        return null;
    }

    @Override
    public String toString() {
        return TextFormat.shortDebugString(this.getProto());
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((NodePublishVolumeRequestPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }
}

