/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

public interface NameValidator {
    public static final Result OK = new Result(null);
    public static final NameValidator NO_VALIDATION = new NameValidator(){};
    public static final NameValidator UTF_VALIDATOR = new NameValidator(){

        @Override
        public Result validate(String name) {
            if (name == null) {
                return new Result("Null name");
            }
            int length = name.length();
            if (length == 0) {
                return new Result("Empty name");
            }
            char first = name.charAt(0);
            if (!Character.isLetter(first) && first != '_') {
                return new Result("Illegal initial character: " + name);
            }
            for (int i = 1; i < length; ++i) {
                char c = name.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '_') continue;
                return new Result("Illegal character in: " + name);
            }
            return OK;
        }
    };
    public static final NameValidator STRICT_VALIDATOR = new NameValidator(){

        @Override
        public Result validate(String name) {
            if (name == null) {
                return new Result("Null name");
            }
            int length = name.length();
            if (length == 0) {
                return new Result("Empty name");
            }
            char first = name.charAt(0);
            if (!this.isLetter(first) && first != '_') {
                return new Result("Illegal initial character: " + name);
            }
            for (int i = 1; i < length; ++i) {
                char c = name.charAt(i);
                if (this.isLetter(c) || this.isDigit(c) || c == '_') continue;
                return new Result("Illegal character in: " + name);
            }
            return OK;
        }

        private boolean isLetter(char c) {
            return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
        }

        private boolean isDigit(char c) {
            return c >= '0' && c <= '9';
        }
    };

    default public Result validate(String name) {
        return OK;
    }

    public static class Result {
        private final String errors;

        public Result(String errors) {
            this.errors = errors;
        }

        public boolean isOK() {
            return this == OK;
        }

        public String getErrors() {
            return this.errors;
        }
    }
}

