/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.messaging;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.ReplicationException;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.asterix.replication.api.IReplicaTask;
import org.apache.asterix.replication.api.IReplicationWorker;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;

public class ComponentMaskTask
implements IReplicaTask {
    private final String file;

    public ComponentMaskTask(String file) {
        this.file = file;
    }

    @Override
    public void perform(INcApplicationContext appCtx, IReplicationWorker worker) {
        try {
            IIOManager ioManager = appCtx.getIoManager();
            FileReference maskPath = ComponentMaskTask.getComponentMaskPath(ioManager, this.file);
            ioManager.create(maskPath);
            ReplicationProtocol.sendAck(worker.getChannel(), worker.getReusableBuffer());
        }
        catch (IOException e) {
            throw new ReplicationException((Throwable)e);
        }
    }

    public static FileReference getComponentMaskPath(IIOManager ioManager, String componentFile) throws IOException {
        FileReference localPath = ioManager.resolve(componentFile);
        FileReference resourceDir = localPath.getParent();
        ioManager.makeDirectories(resourceDir);
        String componentSequence = ResourceReference.getComponentSequence((String)componentFile);
        return resourceDir.getChild(".mask_C_" + componentSequence);
    }

    @Override
    public ReplicationProtocol.ReplicationRequestType getMessageType() {
        return ReplicationProtocol.ReplicationRequestType.LSM_COMPONENT_MASK;
    }

    @Override
    public void serialize(OutputStream out) throws HyracksDataException {
        try {
            DataOutputStream dos = new DataOutputStream(out);
            dos.writeUTF(this.file);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static ComponentMaskTask create(DataInput input) throws IOException {
        String indexFile = input.readUTF();
        return new ComponentMaskTask(indexFile);
    }
}

