/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.io.DataOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.DependencyFullyQualifiedName;
import org.apache.asterix.common.metadata.MetadataUtil;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.metadata.MetadataNode;
import org.apache.asterix.metadata.bootstrap.FunctionEntity;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entitytupletranslators.AbstractDatatypeTupleTranslator;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.BuiltinTypeMap;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeSignature;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class FunctionTupleTranslator
extends AbstractDatatypeTupleTranslator<Function> {
    private final FunctionEntity functionEntity;
    protected OrderedListBuilder dependenciesListBuilder;
    protected OrderedListBuilder dependencyListBuilder;
    protected OrderedListBuilder dependencyNameListBuilder;
    protected List<String> dependencySubnames;
    protected AOrderedListType stringList;
    protected AOrderedListType listOfLists;

    protected FunctionTupleTranslator(TxnId txnId, MetadataNode metadataNode, boolean getTuple, FunctionEntity functionEntity) {
        super(txnId, metadataNode, getTuple, functionEntity.getIndex(), functionEntity.payloadPosition());
        this.functionEntity = functionEntity;
        if (getTuple) {
            this.dependenciesListBuilder = new OrderedListBuilder();
            this.dependencyListBuilder = new OrderedListBuilder();
            this.dependencyNameListBuilder = new OrderedListBuilder();
            this.dependencySubnames = new ArrayList<String>(4);
            this.stringList = new AOrderedListType((IAType)BuiltinType.ASTRING, null);
            this.listOfLists = new AOrderedListType((IAType)new AOrderedListType((IAType)BuiltinType.ASTRING, null), null);
        }
    }

    @Override
    protected Function createMetadataEntityFromARecord(ARecord functionRecord) throws AlgebricksException {
        String libraryName;
        String dataverseCanonicalName = ((AString)functionRecord.getValueByPos(this.functionEntity.dataverseNameIndex())).getStringValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
        int databaseNameIndex = this.functionEntity.databaseNameIndex();
        String databaseName = databaseNameIndex >= 0 ? ((AString)functionRecord.getValueByPos(databaseNameIndex)).getStringValue() : MetadataUtil.databaseFor((DataverseName)dataverseName);
        String functionName = ((AString)functionRecord.getValueByPos(this.functionEntity.functionNameIndex())).getStringValue();
        int arity = Integer.parseInt(((AString)functionRecord.getValueByPos(this.functionEntity.functionArityIndex())).getStringValue());
        IACursor paramNameCursor = ((AOrderedList)functionRecord.getValueByPos(this.functionEntity.functionParamListIndex())).getCursor();
        ArrayList<String> paramNames = new ArrayList<String>();
        while (paramNameCursor.next()) {
            paramNames.add(((AString)paramNameCursor.get()).getStringValue());
        }
        List<TypeSignature> paramTypes = this.getParamTypes(functionRecord, databaseName, dataverseName);
        String returnTypeName = ((AString)functionRecord.getValueByPos(this.functionEntity.functionReturnTypeIndex())).getStringValue();
        TypeSignature returnType = returnTypeName.isEmpty() ? null : this.getTypeSignature(functionRecord, returnTypeName, "ReturnTypeDatabaseName", "ReturnTypeDataverseName", databaseName, dataverseName);
        String definition = ((AString)functionRecord.getValueByPos(this.functionEntity.functionDefinitionIndex())).getStringValue();
        String language = ((AString)functionRecord.getValueByPos(this.functionEntity.functionLanguageIndex())).getStringValue();
        String functionKind = ((AString)functionRecord.getValueByPos(this.functionEntity.functionKindIndex())).getStringValue();
        Map<String, String> resources = null;
        String libraryDatabaseName = null;
        DataverseName libraryDataverseName = null;
        ArrayList<String> externalIdentifier = null;
        AOrderedList externalIdentifierList = this.getOrderedList(functionRecord, "ExternalIdentifier");
        if (externalIdentifierList != null) {
            externalIdentifier = new ArrayList<String>(externalIdentifierList.size());
            IACursor externalIdentifierCursor = externalIdentifierList.getCursor();
            while (externalIdentifierCursor.next()) {
                externalIdentifier.add(((AString)externalIdentifierCursor.get()).getStringValue());
            }
            libraryName = this.getString(functionRecord, "LibraryName");
            String libraryDataverseCanonicalName = this.getString(functionRecord, "LibraryDataverseName");
            libraryDataverseName = DataverseName.createFromCanonicalForm((String)libraryDataverseCanonicalName);
            libraryDatabaseName = this.getString(functionRecord, "LibraryDatabaseName");
            if (libraryDatabaseName == null) {
                libraryDatabaseName = MetadataUtil.databaseFor((DataverseName)libraryDataverseName);
            }
            resources = this.getResources(functionRecord, "Resources");
            definition = null;
        } else {
            libraryName = this.getString(functionRecord, "Library");
            if (libraryName != null) {
                libraryDatabaseName = databaseName;
                libraryDataverseName = dataverseName;
                externalIdentifier = FunctionTupleTranslator.decodeExternalIdentifierBackCompat(definition, ExternalFunctionLanguage.valueOf((String)language));
                resources = this.getResources(functionRecord, "WithParams");
            }
        }
        Boolean nullCall = null;
        Boolean deterministic = null;
        if (externalIdentifier != null) {
            nullCall = this.getBoolean(functionRecord, "NullCall");
            deterministic = this.getBoolean(functionRecord, "Deterministic");
        }
        IACursor dependenciesCursor = ((AOrderedList)functionRecord.getValueByPos(this.functionEntity.functionDependenciesIndex())).getCursor();
        ArrayList<List<DependencyFullyQualifiedName>> dependencies = new ArrayList<List<DependencyFullyQualifiedName>>();
        while (dependenciesCursor.next()) {
            ArrayList<DependencyFullyQualifiedName> dependencyList = new ArrayList<DependencyFullyQualifiedName>();
            IACursor qualifiedDependencyCursor = ((AOrderedList)dependenciesCursor.get()).getCursor();
            while (qualifiedDependencyCursor.next()) {
                DependencyFullyQualifiedName dependency = FunctionTupleTranslator.getDependency((AOrderedList)qualifiedDependencyCursor.get());
                dependencyList.add(dependency);
            }
            dependencies.add(dependencyList);
        }
        FunctionSignature signature = new FunctionSignature(databaseName, dataverseName, functionName, arity);
        return new Function(signature, paramNames, paramTypes, returnType, definition, functionKind, language, libraryDatabaseName, libraryDataverseName, libraryName, externalIdentifier, nullCall, deterministic, resources, dependencies);
    }

    private List<TypeSignature> getParamTypes(ARecord functionRecord, String functionDatabaseName, DataverseName functionDataverseName) throws AlgebricksException {
        ARecordType functionRecordType = functionRecord.getType();
        int paramTypesFieldIdx = functionRecordType.getFieldIndex("ParamTypes");
        if (paramTypesFieldIdx < 0) {
            return null;
        }
        AOrderedList paramTypeList = (AOrderedList)functionRecord.getValueByPos(paramTypesFieldIdx);
        ArrayList<TypeSignature> paramTypes = new ArrayList<TypeSignature>(paramTypeList.size());
        IACursor cursor = paramTypeList.getCursor();
        while (cursor.next()) {
            TypeSignature paramType;
            IAObject paramTypeObject = cursor.get();
            switch (paramTypeObject.getType().getTypeTag()) {
                case NULL: {
                    paramType = null;
                    break;
                }
                case OBJECT: {
                    ARecord paramTypeRecord = (ARecord)paramTypeObject;
                    String paramTypeName = this.getString(paramTypeRecord, "Type");
                    paramType = this.getTypeSignature(paramTypeRecord, paramTypeName, "DatabaseName", "DataverseName", functionDatabaseName, functionDataverseName);
                    break;
                }
                default: {
                    throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{paramTypeObject.getType().getTypeName()});
                }
            }
            paramTypes.add(paramType);
        }
        return paramTypes;
    }

    private TypeSignature getTypeSignature(ARecord record, String typeName, String dbFieldName, String dvFieldName, String functionDatabaseName, DataverseName functionDataverseName) throws AlgebricksException {
        String typeDatabaseName;
        DataverseName typeDataverseName;
        if (BuiltinType.ANY.getTypeName().equals(typeName)) {
            return null;
        }
        BuiltinType builtinType = BuiltinTypeMap.getBuiltinType((String)typeName);
        if (builtinType != null) {
            return new TypeSignature(builtinType);
        }
        String typeDataverseNameCanonical = this.getString(record, dvFieldName);
        if (typeDataverseNameCanonical == null) {
            typeDataverseName = functionDataverseName;
            typeDatabaseName = functionDatabaseName;
        } else {
            typeDataverseName = DataverseName.createFromCanonicalForm((String)typeDataverseNameCanonical);
            typeDatabaseName = this.getString(record, dbFieldName);
            if (typeDatabaseName == null) {
                typeDatabaseName = MetadataUtil.databaseFor((DataverseName)typeDataverseName);
            }
        }
        return new TypeSignature(typeDatabaseName, typeDataverseName, typeName);
    }

    private Map<String, String> getResources(ARecord functionRecord, String resourcesFieldName) {
        HashMap<String, String> adaptorConfiguration = null;
        ARecordType functionType = functionRecord.getType();
        int functionLibraryIdx = functionType.getFieldIndex(resourcesFieldName);
        if (functionLibraryIdx >= 0) {
            adaptorConfiguration = new HashMap<String, String>();
            IACursor cursor = ((AOrderedList)functionRecord.getValueByPos(functionLibraryIdx)).getCursor();
            while (cursor.next()) {
                ARecord field = (ARecord)cursor.get();
                ARecordType fieldType = field.getType();
                int keyIdx = fieldType.getFieldIndex("name");
                String key = keyIdx >= 0 ? ((AString)field.getValueByPos(keyIdx)).getStringValue() : "";
                int valueIdx = fieldType.getFieldIndex("value");
                String value = valueIdx >= 0 ? ((AString)field.getValueByPos(valueIdx)).getStringValue() : "";
                adaptorConfiguration.put(key, value);
            }
        }
        return adaptorConfiguration;
    }

    private String getString(ARecord aRecord, String fieldName) {
        ARecordType functionType = aRecord.getType();
        int fieldIndex = functionType.getFieldIndex(fieldName);
        return fieldIndex >= 0 ? ((AString)aRecord.getValueByPos(fieldIndex)).getStringValue() : null;
    }

    private Boolean getBoolean(ARecord aRecord, String fieldName) {
        ARecordType functionType = aRecord.getType();
        int fieldIndex = functionType.getFieldIndex(fieldName);
        return fieldIndex >= 0 ? ((ABoolean)aRecord.getValueByPos(fieldIndex)).getBoolean() : null;
    }

    private AOrderedList getOrderedList(ARecord aRecord, String fieldName) {
        ARecordType aRecordType = aRecord.getType();
        int fieldIndex = aRecordType.getFieldIndex(fieldName);
        return fieldIndex >= 0 ? (AOrderedList)aRecord.getValueByPos(fieldIndex) : null;
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(Function function) throws HyracksDataException {
        DataverseName dataverseName = function.getDataverseName();
        String dataverseCanonicalName = dataverseName.getCanonicalForm();
        this.tupleBuilder.reset();
        if (this.functionEntity.databaseNameIndex() >= 0) {
            this.aString.setValue(function.getDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
            this.tupleBuilder.addFieldEndOffset();
        }
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(function.getName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(String.valueOf(function.getArity()));
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(this.functionEntity.getRecordType());
        if (this.functionEntity.databaseNameIndex() >= 0) {
            this.fieldValue.reset();
            this.aString.setValue(function.getDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField(this.functionEntity.databaseNameIndex(), (IValueReference)this.fieldValue);
        }
        this.fieldValue.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.functionEntity.dataverseNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(function.getName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.functionEntity.functionNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(String.valueOf(function.getArity()));
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.functionEntity.functionArityIndex(), (IValueReference)this.fieldValue);
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        listBuilder.reset((AbstractCollectionType)((AOrderedListType)this.functionEntity.getRecordType().getFieldTypes()[this.functionEntity.functionParamListIndex()]));
        for (String p : function.getParameterNames()) {
            itemValue.reset();
            this.aString.setValue(p);
            this.stringSerde.serialize((Object)this.aString, itemValue.getDataOutput());
            listBuilder.addItem((IValueReference)itemValue);
        }
        this.fieldValue.reset();
        listBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField(this.functionEntity.functionParamListIndex(), (IValueReference)this.fieldValue);
        TypeSignature returnType = function.getReturnType();
        this.fieldValue.reset();
        this.aString.setValue(returnType != null ? returnType.getName() : "");
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.functionEntity.functionReturnTypeIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(function.isExternal() ? "" : function.getFunctionBody());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.functionEntity.functionDefinitionIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(function.getLanguage());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.functionEntity.functionLanguageIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(function.getKind());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.functionEntity.functionKindIndex(), (IValueReference)this.fieldValue);
        this.dependenciesListBuilder.reset((AbstractCollectionType)((AOrderedListType)this.functionEntity.getRecordType().getFieldTypes()[this.functionEntity.functionDependenciesIndex()]));
        List<List<DependencyFullyQualifiedName>> dependenciesList = function.getDependencies();
        boolean writeDatabase = this.functionEntity.databaseNameIndex() >= 0;
        for (List<DependencyFullyQualifiedName> dependencies : dependenciesList) {
            this.dependencyListBuilder.reset((AbstractCollectionType)this.listOfLists);
            FunctionTupleTranslator.writeDeps(this.dependencyListBuilder, itemValue, dependencies, this.dependencyNameListBuilder, this.stringList, writeDatabase, this.aString, (ISerializerDeserializer<AString>)this.stringSerde);
            itemValue.reset();
            this.dependencyListBuilder.write(itemValue.getDataOutput(), true);
            this.dependenciesListBuilder.addItem((IValueReference)itemValue);
        }
        this.fieldValue.reset();
        this.dependenciesListBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField(this.functionEntity.functionDependenciesIndex(), (IValueReference)this.fieldValue);
        this.writeOpenFields(function);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }

    protected void writeOpenFields(Function function) throws HyracksDataException {
        this.writeReturnTypeDataverseName(function);
        this.writeParameterTypes(function);
        this.writeResources(function);
        this.writeLibrary(function);
        this.writeNullCall(function);
        this.writeDeterministic(function);
    }

    protected void writeResources(Function function) throws HyracksDataException {
        Map<String, String> withParams = function.getResources();
        if (withParams == null || withParams.isEmpty()) {
            return;
        }
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        listBuilder.reset((AbstractCollectionType)DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE);
        for (Map.Entry<String, String> property : withParams.entrySet()) {
            itemValue.reset();
            this.writePropertyTypeRecord(property.getKey(), property.getValue(), itemValue.getDataOutput());
            listBuilder.addItem((IValueReference)itemValue);
        }
        this.fieldValue.reset();
        listBuilder.write(this.fieldValue.getDataOutput(), true);
        this.fieldName.reset();
        this.aString.setValue("Resources");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
    }

    protected void writeParameterTypes(Function function) throws HyracksDataException {
        List<TypeSignature> parameterTypes = function.getParameterTypes();
        if (parameterTypes == null) {
            return;
        }
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        listBuilder.reset((AbstractCollectionType)DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE);
        for (TypeSignature paramType : parameterTypes) {
            itemValue.reset();
            if (paramType == null) {
                this.nullSerde.serialize((Object)ANull.NULL, itemValue.getDataOutput());
            } else {
                this.writeTypeRecord(paramType.getDatabaseName(), paramType.getDataverseName(), paramType.getName(), function.getDatabaseName(), function.getDataverseName(), itemValue.getDataOutput());
            }
            listBuilder.addItem((IValueReference)itemValue);
        }
        this.fieldValue.reset();
        listBuilder.write(this.fieldValue.getDataOutput(), true);
        this.fieldName.reset();
        this.aString.setValue("ParamTypes");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
    }

    protected void writeLibrary(Function function) throws HyracksDataException {
        if (!function.isExternal()) {
            return;
        }
        if (this.functionEntity.databaseNameIndex() >= 0) {
            this.fieldName.reset();
            this.aString.setValue("LibraryDatabaseName");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.aString.setValue(function.getLibraryDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        }
        this.fieldName.reset();
        this.aString.setValue("LibraryDataverseName");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.aString.setValue(function.getLibraryDataverseName().getCanonicalForm());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        this.fieldName.reset();
        this.aString.setValue("LibraryName");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.aString.setValue(function.getLibraryName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        this.fieldName.reset();
        this.aString.setValue("ExternalIdentifier");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        listBuilder.reset((AbstractCollectionType)this.stringList);
        for (String externalIdPart : function.getExternalIdentifier()) {
            itemValue.reset();
            this.aString.setValue(externalIdPart);
            this.stringSerde.serialize((Object)this.aString, itemValue.getDataOutput());
            listBuilder.addItem((IValueReference)itemValue);
        }
        this.fieldValue.reset();
        listBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
    }

    protected void writeReturnTypeDataverseName(Function function) throws HyracksDataException {
        TypeSignature returnType = function.getReturnType();
        if (returnType == null) {
            return;
        }
        DataverseName returnTypeDataverseName = returnType.getDataverseName();
        String returnTypeDatabaseName = returnType.getDatabaseName();
        if (returnTypeDataverseName == null || returnTypeDatabaseName.equals(function.getDatabaseName()) && returnTypeDataverseName.equals((Object)function.getDataverseName())) {
            return;
        }
        if (this.functionEntity.databaseNameIndex() >= 0) {
            this.fieldName.reset();
            this.aString.setValue("ReturnTypeDatabaseName");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.aString.setValue(returnTypeDatabaseName);
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        }
        this.fieldName.reset();
        this.aString.setValue("ReturnTypeDataverseName");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.aString.setValue(returnTypeDataverseName.getCanonicalForm());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
    }

    protected void writeNullCall(Function function) throws HyracksDataException {
        if (function.getNullCall() == null) {
            return;
        }
        this.fieldName.reset();
        this.aString.setValue("NullCall");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.booleanSerde.serialize((Object)ABoolean.valueOf((boolean)function.getNullCall()), this.fieldValue.getDataOutput());
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
    }

    protected void writeDeterministic(Function function) throws HyracksDataException {
        if (function.getDeterministic() == null) {
            return;
        }
        this.fieldName.reset();
        this.aString.setValue("Deterministic");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.booleanSerde.serialize((Object)ABoolean.valueOf((boolean)function.getDeterministic()), this.fieldValue.getDataOutput());
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
    }

    public void writePropertyTypeRecord(String name, String value, DataOutput out) throws HyracksDataException {
        RecordBuilder propertyRecordBuilder = new RecordBuilder();
        propertyRecordBuilder.reset(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
        this.fieldName.reset();
        this.aString.setValue("Name");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.aString.setValue(name);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        propertyRecordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        this.fieldName.reset();
        this.aString.setValue("Value");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.aString.setValue(value);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        propertyRecordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        propertyRecordBuilder.write(out, true);
    }

    public void writeTypeRecord(String typeDatabaseName, DataverseName typeDataverseName, String typeName, String functionDatabaseName, DataverseName functionDataverseName, DataOutput out) throws HyracksDataException {
        boolean skipTypeDataverseName;
        RecordBuilder propertyRecordBuilder = new RecordBuilder();
        propertyRecordBuilder.reset(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
        this.fieldName.reset();
        this.aString.setValue("Type");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.aString.setValue(typeName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        propertyRecordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        boolean bl = skipTypeDataverseName = typeDataverseName == null || typeDatabaseName.equals(functionDatabaseName) && typeDataverseName.equals((Object)functionDataverseName);
        if (!skipTypeDataverseName) {
            if (this.functionEntity.databaseNameIndex() >= 0) {
                this.fieldName.reset();
                this.aString.setValue("DatabaseName");
                this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
                this.fieldValue.reset();
                this.aString.setValue(typeDatabaseName);
                this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
                propertyRecordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
            }
            this.fieldName.reset();
            this.aString.setValue("DataverseName");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.aString.setValue(typeDataverseName.getCanonicalForm());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            propertyRecordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        }
        propertyRecordBuilder.write(out, true);
    }

    private static List<String> decodeExternalIdentifierBackCompat(String encodedValue, ExternalFunctionLanguage language) throws AlgebricksException {
        switch (language) {
            case JAVA: {
                return Collections.singletonList(encodedValue);
            }
            case PYTHON: {
                int idx = encodedValue.lastIndexOf(58);
                if (idx < 0) {
                    throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{encodedValue});
                }
                return Arrays.asList(encodedValue.substring(0, idx), encodedValue.substring(idx + 1));
            }
        }
        throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{language});
    }
}

