/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataUtil;
import org.apache.asterix.metadata.bootstrap.FullTextFilterEntity;
import org.apache.asterix.metadata.entities.FullTextFilterMetadataEntity;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.fulltext.AbstractFullTextFilterDescriptor;
import org.apache.asterix.runtime.fulltext.StopwordsFullTextFilterDescriptor;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.FullTextFilterType;

public class FullTextFilterMetadataEntityTupleTranslator
extends AbstractTupleTranslator<FullTextFilterMetadataEntity> {
    private final FullTextFilterEntity fullTextFilterEntity;
    protected final ArrayTupleReference tuple;

    protected FullTextFilterMetadataEntityTupleTranslator(boolean getTuple, FullTextFilterEntity fullTextFilterEntity) {
        super(getTuple, fullTextFilterEntity.getIndex(), fullTextFilterEntity.payloadPosition());
        this.fullTextFilterEntity = fullTextFilterEntity;
        this.tuple = getTuple ? new ArrayTupleReference() : null;
    }

    @Override
    protected FullTextFilterMetadataEntity createMetadataEntityFromARecord(ARecord aRecord) throws AlgebricksException {
        AString dataverseName = (AString)aRecord.getValueByPos(this.fullTextFilterEntity.dataverseNameIndex());
        DataverseName dataverse = DataverseName.createFromCanonicalForm((String)dataverseName.getStringValue());
        int databaseNameIndex = this.fullTextFilterEntity.databaseNameIndex();
        String databaseName = databaseNameIndex >= 0 ? ((AString)aRecord.getValueByPos(databaseNameIndex)).getStringValue() : MetadataUtil.databaseFor((DataverseName)dataverse);
        AString filterName = (AString)aRecord.getValueByPos(this.fullTextFilterEntity.filterNameIndex());
        AString filterTypeAString = (AString)aRecord.getValueByPos(this.fullTextFilterEntity.filterTypeIndex());
        FullTextFilterType filterType = FullTextFilterType.getEnumIgnoreCase((String)filterTypeAString.getStringValue());
        switch (filterType) {
            case STOPWORDS: {
                return this.createStopwordsFilterDescriptorFromARecord(databaseName, dataverse, filterName, aRecord);
            }
        }
        throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{"Not supported yet"});
    }

    public FullTextFilterMetadataEntity createStopwordsFilterDescriptorFromARecord(String database, DataverseName dataverse, AString name, ARecord aRecord) {
        ImmutableList.Builder stopwordsBuilder = ImmutableList.builder();
        int fieldIndex = aRecord.getType().getFieldIndex("StopwordList");
        if (fieldIndex >= 0) {
            IACursor stopwordsCursor = ((AOrderedList)aRecord.getValueByPos(fieldIndex)).getCursor();
            while (stopwordsCursor.next()) {
                stopwordsBuilder.add((Object)((AString)stopwordsCursor.get()).getStringValue());
            }
        }
        StopwordsFullTextFilterDescriptor filterDescriptor = new StopwordsFullTextFilterDescriptor(database, dataverse, name.getStringValue(), stopwordsBuilder.build());
        return new FullTextFilterMetadataEntity((AbstractFullTextFilterDescriptor)filterDescriptor);
    }

    private void writeKeyAndValue2FieldVariables(String key, String value) throws HyracksDataException {
        this.fieldName.reset();
        this.aString.setValue(key);
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.aString.setValue(value);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
    }

    private void writeOrderedList2RecordBuilder(String strFieldName, List<String> list) throws HyracksDataException {
        this.fieldName.reset();
        this.aString.setValue(strFieldName);
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        listBuilder.reset((AbstractCollectionType)new AOrderedListType((IAType)BuiltinType.ASTRING, null));
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        for (String s : list) {
            itemValue.reset();
            this.aString.setValue(s);
            this.stringSerde.serialize((Object)this.aString, itemValue.getDataOutput());
            listBuilder.addItem((IValueReference)itemValue);
        }
        this.fieldValue.reset();
        listBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
    }

    private void writeStopwordFilterDescriptor(StopwordsFullTextFilterDescriptor stopwordsFullTextFilterDescriptor) throws HyracksDataException {
        this.writeOrderedList2RecordBuilder("StopwordList", stopwordsFullTextFilterDescriptor.getStopwordList());
    }

    private void writeFulltextFilter(AbstractFullTextFilterDescriptor filterDescriptor) throws AsterixException, HyracksDataException {
        if (this.fullTextFilterEntity.databaseNameIndex() >= 0) {
            this.fieldValue.reset();
            this.aString.setValue(filterDescriptor.getDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField(this.fullTextFilterEntity.databaseNameIndex(), (IValueReference)this.fieldValue);
        }
        this.fieldValue.reset();
        this.aString.setValue(filterDescriptor.getDataverseName().getCanonicalForm());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.fullTextFilterEntity.dataverseNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(filterDescriptor.getName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.fullTextFilterEntity.filterNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(filterDescriptor.getFilterType().getValue());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.fullTextFilterEntity.filterTypeIndex(), (IValueReference)this.fieldValue);
        switch (filterDescriptor.getFilterType()) {
            case STOPWORDS: {
                this.writeStopwordFilterDescriptor((StopwordsFullTextFilterDescriptor)filterDescriptor);
                break;
            }
            default: {
                throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{"Not supported yet"});
            }
        }
    }

    private void writeIndex(String databaseName, String dataverseName, String filterName, ArrayTupleBuilder tupleBuilder) throws HyracksDataException {
        if (this.fullTextFilterEntity.databaseNameIndex() >= 0) {
            this.aString.setValue(databaseName);
            this.stringSerde.serialize((Object)this.aString, tupleBuilder.getDataOutput());
            tupleBuilder.addFieldEndOffset();
        }
        this.aString.setValue(dataverseName);
        this.stringSerde.serialize((Object)this.aString, tupleBuilder.getDataOutput());
        tupleBuilder.addFieldEndOffset();
        this.aString.setValue(filterName);
        this.stringSerde.serialize((Object)this.aString, tupleBuilder.getDataOutput());
        tupleBuilder.addFieldEndOffset();
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(FullTextFilterMetadataEntity filterMetadataEntity) throws HyracksDataException, AsterixException {
        this.tupleBuilder.reset();
        this.writeIndex(filterMetadataEntity.getFullTextFilter().getDatabaseName(), filterMetadataEntity.getFullTextFilter().getDataverseName().getCanonicalForm(), filterMetadataEntity.getFullTextFilter().getName(), this.tupleBuilder);
        this.recordBuilder.reset(this.fullTextFilterEntity.getRecordType());
        this.writeFulltextFilter(filterMetadataEntity.getFullTextFilter());
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }
}

