/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.asterix.common.cluster.PartitioningProperties;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DatasetDataSource;
import org.apache.asterix.metadata.declared.FeedDataSource;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.declared.SampleDataSource;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourcePropertiesProvider;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.RandomPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.UnorderedPartitionedProperty;

public class DataSourcePartitioningProvider
implements IDataSourcePropertiesProvider {
    private final DataSource ds;
    private final INodeDomain domain;

    public DataSourcePartitioningProvider(DataSource dataSource, INodeDomain domain) {
        this.ds = dataSource;
        this.domain = domain;
    }

    public IPhysicalPropertiesVector computeRequiredProperties(List<LogicalVariable> scanVariables, IOptimizationContext ctx) throws AlgebricksException {
        RandomPartitioningProperty pp;
        ArrayList<ILocalStructuralProperty> propsLocal = new ArrayList<ILocalStructuralProperty>();
        switch (this.ds.getDatasourceType()) {
            case 1: 
            case 3: {
                pp = new RandomPartitioningProperty(this.domain);
                this.ds.computeLocalStructuralProperties(propsLocal, scanVariables);
                break;
            }
            case 2: {
                String dsName = ((FeedDataSource)this.ds).getTargetDataset();
                Dataset feedDs = ((MetadataProvider)ctx.getMetadataProvider()).findDataset(this.ds.getId().getDatabaseName(), this.ds.getId().getDataverseName(), dsName);
                PartitioningProperties partitioningProperties = ((MetadataProvider)ctx.getMetadataProvider()).getPartitioningProperties(feedDs);
                pp = DataSourcePartitioningProvider.getFeedDatasetPartitioningProperty(this.ds, this.domain, scanVariables, partitioningProperties.getComputeStorageMap());
                break;
            }
            case 0: 
            case 5: {
                ListSet pvars = new ListSet();
                Dataset dataset = this.ds.getDatasourceType() == 0 ? ((DatasetDataSource)this.ds).getDataset() : ((SampleDataSource)this.ds).getDataset();
                int[][] computeStorageMap = ((MetadataProvider)ctx.getMetadataProvider()).getPartitioningProperties(dataset).getComputeStorageMap();
                pp = DataSourcePartitioningProvider.getInternalDatasetPartitioningProperty(this.ds, this.domain, scanVariables, (Set<LogicalVariable>)pvars, computeStorageMap);
                propsLocal.add((ILocalStructuralProperty)new LocalOrderProperty(DataSourcePartitioningProvider.getOrderColumns((Set<LogicalVariable>)pvars)));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        StructuralPropertiesVector propsVector = new StructuralPropertiesVector((IPartitioningProperty)pp, propsLocal);
        return propsVector;
    }

    public IPhysicalPropertiesVector computeDeliveredProperties(List<LogicalVariable> scanVariables, IOptimizationContext ctx) throws AlgebricksException {
        switch (this.ds.getDatasourceType()) {
            case 0: {
                RandomPartitioningProperty pp = new RandomPartitioningProperty(this.domain);
                ArrayList<ILocalStructuralProperty> propsLocal = new ArrayList<ILocalStructuralProperty>();
                this.ds.computeLocalStructuralProperties(propsLocal, scanVariables);
                return new StructuralPropertiesVector((IPartitioningProperty)pp, propsLocal);
            }
            case 2: {
                IPartitioningProperty pp = DataSourcePartitioningProvider.getFeedPartitioningProperty(this.ds, this.domain, scanVariables);
                return new StructuralPropertiesVector(pp, new ArrayList());
            }
        }
        return this.computeRequiredProperties(scanVariables, ctx);
    }

    private static List<OrderColumn> getOrderColumns(Set<LogicalVariable> pvars) {
        ArrayList<OrderColumn> orderColumns = new ArrayList<OrderColumn>();
        for (LogicalVariable pkVar : pvars) {
            orderColumns.add(new OrderColumn(pkVar, OrderOperator.IOrder.OrderKind.ASC));
        }
        return orderColumns;
    }

    private static IPartitioningProperty getInternalDatasetPartitioningProperty(DataSource ds, INodeDomain domain, List<LogicalVariable> scanVariables, Set<LogicalVariable> pvars, int[][] partitionsMap) {
        RandomPartitioningProperty pp;
        if (scanVariables.size() < 2) {
            pp = new RandomPartitioningProperty(domain);
        } else {
            pvars.addAll(ds.getPrimaryKeyVariables(scanVariables));
            pp = UnorderedPartitionedProperty.ofPartitionsMap(pvars, (INodeDomain)domain, (int[][])partitionsMap);
        }
        return pp;
    }

    public static IPartitioningProperty getFeedDatasetPartitioningProperty(DataSource ds, INodeDomain domain, List<LogicalVariable> scanVariables, int[][] partitionsMap) {
        RandomPartitioningProperty pp;
        if (scanVariables.size() < 2) {
            pp = new RandomPartitioningProperty(domain);
        } else {
            ListSet pvars = new ListSet();
            pvars.addAll(ds.getPrimaryKeyVariables(scanVariables));
            pp = UnorderedPartitionedProperty.ofPartitionsMap((Set)pvars, (INodeDomain)domain, (int[][])partitionsMap);
        }
        return pp;
    }

    public static IPartitioningProperty getFeedPartitioningProperty(DataSource ds, INodeDomain domain, List<LogicalVariable> scanVariables) {
        RandomPartitioningProperty pp;
        if (scanVariables.size() < 2) {
            pp = new RandomPartitioningProperty(domain);
        } else {
            ListSet pvars = new ListSet();
            pvars.addAll(ds.getPrimaryKeyVariables(scanVariables));
            pp = UnorderedPartitionedProperty.of((Set)pvars, (INodeDomain)domain);
        }
        return pp;
    }
}

