/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.opcallbacks;

import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.transactions.AbstractOperationCallback;
import org.apache.asterix.common.transactions.DatasetId;
import org.apache.asterix.common.transactions.ILockManager;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.common.transactions.LogRecord;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IExtendedModificationOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.tuples.SimpleTupleWriter;

public abstract class AbstractIndexModificationOperationCallback
extends AbstractOperationCallback
implements IExtendedModificationOperationCallback {
    public static final byte INSERT_BYTE = 1;
    public static final byte DELETE_BYTE = 2;
    public static final byte UPSERT_BYTE = 3;
    public static final byte FILTER_BYTE = 4;
    protected final byte resourceType;
    protected final Operation indexOp;
    protected final ITransactionSubsystem txnSubsystem;
    protected final ILogRecord indexRecord;
    protected final ILogRecord filterRecord;

    protected AbstractIndexModificationOperationCallback(DatasetId datasetId, int[] primaryKeyFields, ITransactionContext txnCtx, ILockManager lockManager, ITransactionSubsystem txnSubsystem, long resourceId, int resourcePartition, byte resourceType, Operation indexOp) {
        super(datasetId, resourceId, primaryKeyFields, txnCtx, lockManager);
        this.resourceType = resourceType;
        this.indexOp = indexOp;
        this.txnSubsystem = txnSubsystem;
        this.indexRecord = new LogRecord();
        this.indexRecord.setTxnCtx(txnCtx);
        this.indexRecord.setLogType((byte)0);
        this.indexRecord.setTxnId(txnCtx.getTxnId().getId());
        this.indexRecord.setDatasetId(datasetId.getId());
        this.indexRecord.setResourceId(resourceId);
        this.indexRecord.setResourcePartition(resourcePartition);
        this.indexRecord.setNewOp(indexOp.value());
        this.filterRecord = new LogRecord();
        this.filterRecord.setTxnCtx(txnCtx);
        this.filterRecord.setLogType((byte)7);
        this.filterRecord.setDatasetId(datasetId.getId());
        this.filterRecord.setTxnId(txnCtx.getTxnId().getId());
        this.filterRecord.setResourceId(resourceId);
        this.filterRecord.setResourcePartition(resourcePartition);
        this.filterRecord.setNewOp(Operation.FILTER_MOD.value());
    }

    protected void log(int PKHash, ITupleReference newValue, ITupleReference oldValue) throws ACIDException {
        this.indexRecord.setPKHashValue(PKHash);
        this.indexRecord.setPKFields(this.primaryKeyFields);
        this.indexRecord.setPKValue(newValue);
        this.indexRecord.computeAndSetPKValueSize();
        if (newValue != null) {
            this.indexRecord.setNewValueSize(SimpleTupleWriter.INSTANCE.bytesRequired(newValue));
            this.indexRecord.setNewValue(newValue);
        } else {
            this.indexRecord.setNewValueSize(0);
        }
        if (oldValue != null) {
            this.indexRecord.setOldValueSize(SimpleTupleWriter.INSTANCE.bytesRequired(oldValue));
            this.indexRecord.setOldValue(oldValue);
        } else {
            this.indexRecord.setOldValueSize(0);
        }
        this.indexRecord.computeAndSetLogSize();
        this.txnSubsystem.getLogManager().log(this.indexRecord);
    }

    public void after(ITupleReference newValue) throws HyracksDataException {
        if (newValue != null) {
            this.filterRecord.setNewValueSize(SimpleTupleWriter.INSTANCE.bytesRequired(newValue));
            this.filterRecord.setNewValue(newValue);
            this.filterRecord.computeAndSetLogSize();
            this.txnSubsystem.getLogManager().log(this.filterRecord);
        }
    }

    public void setOp(Operation op) {
        this.indexRecord.setNewOp(op.value());
    }

    public static enum Operation {
        INSERT(1),
        DELETE(2),
        UPSERT(3),
        FILTER_MOD(4);

        private byte value;

        private Operation(byte value) {
            this.value = value;
        }

        byte value() {
            return this.value;
        }

        public static Operation get(IndexOperation op) {
            switch (op) {
                case DELETE: {
                    return DELETE;
                }
                case INSERT: {
                    return INSERT;
                }
                case FILTER_MOD: {
                    return FILTER_MOD;
                }
                case UPSERT: {
                    return UPSERT;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

