/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.cbo;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.annotations.IndexedNLJoinExpressionAnnotation;
import org.apache.asterix.common.annotations.SkipSecondaryIndexSearchExpressionAnnotation;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.optimizer.rules.cbo.JoinEnum;
import org.apache.asterix.optimizer.rules.cbo.JoinOperator;
import org.apache.asterix.optimizer.rules.cbo.OperatorUtils;
import org.apache.asterix.optimizer.rules.cbo.PlanNode;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Quadruple;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.BroadcastExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.HashJoinExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.IPlanPrettyPrinter;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnumerateJoinsRule
implements IAlgebraicRewriteRule {
    private static final Logger LOGGER = LogManager.getLogger();
    private final JoinEnum joinEnum;
    private int leafInputNumber;
    private List<ILogicalOperator> newJoinOps;
    private List<JoinOperator> allJoinOps;
    private List<ILogicalOperator> leafInputs;
    private HashMap<LogicalVariable, Integer> varLeafInputIds;
    private List<Triple<Integer, Integer, Boolean>> buildSets;
    private List<Quadruple<Integer, Integer, JoinOperator, Integer>> outerJoinsDependencyList;
    private List<AssignOperator> assignOps;
    private List<ILogicalExpression> assignJoinExprs;
    private HashMap<DataSourceScanOperator, ILogicalOperator> dataScanAndGroupByDistinctOps;
    private ILogicalOperator rootGroupByDistinctOp;
    private ILogicalOperator rootOrderByOp;
    private List<LogicalVariable> resultAndJoinVars = new ArrayList<LogicalVariable>();

    public EnumerateJoinsRule(JoinEnum joinEnum) {
        this.joinEnum = joinEnum;
        this.dataScanAndGroupByDistinctOps = new HashMap();
        this.rootGroupByDistinctOp = null;
        this.rootOrderByOp = null;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        boolean cboMode = this.getCBOMode(context);
        boolean cboTestMode = this.getCBOTestMode(context);
        if (!cboMode && !cboTestMode) {
            return false;
        }
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (!this.joinClause(op) && op.getOperatorTag() != LogicalOperatorTag.DISTRIBUTE_RESULT) {
            return false;
        }
        if (op.getOperatorTag() == LogicalOperatorTag.DISTRIBUTE_RESULT) {
            this.getDistinctOpsForJoinNodes(op, context);
            this.findOrderByOp(op);
            ILogicalOperator tmp = op;
            while (tmp.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) {
                if (tmp.getOperatorTag().equals((Object)LogicalOperatorTag.ASSIGN)) {
                    this.addAllAssignExprVars(this.resultAndJoinVars, (AssignOperator)tmp);
                    break;
                }
                tmp = (ILogicalOperator)((Mutable)tmp.getInputs().get(0)).getValue();
            }
        }
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, op)) {
            return false;
        }
        this.allJoinOps = new ArrayList<JoinOperator>();
        this.newJoinOps = new ArrayList<ILogicalOperator>();
        this.leafInputs = new ArrayList<ILogicalOperator>();
        this.varLeafInputIds = new HashMap();
        this.outerJoinsDependencyList = new ArrayList<Quadruple<Integer, Integer, JoinOperator, Integer>>();
        this.assignOps = new ArrayList<AssignOperator>();
        this.assignJoinExprs = new ArrayList<ILogicalExpression>();
        this.buildSets = new ArrayList<Triple<Integer, Integer, Boolean>>();
        IPlanPrettyPrinter pp = context.getPrettyPrinter();
        EnumerateJoinsRule.printPlan(pp, (AbstractLogicalOperator)op, "Original Whole plan1");
        this.leafInputNumber = 0;
        boolean canTransform = this.getJoinOpsAndLeafInputs(op);
        if (!canTransform) {
            return false;
        }
        this.collectJoinConditionsVariables();
        this.convertOuterJoinstoJoinsIfPossible(this.outerJoinsDependencyList);
        EnumerateJoinsRule.printPlan(pp, (AbstractLogicalOperator)op, "Original Whole plan2");
        int numberOfFromTerms = this.leafInputs.size();
        if (LOGGER.isTraceEnabled()) {
            String viewInPlan = new ALogicalPlanImpl(opRef).toString();
            LOGGER.trace("viewInPlan");
            LOGGER.trace(viewInPlan);
        }
        if (this.buildSets.size() > 1) {
            this.buildSets.sort(Comparator.comparingDouble(o -> ((Integer)o.second).intValue()));
        }
        this.joinEnum.initEnum((AbstractLogicalOperator)op, cboMode, cboTestMode, numberOfFromTerms, this.leafInputs, this.allJoinOps, this.assignOps, this.outerJoinsDependencyList, this.buildSets, this.varLeafInputIds, this.dataScanAndGroupByDistinctOps, this.rootGroupByDistinctOp, this.rootOrderByOp, this.resultAndJoinVars, context);
        if (cboMode && !this.doAllDataSourcesHaveSamples(this.leafInputs, context)) {
            return false;
        }
        this.printLeafPlans(pp, this.leafInputs, "Inputs1");
        if (this.assignOps.size() > 0) {
            this.pushAssignsIntoLeafInputs(pp, this.leafInputs, this.assignOps, this.assignJoinExprs);
        }
        this.printLeafPlans(pp, this.leafInputs, "Inputs2");
        int cheapestPlan = this.joinEnum.enumerateJoins();
        if (cheapestPlan == PlanNode.NO_PLAN) {
            return false;
        }
        PlanNode cheapestPlanNode = this.joinEnum.allPlans.get(cheapestPlan);
        this.generateHintWarnings();
        if (numberOfFromTerms > 1) {
            this.getNewJoinOps(cheapestPlanNode, this.allJoinOps);
            if (this.allJoinOps.size() != this.newJoinOps.size()) {
                return false;
            }
            this.buildNewTree(cheapestPlanNode, this.newJoinOps, new MutableInt(0), context);
            opRef.setValue((Object)this.newJoinOps.get(0));
            if (this.assignOps.size() > 0) {
                for (int i = this.assignOps.size() - 1; i >= 0; --i) {
                    MutableBoolean removed = new MutableBoolean(false);
                    removed.setFalse();
                    this.pushAssignsAboveJoins(this.newJoinOps.get(0), this.assignOps.get(i), this.assignJoinExprs.get(i), removed);
                    context.computeAndSetTypeEnvironmentForOperator(this.newJoinOps.get(i));
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)this.assignOps.get(i));
                    if (!removed.isTrue()) continue;
                    this.assignOps.remove(i);
                }
            }
            EnumerateJoinsRule.printPlan(pp, (AbstractLogicalOperator)this.newJoinOps.get(0), "New Whole Plan after buildNewTree 1");
            ILogicalOperator root = this.addRemainingAssignsAtTheTop(this.newJoinOps.get(0), this.assignOps);
            EnumerateJoinsRule.printPlan(pp, (AbstractLogicalOperator)this.newJoinOps.get(0), "New Whole Plan after buildNewTree 2");
            EnumerateJoinsRule.printPlan(pp, (AbstractLogicalOperator)root, "New Whole Plan after buildNewTree");
            opRef.setValue((Object)root);
            if (LOGGER.isTraceEnabled()) {
                String viewOutPlan = new ALogicalPlanImpl(opRef).toString();
                LOGGER.trace("viewOutPlan");
                LOGGER.trace(viewOutPlan);
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("---------------------------- Printing Leaf Inputs");
                this.printLeafPlans(pp, this.leafInputs, "Inputs");
                for (int i = this.newJoinOps.size() - 1; i >= 0; --i) {
                    EnumerateJoinsRule.printPlan(pp, (AbstractLogicalOperator)this.newJoinOps.get(i), "join " + i);
                }
                EnumerateJoinsRule.printPlan(pp, (AbstractLogicalOperator)this.newJoinOps.get(0), "New Whole Plan");
                EnumerateJoinsRule.printPlan(pp, (AbstractLogicalOperator)root, "New Whole Plan");
            }
            for (ILogicalOperator joinOp : this.newJoinOps) {
                context.addToDontApplySet((IAlgebraicRewriteRule)this, joinOp);
            }
        } else {
            this.buildNewTree(cheapestPlanNode);
        }
        context.computeAndSetTypeEnvironmentForOperator(op);
        return true;
    }

    private void collectJoinConditionsVariables() {
        for (JoinOperator jOp : this.allJoinOps) {
            AbstractBinaryJoinOperator joinOp = jOp.getAbstractJoinOp();
            ILogicalExpression expr = (ILogicalExpression)joinOp.getCondition().getValue();
            ArrayList vars = new ArrayList();
            expr.getUsedVariables(vars);
            this.resultAndJoinVars.addAll(vars);
        }
    }

    private void addAllAssignExprVars(List<LogicalVariable> resultAndJoinVars, AssignOperator op) {
        for (Mutable exp : op.getExpressions()) {
            ArrayList vars = new ArrayList();
            ((ILogicalExpression)exp.getValue()).getUsedVariables(vars);
            resultAndJoinVars.addAll(vars);
        }
    }

    private void pushAssignsAboveJoins(ILogicalOperator op, AssignOperator aOp, ILogicalExpression jexpr, MutableBoolean removed) {
        System.out.println("op " + op.toString());
        if (!op.getInputs().isEmpty()) {
            for (int i = 0; i < op.getInputs().size(); ++i) {
                AbstractBinaryJoinOperator abOp;
                ILogicalExpression expr;
                ILogicalOperator oper = (ILogicalOperator)((Mutable)op.getInputs().get(i)).getValue();
                if (this.joinClause(oper) && (expr = (ILogicalExpression)(abOp = (AbstractBinaryJoinOperator)oper).getCondition().getValue()).equals(jexpr)) {
                    ((Mutable)op.getInputs().get(i)).setValue((Object)aOp);
                    ((Mutable)aOp.getInputs().get(0)).setValue((Object)oper);
                    removed.setTrue();
                    return;
                }
                this.pushAssignsAboveJoins(oper, aOp, jexpr, removed);
            }
        }
    }

    private boolean joinClause(ILogicalOperator op) {
        if (op.getOperatorTag() == LogicalOperatorTag.INNERJOIN) {
            return true;
        }
        return op.getOperatorTag() == LogicalOperatorTag.LEFTOUTERJOIN;
    }

    private void generateHintWarnings() {
        for (Map.Entry<IExpressionAnnotation, Warning> mapElement : this.joinEnum.joinHints.entrySet()) {
            IWarningCollector warningCollector;
            IExpressionAnnotation annotation = mapElement.getKey();
            Warning warning = mapElement.getValue();
            if (warning == null || !(warningCollector = this.joinEnum.optCtx.getWarningCollector()).shouldWarn()) continue;
            warningCollector.warn(warning);
        }
    }

    private boolean getCBOMode(IOptimizationContext context) {
        PhysicalOptimizationConfig physOptConfig = context.getPhysicalOptimizationConfig();
        return physOptConfig.getCBOMode();
    }

    private boolean getCBOTestMode(IOptimizationContext context) {
        PhysicalOptimizationConfig physOptConfig = context.getPhysicalOptimizationConfig();
        return physOptConfig.getCBOTestMode();
    }

    private Pair<EmptyTupleSourceOperator, DataSourceScanOperator> containsLeafInputOnly(ILogicalOperator op) {
        DataSourceScanOperator dataSourceOp = null;
        ILogicalOperator currentOp = op;
        while (currentOp.getInputs().size() == 1) {
            if (currentOp.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN) {
                if (dataSourceOp != null) {
                    return null;
                }
                dataSourceOp = (DataSourceScanOperator)currentOp;
            }
            currentOp = (ILogicalOperator)((Mutable)currentOp.getInputs().get(0)).getValue();
        }
        if (currentOp.getOperatorTag() == LogicalOperatorTag.EMPTYTUPLESOURCE) {
            return new Pair((Object)((EmptyTupleSourceOperator)currentOp), (Object)dataSourceOp);
        }
        return null;
    }

    private boolean onlyOneAssign(ILogicalOperator op, List<AssignOperator> assignOps) {
        if (op.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
            AssignOperator aOp = (AssignOperator)op;
            assignOps.add(aOp);
            op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
        return this.joinClause(op);
    }

    private int numVarRefExprs(AssignOperator aOp) {
        List exprs = aOp.getExpressions();
        int count = 0;
        for (Mutable exp : exprs) {
            if (((ILogicalExpression)exp.getValue()).getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
            AbstractFunctionCallExpression afcExpr = (AbstractFunctionCallExpression)exp.getValue();
            for (Mutable arg : afcExpr.getArguments()) {
                if (((ILogicalExpression)arg.getValue()).getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
                ++count;
            }
        }
        return count;
    }

    private boolean onlyAssigns(ILogicalOperator op, List<AssignOperator> assignOps) {
        while (op.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
            AssignOperator aOp = (AssignOperator)op;
            int count = this.numVarRefExprs(aOp);
            if (count > 1) {
                return false;
            }
            assignOps.add(aOp);
            this.assignJoinExprs.add(this.joinExprFound(op));
            op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
        return this.joinClause(op);
    }

    private ILogicalOperator skipPastAssigns(ILogicalOperator nextOp) {
        while (nextOp.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
            nextOp = (ILogicalOperator)((Mutable)nextOp.getInputs().get(0)).getValue();
        }
        return nextOp;
    }

    private ILogicalOperator findSelectOrUnnestOrDataScan(ILogicalOperator op) {
        ILogicalOperator currentOp = op;
        while (currentOp.getInputs().size() <= 1) {
            LogicalOperatorTag tag = currentOp.getOperatorTag();
            if (tag == LogicalOperatorTag.EMPTYTUPLESOURCE) {
                return null;
            }
            if (tag == LogicalOperatorTag.SELECT || tag == LogicalOperatorTag.UNNEST || tag == LogicalOperatorTag.DATASOURCESCAN) {
                return currentOp;
            }
            currentOp = (ILogicalOperator)((Mutable)currentOp.getInputs().get(0)).getValue();
        }
        return null;
    }

    private void getDistinctOpsForJoinNodes(ILogicalOperator op, IOptimizationContext context) {
        if (op.getOperatorTag() != LogicalOperatorTag.DISTRIBUTE_RESULT) {
            return;
        }
        ILogicalOperator grpByDistinctOp = null;
        ILogicalOperator currentOp = op;
        do {
            LogicalOperatorTag tag;
            if ((tag = currentOp.getOperatorTag()) == LogicalOperatorTag.DISTINCT || tag == LogicalOperatorTag.GROUP) {
                this.rootGroupByDistinctOp = grpByDistinctOp = currentOp;
                continue;
            }
            if (tag == LogicalOperatorTag.INNERJOIN || tag == LogicalOperatorTag.LEFTOUTERJOIN) {
                if (grpByDistinctOp != null) {
                    Pair<List<LogicalVariable>, List<AbstractFunctionCallExpression>> distinctVarsFuncPair = OperatorUtils.getGroupByDistinctVarFuncPair(grpByDistinctOp);
                    for (int i = 0; i < currentOp.getInputs().size(); ++i) {
                        ILogicalOperator nextOp = (ILogicalOperator)((Mutable)currentOp.getInputs().get(i)).getValue();
                        OperatorUtils.createDistinctOpsForJoinNodes(nextOp, distinctVarsFuncPair, context, this.dataScanAndGroupByDistinctOps);
                    }
                }
                return;
            }
            if (tag != LogicalOperatorTag.DATASOURCESCAN) continue;
            DataSourceScanOperator scanOp = (DataSourceScanOperator)currentOp;
            if (grpByDistinctOp != null) {
                this.dataScanAndGroupByDistinctOps.put(scanOp, grpByDistinctOp);
            }
            return;
        } while ((currentOp = (ILogicalOperator)((Mutable)currentOp.getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE);
    }

    private void findOrderByOp(ILogicalOperator op) {
        ILogicalOperator currentOp = op;
        if (currentOp.getOperatorTag() != LogicalOperatorTag.DISTRIBUTE_RESULT) {
            return;
        }
        while (currentOp != null) {
            LogicalOperatorTag tag = currentOp.getOperatorTag();
            if (tag == LogicalOperatorTag.ORDER) {
                this.rootOrderByOp = currentOp;
                return;
            }
            if (tag == LogicalOperatorTag.EMPTYTUPLESOURCE) {
                return;
            }
            currentOp = (ILogicalOperator)((Mutable)currentOp.getInputs().get(0)).getValue();
        }
    }

    private int getLeafInputId(LogicalVariable lv) {
        if (this.varLeafInputIds.containsKey(lv)) {
            return this.varLeafInputIds.get(lv);
        }
        return -1;
    }

    private boolean addLeafInputNumbersToVars(ILogicalOperator op) throws AlgebricksException {
        HashSet opVars = new HashSet();
        VariableUtilities.getLiveVariables((ILogicalOperator)op, opVars);
        for (LogicalVariable lv : opVars) {
            int id = this.getLeafInputId(lv);
            if (id != -1 && id != this.leafInputNumber) {
                return false;
            }
            this.varLeafInputIds.put(lv, this.leafInputNumber);
        }
        return true;
    }

    private boolean foundVar(LogicalVariable inputLV, ILogicalOperator op) throws AlgebricksException {
        HashSet opVars = new HashSet();
        VariableUtilities.getLiveVariables((ILogicalOperator)op, opVars);
        return opVars.contains(inputLV);
    }

    private void convertOuterJoinstoJoinsIfPossible(List<Quadruple<Integer, Integer, JoinOperator, Integer>> outerJoinsDependencyList) {
        int i;
        boolean changes = true;
        while (changes) {
            changes = false;
            for (i = 0; i < outerJoinsDependencyList.size(); ++i) {
                Quadruple<Integer, Integer, JoinOperator, Integer> tr1 = outerJoinsDependencyList.get(i);
                if (!((JoinOperator)tr1.getThird()).getOuterJoin()) continue;
                for (int j = 0; j < outerJoinsDependencyList.size(); ++j) {
                    Quadruple<Integer, Integer, JoinOperator, Integer> tr2 = outerJoinsDependencyList.get(j);
                    if (i == j || ((JoinOperator)tr2.getThird()).getOuterJoin() || !((Integer)tr1.getSecond()).equals(tr2.getFirst()) && !((Integer)tr1.getSecond()).equals(tr2.getSecond())) continue;
                    ((JoinOperator)outerJoinsDependencyList.get(i).getThird()).setOuterJoin(false);
                    changes = true;
                }
            }
        }
        for (i = outerJoinsDependencyList.size() - 1; i >= 0; --i) {
            if (((JoinOperator)outerJoinsDependencyList.get(i).getThird()).getOuterJoin()) continue;
            outerJoinsDependencyList.remove(i);
        }
        if (outerJoinsDependencyList.size() == 0) {
            for (i = this.buildSets.size() - 1; i >= 0; --i) {
                this.buildSets.remove(i);
            }
        }
    }

    private boolean buildDependencyList(ILogicalOperator op, JoinOperator jO, List<Quadruple<Integer, Integer, JoinOperator, Integer>> outerJoinsDependencyList, int rightSideBits) throws AlgebricksException {
        ArrayList conjs;
        AbstractBinaryJoinOperator outerJoinOp = (AbstractBinaryJoinOperator)op;
        ILogicalOperator leftOp = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        ILogicalExpression expr = (ILogicalExpression)outerJoinOp.getCondition().getValue();
        if (expr.splitIntoConjuncts(conjs = new ArrayList())) {
            for (Mutable conj : conjs) {
                ArrayList joinExprVars = new ArrayList();
                int leftSideExprBits = 0;
                int rightSideExprBits = 0;
                ((ILogicalExpression)conj.getValue()).getUsedVariables(joinExprVars);
                for (LogicalVariable lv : joinExprVars) {
                    int id = this.getLeafInputId(lv);
                    if (id == -1) continue;
                    if (this.foundVar(lv, leftOp)) {
                        leftSideExprBits |= 1 << id - 1;
                        continue;
                    }
                    rightSideExprBits |= 1 << id - 1;
                }
                if (leftSideExprBits == 0 || rightSideExprBits == 0) continue;
                outerJoinsDependencyList.add((Quadruple<Integer, Integer, JoinOperator, Integer>)new Quadruple((Object)leftSideExprBits, (Object)rightSideBits, (Object)jO, (Object)0));
            }
        } else {
            int leftSideExprBits = 0;
            int rightSideExprBits = 0;
            ArrayList joinExprVars = new ArrayList();
            expr.getUsedVariables(joinExprVars);
            for (LogicalVariable lv : joinExprVars) {
                int id = this.getLeafInputId(lv);
                if (id == -1) continue;
                if (this.foundVar(lv, leftOp)) {
                    leftSideExprBits |= 1 << id - 1;
                    continue;
                }
                rightSideExprBits |= 1 << id - 1;
            }
            if (leftSideExprBits != 0 && rightSideExprBits != 0) {
                outerJoinsDependencyList.add((Quadruple<Integer, Integer, JoinOperator, Integer>)new Quadruple((Object)leftSideExprBits, (Object)rightSideBits, (Object)jO, (Object)0));
            }
        }
        return true;
    }

    private ILogicalExpression joinExprFound(ILogicalOperator op) {
        if (!op.getInputs().isEmpty()) {
            int i = 0;
            if (i < op.getInputs().size()) {
                ILogicalOperator oper = (ILogicalOperator)((Mutable)op.getInputs().get(i)).getValue();
                if (this.joinClause(oper)) {
                    AbstractBinaryJoinOperator abOp = (AbstractBinaryJoinOperator)oper;
                    return (ILogicalExpression)abOp.getCondition().getValue();
                }
                return this.joinExprFound(oper);
            }
        } else {
            return null;
        }
        return null;
    }

    private boolean getJoinOpsAndLeafInputs(ILogicalOperator op) throws AlgebricksException {
        if (this.joinClause(op)) {
            JoinOperator jO = new JoinOperator((AbstractBinaryJoinOperator)op);
            this.allJoinOps.add(jO);
            if (op.getOperatorTag() == LogicalOperatorTag.LEFTOUTERJOIN) {
                jO.setOuterJoin(true);
            }
            int k = 0;
            for (int i = 0; i < 2; ++i) {
                boolean ret;
                ILogicalOperator nextOp = (ILogicalOperator)((Mutable)op.getInputs().get(i)).getValue();
                int firstLeafInputNumber = this.leafInputNumber + 1;
                boolean canTransform = this.getJoinOpsAndLeafInputs(nextOp);
                if (!canTransform) {
                    return false;
                }
                int lastLeafInputNumber = this.leafInputNumber;
                k = 0;
                if (!this.joinClause(op) || i != 1) continue;
                for (int j = firstLeafInputNumber; j <= lastLeafInputNumber; ++j) {
                    k |= 1 << j - 1;
                }
                if (op.getOperatorTag() == LogicalOperatorTag.LEFTOUTERJOIN && firstLeafInputNumber < lastLeafInputNumber) {
                    this.buildSets.add((Triple<Integer, Integer, Boolean>)new Triple((Object)k, (Object)(lastLeafInputNumber - firstLeafInputNumber + 1), (Object)true));
                }
                if (ret = this.buildDependencyList(op, jO, this.outerJoinsDependencyList, k)) continue;
                return false;
            }
        } else {
            if (op.getOperatorTag() == LogicalOperatorTag.GROUP) {
                return false;
            }
            Pair<EmptyTupleSourceOperator, DataSourceScanOperator> etsDataSource = this.containsLeafInputOnly(op);
            if (etsDataSource != null) {
                EmptyTupleSourceOperator etsOp = (EmptyTupleSourceOperator)etsDataSource.first;
                DataSourceScanOperator dataSourceOp = (DataSourceScanOperator)etsDataSource.second;
                if (op.getOperatorTag().equals((Object)LogicalOperatorTag.DISTRIBUTE_RESULT)) {
                    ILogicalOperator selectOp = this.findSelectOrUnnestOrDataScan(op);
                    if (selectOp == null) {
                        return false;
                    }
                    this.leafInputs.add(selectOp);
                } else {
                    ++this.leafInputNumber;
                    this.leafInputs.add(op);
                    if (!this.addLeafInputNumbersToVars(op)) {
                        return false;
                    }
                }
            } else if (this.onlyAssigns(op, this.assignOps)) {
                ILogicalOperator skipAssisgnsOp = this.skipPastAssigns(op);
                boolean canTransform = this.getJoinOpsAndLeafInputs(skipAssisgnsOp);
                if (!canTransform) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private void addCardCostAnnotations(ILogicalOperator op, PlanNode plan) {
        if (op == null) {
            return;
        }
        op.getAnnotations().put("OUTPUT_CARDINALITY", (double)Math.round(plan.getJoinNode().getCardinality() * 100.0) / 100.0);
        op.getAnnotations().put("TOTAL_COST", (double)Math.round(plan.computeTotalCost() * 100.0) / 100.0);
        if (plan.IsScanNode()) {
            op.getAnnotations().put("INPUT_CARDINALITY", (double)Math.round(plan.getJoinNode().getOrigCardinality() * 100.0) / 100.0);
            op.getAnnotations().put("OP_COST", (double)Math.round(plan.computeOpCost() * 100.0) / 100.0);
        } else {
            op.getAnnotations().put("LEFT_EXCHANGE_COST", (double)Math.round(plan.getLeftExchangeCost().computeTotalCost() * 100.0) / 100.0);
            op.getAnnotations().put("RIGHT_EXCHANGE_COST", (double)Math.round(plan.getRightExchangeCost().computeTotalCost() * 100.0) / 100.0);
            op.getAnnotations().put("OP_COST", (double)Math.round(plan.computeOpCost() * 100.0) / 100.0);
        }
        if (op.getOperatorTag().equals((Object)LogicalOperatorTag.SELECT)) {
            op.getAnnotations().put("OP_COST", 0.0);
        }
    }

    private ILogicalOperator findDataSourceScanOperator(ILogicalOperator op) {
        ILogicalOperator origOp = op;
        while (op != null && op.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) {
            if (op.getOperatorTag().equals((Object)LogicalOperatorTag.DATASOURCESCAN)) {
                return op;
            }
            op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
        return null;
    }

    private void removeJoinAnnotations(AbstractFunctionCallExpression afcExpr) {
        afcExpr.removeAnnotation(BroadcastExpressionAnnotation.class);
        afcExpr.removeAnnotation(IndexedNLJoinExpressionAnnotation.class);
        afcExpr.removeAnnotation(HashJoinExpressionAnnotation.class);
    }

    protected static void setAnnotation(AbstractFunctionCallExpression afcExpr, IExpressionAnnotation anno) {
        FunctionIdentifier fi = afcExpr.getFunctionIdentifier();
        List arguments = afcExpr.getArguments();
        if (fi.equals((Object)AlgebricksBuiltinFunctions.AND)) {
            for (Mutable iLogicalExpressionMutable : arguments) {
                ILogicalExpression argument = (ILogicalExpression)iLogicalExpressionMutable.getValue();
                AbstractFunctionCallExpression expr = (AbstractFunctionCallExpression)argument;
                expr.putAnnotation(anno);
            }
        } else {
            afcExpr.putAnnotation(anno);
        }
    }

    private int findAssignOp(ILogicalOperator leafInput, List<AssignOperator> assignOps, List<ILogicalExpression> assignJoinExprs) throws AlgebricksException {
        int i = -1;
        for (AssignOperator aOp : assignOps) {
            if (assignJoinExprs.get(++i) != null) continue;
            ArrayList vars = new ArrayList();
            ((ILogicalExpression)((Mutable)aOp.getExpressions().get(0)).getValue()).getUsedVariables(vars);
            HashSet vars2 = new HashSet();
            VariableUtilities.getLiveVariables((ILogicalOperator)leafInput, vars2);
            if (!vars2.containsAll(vars)) continue;
            return i;
        }
        return -1;
    }

    private ILogicalOperator addAssignToLeafInput(ILogicalOperator leafInput, AssignOperator aOp) {
        ((Mutable)aOp.getInputs().get(0)).setValue((Object)leafInput);
        return aOp;
    }

    private void skipAllIndexes(PlanNode plan, ILogicalOperator leafInput) {
        if (plan.scanOp == PlanNode.ScanMethod.TABLE_SCAN && leafInput.getOperatorTag() == LogicalOperatorTag.SELECT) {
            ArrayList conjs;
            SelectOperator selOper = (SelectOperator)leafInput;
            ILogicalExpression expr = (ILogicalExpression)selOper.getCondition().getValue();
            if (expr.splitIntoConjuncts(conjs = new ArrayList())) {
                conjs.remove(new MutableObject((Object)ConstantExpression.TRUE));
                for (Mutable conj : conjs) {
                    if (!((ILogicalExpression)conj.getValue()).getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL)) continue;
                    AbstractFunctionCallExpression afce = (AbstractFunctionCallExpression)conj.getValue();
                    afce.removeAnnotation(SkipSecondaryIndexSearchExpressionAnnotation.class);
                    afce.putAnnotation((IExpressionAnnotation)SkipSecondaryIndexSearchExpressionAnnotation.INSTANCE_ANY_INDEX);
                }
            } else if (expr.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL)) {
                AbstractFunctionCallExpression afce = (AbstractFunctionCallExpression)expr;
                afce.removeAnnotation(SkipSecondaryIndexSearchExpressionAnnotation.class);
                afce.putAnnotation((IExpressionAnnotation)SkipSecondaryIndexSearchExpressionAnnotation.INSTANCE_ANY_INDEX);
            }
        }
    }

    private void buildNewTree(PlanNode plan) {
        ILogicalOperator leftInput = plan.getLeafInput();
        this.skipAllIndexes(plan, leftInput);
        ILogicalOperator selOp = this.findSelectOrUnnestOrDataScan(leftInput);
        if (selOp != null) {
            this.addCardCostAnnotations(selOp, plan);
        }
        this.addCardCostAnnotations(this.findDataSourceScanOperator(leftInput), plan);
    }

    private void getJoinNode(PlanNode plan, List<JoinOperator> allJoinOps) throws AlgebricksException {
        if (plan.outerJoin) {
            for (int i = 0; i < allJoinOps.size(); ++i) {
                AbstractBinaryJoinOperator abjOp = allJoinOps.get(i).getAbstractJoinOp();
                if (abjOp.getJoinKind() != AbstractBinaryJoinOperator.JoinKind.LEFT_OUTER) continue;
                this.newJoinOps.add(OperatorManipulationUtil.bottomUpCopyOperators((ILogicalOperator)abjOp));
                return;
            }
        } else {
            for (int i = 0; i < allJoinOps.size(); ++i) {
                AbstractBinaryJoinOperator abjOp = allJoinOps.get(i).getAbstractJoinOp();
                if (abjOp.getJoinKind() != AbstractBinaryJoinOperator.JoinKind.INNER) continue;
                this.newJoinOps.add(OperatorManipulationUtil.bottomUpCopyOperators((ILogicalOperator)abjOp));
                return;
            }
        }
    }

    private void getNewJoinOps(PlanNode plan, List<JoinOperator> allJoinOps) throws AlgebricksException {
        if (plan.IsJoinNode()) {
            this.getJoinNode(plan, allJoinOps);
            this.getNewJoinOps(plan.getLeftPlanNode(), allJoinOps);
            this.getNewJoinOps(plan.getRightPlanNode(), allJoinOps);
        }
    }

    private void fillJoinAnnotations(PlanNode plan, ILogicalOperator joinOp) {
        AbstractBinaryJoinOperator abJoinOp = (AbstractBinaryJoinOperator)joinOp;
        ILogicalExpression expr = plan.getJoinExpr();
        abJoinOp.getCondition().setValue((Object)expr);
        if (plan.getJoinOp() == PlanNode.JoinMethod.INDEX_NESTED_LOOP_JOIN) {
            AbstractFunctionCallExpression afcExpr = (AbstractFunctionCallExpression)expr;
            this.removeJoinAnnotations(afcExpr);
            EnumerateJoinsRule.setAnnotation(afcExpr, (IExpressionAnnotation)IndexedNLJoinExpressionAnnotation.INSTANCE_ANY_INDEX);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Added IndexedNLJoinExpressionAnnotation.INSTANCE_ANY_INDEX to " + afcExpr.toString());
            }
        } else if (plan.getJoinOp() == PlanNode.JoinMethod.HYBRID_HASH_JOIN || plan.getJoinOp() == PlanNode.JoinMethod.BROADCAST_HASH_JOIN || plan.getJoinOp() == PlanNode.JoinMethod.CARTESIAN_PRODUCT_JOIN) {
            if (plan.getJoinOp() == PlanNode.JoinMethod.BROADCAST_HASH_JOIN) {
                BroadcastExpressionAnnotation bcast = new BroadcastExpressionAnnotation(plan.side == HashJoinExpressionAnnotation.BuildSide.RIGHT ? BroadcastExpressionAnnotation.BroadcastSide.RIGHT : BroadcastExpressionAnnotation.BroadcastSide.LEFT);
                AbstractFunctionCallExpression afcExpr = (AbstractFunctionCallExpression)expr;
                this.removeJoinAnnotations(afcExpr);
                EnumerateJoinsRule.setAnnotation(afcExpr, (IExpressionAnnotation)bcast);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Added BroadCastAnnotation to " + afcExpr.toString());
                }
            } else if (plan.getJoinOp() == PlanNode.JoinMethod.HYBRID_HASH_JOIN) {
                HashJoinExpressionAnnotation hjAnnotation = new HashJoinExpressionAnnotation(plan.side);
                AbstractFunctionCallExpression afcExpr = (AbstractFunctionCallExpression)expr;
                this.removeJoinAnnotations(afcExpr);
                EnumerateJoinsRule.setAnnotation(afcExpr, (IExpressionAnnotation)hjAnnotation);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Added HashJoinAnnotation to " + afcExpr.toString());
                }
            } else if (expr != ConstantExpression.TRUE) {
                AbstractFunctionCallExpression afcExpr = (AbstractFunctionCallExpression)expr;
                this.removeJoinAnnotations(afcExpr);
            }
        }
        this.addCardCostAnnotations(joinOp, plan);
    }

    private void buildNewTree(PlanNode plan, List<ILogicalOperator> joinOps, MutableInt totalNumberOfJoins, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator rightInput;
        ILogicalOperator selOp;
        ILogicalOperator leftInput;
        List<PlanNode> allPlans = this.joinEnum.getAllPlans();
        int leftIndex = plan.getLeftPlanIndex();
        int rightIndex = plan.getRightPlanIndex();
        PlanNode leftPlan = allPlans.get(leftIndex);
        PlanNode rightPlan = allPlans.get(rightIndex);
        ILogicalOperator joinOp = joinOps.get(totalNumberOfJoins.intValue());
        if (plan.IsJoinNode()) {
            this.fillJoinAnnotations(plan, joinOp);
        }
        if (leftPlan.IsScanNode()) {
            leftInput = leftPlan.getLeafInput();
            this.skipAllIndexes(leftPlan, leftInput);
            selOp = this.findSelectOrUnnestOrDataScan(leftInput);
            if (selOp != null) {
                this.addCardCostAnnotations(selOp, leftPlan);
            }
            ((Mutable)joinOp.getInputs().get(0)).setValue((Object)leftInput);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)((Mutable)joinOp.getInputs().get(0)).getValue());
            this.addCardCostAnnotations(this.findDataSourceScanOperator(leftInput), leftPlan);
        } else {
            totalNumberOfJoins.increment();
            leftInput = joinOps.get(totalNumberOfJoins.intValue());
            ((Mutable)joinOp.getInputs().get(0)).setValue((Object)leftInput);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)((Mutable)joinOp.getInputs().get(0)).getValue());
            this.buildNewTree(leftPlan, joinOps, totalNumberOfJoins, context);
        }
        if (rightPlan.IsScanNode()) {
            rightInput = rightPlan.getLeafInput();
            this.skipAllIndexes(rightPlan, rightInput);
            selOp = this.findSelectOrUnnestOrDataScan(rightInput);
            if (selOp != null) {
                this.addCardCostAnnotations(selOp, rightPlan);
            }
            ((Mutable)joinOp.getInputs().get(1)).setValue((Object)rightInput);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)((Mutable)joinOp.getInputs().get(1)).getValue());
            this.addCardCostAnnotations(this.findDataSourceScanOperator(rightInput), rightPlan);
        } else {
            totalNumberOfJoins.increment();
            rightInput = joinOps.get(totalNumberOfJoins.intValue());
            ((Mutable)joinOp.getInputs().get(1)).setValue((Object)rightInput);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)((Mutable)joinOp.getInputs().get(1)).getValue());
            this.buildNewTree(rightPlan, joinOps, totalNumberOfJoins, context);
        }
    }

    private ILogicalOperator addRemainingAssignsAtTheTop(ILogicalOperator op, List<AssignOperator> assignOps) {
        ILogicalOperator root = op;
        for (AssignOperator aOp : assignOps) {
            ((Mutable)aOp.getInputs().get(0)).setValue((Object)root);
            root = aOp;
        }
        return root;
    }

    protected static void printPlan(IPlanPrettyPrinter pp, AbstractLogicalOperator op, String text) throws AlgebricksException {
        if (LOGGER.isTraceEnabled()) {
            pp.reset();
            pp.printOperator(op, true, false);
            LOGGER.trace("---------------------------- {}\n{}\n----------------------------", (Object)text, (Object)pp);
        }
    }

    private void printLeafPlans(IPlanPrettyPrinter pp, List<ILogicalOperator> leafInputs, String msg) throws AlgebricksException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(msg);
            int i = 0;
            for (ILogicalOperator element : leafInputs) {
                EnumerateJoinsRule.printPlan(pp, (AbstractLogicalOperator)element, "Printing Leaf Input" + i);
                ++i;
            }
        }
    }

    private void pushAssignsIntoLeafInputs(IPlanPrettyPrinter pp, List<ILogicalOperator> leafInputs, List<AssignOperator> assignOps, List<ILogicalExpression> assignJoinExprs) throws AlgebricksException {
        Iterator<ILogicalOperator> iterator = leafInputs.iterator();
        while (iterator.hasNext()) {
            ILogicalOperator lo;
            ILogicalOperator joinLeafInput = lo = iterator.next();
            EnumerateJoinsRule.printPlan(pp, (AbstractLogicalOperator)joinLeafInput, "Incoming leaf Input");
            int assignNumber = this.findAssignOp(joinLeafInput, assignOps, assignJoinExprs);
            if (assignNumber == -1) continue;
            joinLeafInput = this.addAssignToLeafInput(joinLeafInput, assignOps.get(assignNumber));
            EnumerateJoinsRule.printPlan(pp, (AbstractLogicalOperator)joinLeafInput, "Modified leaf Input");
            assignOps.remove(assignNumber);
        }
    }

    private boolean doAllDataSourcesHaveSamples(List<ILogicalOperator> leafInputs, IOptimizationContext context) throws AlgebricksException {
        for (ILogicalOperator li : leafInputs) {
            Index index;
            DataSourceScanOperator scanOp = (DataSourceScanOperator)this.findDataSourceScanOperator(li);
            if (scanOp == null || (index = this.joinEnum.getStatsHandle().findSampleIndex(scanOp, context)) != null) continue;
            return false;
        }
        return true;
    }
}

