/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.compiler.provider;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.compiler.provider.IRuleSetFactory;
import org.apache.asterix.optimizer.base.RuleCollections;
import org.apache.asterix.optimizer.cost.CostMethods;
import org.apache.asterix.optimizer.rules.SetAsterixPhysicalOperatorsRule;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.compiler.rewriter.rulecontrollers.SequentialFirstRuleCheckFixpointRuleController;
import org.apache.hyracks.algebricks.compiler.rewriter.rulecontrollers.SequentialFixpointRuleController;
import org.apache.hyracks.algebricks.compiler.rewriter.rulecontrollers.SequentialOnceRuleController;
import org.apache.hyracks.algebricks.core.rewriter.base.AbstractRuleController;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.algebricks.core.rewriter.base.IRuleSetKind;

public class DefaultRuleSetFactory
implements IRuleSetFactory {
    @Override
    public List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> getLogicalRewrites(ICcApplicationContext appCtx) {
        return DefaultRuleSetFactory.buildLogical(appCtx);
    }

    @Override
    public List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> getLogicalRewrites(IRuleSetKind ruleSetKind, ICcApplicationContext appCtx) {
        if (ruleSetKind == IRuleSetFactory.RuleSetKind.SAMPLING) {
            return DefaultRuleSetFactory.buildLogicalSampling();
        }
        throw new IllegalArgumentException(String.valueOf(ruleSetKind));
    }

    @Override
    public List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> getPhysicalRewrites(ICcApplicationContext appCtx) {
        return DefaultRuleSetFactory.buildPhysical(appCtx, CostMethods::new);
    }

    public static List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> buildLogical(ICcApplicationContext appCtx) {
        ArrayList<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> defaultLogicalRewrites = new ArrayList<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>>();
        SequentialFixpointRuleController seqCtrlNoDfs = new SequentialFixpointRuleController(false);
        SequentialFixpointRuleController seqCtrlFullDfs = new SequentialFixpointRuleController(true);
        SequentialOnceRuleController seqOnceCtrl = new SequentialOnceRuleController(true);
        SequentialFirstRuleCheckFixpointRuleController seqFirstRuleGateKeeperDfs = new SequentialFirstRuleCheckFixpointRuleController(true);
        defaultLogicalRewrites.add(new Pair((Object)seqOnceCtrl, RuleCollections.buildInitialTranslationRuleCollection()));
        defaultLogicalRewrites.add(new Pair((Object)seqOnceCtrl, RuleCollections.buildTypeInferenceRuleCollection()));
        defaultLogicalRewrites.add(new Pair((Object)seqOnceCtrl, RuleCollections.buildAutogenerateIDRuleCollection()));
        defaultLogicalRewrites.add(new Pair((Object)seqCtrlFullDfs, RuleCollections.buildNormalizationRuleCollection(appCtx)));
        defaultLogicalRewrites.add(new Pair((Object)seqCtrlNoDfs, RuleCollections.buildCondPushDownAndJoinInferenceRuleCollection()));
        defaultLogicalRewrites.add(new Pair((Object)seqCtrlFullDfs, RuleCollections.buildLoadFieldsRuleCollection(appCtx, false)));
        defaultLogicalRewrites.add(new Pair((Object)seqCtrlFullDfs, RuleCollections.buildNormalizationRuleCollection(appCtx)));
        defaultLogicalRewrites.add(new Pair((Object)seqCtrlNoDfs, RuleCollections.buildCondPushDownAndJoinInferenceRuleCollection()));
        defaultLogicalRewrites.add(new Pair((Object)seqCtrlFullDfs, RuleCollections.buildLoadFieldsRuleCollection(appCtx, true)));
        defaultLogicalRewrites.add(new Pair((Object)seqOnceCtrl, RuleCollections.buildFulltextContainsRuleCollection()));
        defaultLogicalRewrites.add(new Pair((Object)seqOnceCtrl, RuleCollections.buildDataExchangeRuleCollection()));
        defaultLogicalRewrites.add(new Pair((Object)seqOnceCtrl, RuleCollections.buildCBORuleCollection()));
        defaultLogicalRewrites.add(new Pair((Object)seqCtrlNoDfs, RuleCollections.buildConsolidationRuleCollection()));
        defaultLogicalRewrites.add(new Pair((Object)seqCtrlNoDfs, RuleCollections.buildAccessMethodRuleCollection()));
        defaultLogicalRewrites.add(new Pair((Object)seqCtrlNoDfs, RuleCollections.buildPlanCleanupRuleCollection()));
        return defaultLogicalRewrites;
    }

    public static List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> buildLogicalSampling() {
        ArrayList<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> logicalRewrites = new ArrayList<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>>();
        SequentialFixpointRuleController seqCtrlNoDfs = new SequentialFixpointRuleController(false);
        logicalRewrites.add(new Pair((Object)seqCtrlNoDfs, RuleCollections.buildConsolidationRuleCollection()));
        logicalRewrites.add(new Pair((Object)seqCtrlNoDfs, RuleCollections.buildPlanCleanupRuleCollection()));
        return logicalRewrites;
    }

    public static List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> buildPhysical(ICcApplicationContext appCtx, SetAsterixPhysicalOperatorsRule.CostMethodsFactory cmf) {
        ArrayList<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> defaultPhysicalRewrites = new ArrayList<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>>();
        SequentialOnceRuleController seqOnceCtrl = new SequentialOnceRuleController(true);
        SequentialOnceRuleController seqOnceTopLevel = new SequentialOnceRuleController(false);
        defaultPhysicalRewrites.add(new Pair((Object)seqOnceCtrl, RuleCollections.buildPhysicalRewritesAllLevelsRuleCollection(cmf)));
        defaultPhysicalRewrites.add(new Pair((Object)seqOnceTopLevel, RuleCollections.buildPhysicalRewritesTopLevelRuleCollection(appCtx, cmf)));
        defaultPhysicalRewrites.add(new Pair((Object)seqOnceCtrl, RuleCollections.prepareForJobGenRuleCollection(cmf)));
        return defaultPhysicalRewrites;
    }
}

