/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.hyracks.bootstrap;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.app.message.StorageCleanupRequestMessage;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.cluster.IGlobalRecoveryManager;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.messaging.CCMessageBroker;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.util.ExitUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlobalRecoveryManager
implements IGlobalRecoveryManager {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final IStorageComponentProvider componentProvider;
    protected final ICCServiceContext serviceCtx;
    protected final IHyracksClientConnection hcc;
    protected volatile boolean recoveryCompleted;
    protected volatile boolean recovering;
    protected Future<?> recoveryFuture;

    public GlobalRecoveryManager(ICCServiceContext serviceCtx, IHyracksClientConnection hcc, IStorageComponentProvider componentProvider) {
        this.serviceCtx = serviceCtx;
        this.hcc = hcc;
        this.componentProvider = componentProvider;
    }

    public Set<IClusterManagementWork> notifyNodeFailure(Collection<String> deadNodeIds) {
        return Collections.emptySet();
    }

    public Set<IClusterManagementWork> notifyNodeJoin(String joinedNodeId) {
        return Collections.emptySet();
    }

    private void executeHyracksJob(JobSpecification spec) throws Exception {
        spec.setMaxReattempts(0);
        JobId jobId = this.hcc.startJob(spec);
        this.hcc.waitForCompletion(jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startGlobalRecovery(ICcApplicationContext appCtx) {
        if (!this.recoveryCompleted && !this.recovering) {
            GlobalRecoveryManager globalRecoveryManager = this;
            synchronized (globalRecoveryManager) {
                if (!this.recovering) {
                    this.recovering = true;
                    this.recoveryFuture = this.serviceCtx.getControllerService().getExecutor().submit(() -> {
                        try {
                            this.recover(appCtx);
                        }
                        catch (Throwable e) {
                            try {
                                LOGGER.fatal("Global recovery failed. Shutting down...", e);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            ExitUtil.exit((int)3);
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recover(ICcApplicationContext appCtx) throws Exception {
        LOGGER.info("Starting Global Recovery");
        MetadataManager.INSTANCE.init();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        this.rollbackIncompleteAtomicTransactions(appCtx);
        if (appCtx.getStorageProperties().isStorageGlobalCleanup()) {
            int storageGlobalCleanupTimeout = appCtx.getStorageProperties().getStorageGlobalCleanupTimeout();
            this.performGlobalStorageCleanup(mdTxnCtx, storageGlobalCleanupTimeout);
        }
        mdTxnCtx = this.doRecovery(appCtx, mdTxnCtx);
        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        this.recoveryCompleted = true;
        this.recovering = false;
        GlobalRecoveryManager globalRecoveryManager = this;
        synchronized (globalRecoveryManager) {
            this.recoveryFuture = null;
        }
        LOGGER.info("Global Recovery Completed. Refreshing cluster state...");
        appCtx.getClusterStateManager().refreshState();
    }

    protected void rollbackIncompleteAtomicTransactions(ICcApplicationContext appCtx) throws Exception {
        appCtx.getGlobalTxManager().rollback();
    }

    protected void performGlobalStorageCleanup(MetadataTransactionContext mdTxnCtx, int storageGlobalCleanupTimeoutSecs) throws Exception {
        List dataverses = MetadataManager.INSTANCE.getDataverses(mdTxnCtx);
        IntOpenHashSet validDatasetIds = new IntOpenHashSet();
        for (Dataverse dataverse : dataverses) {
            List dataverseDatasets = MetadataManager.INSTANCE.getDataverseDatasets(mdTxnCtx, dataverse.getDatabaseName(), dataverse.getDataverseName());
            dataverseDatasets.stream().filter(DatasetUtil::isNotView).mapToInt(Dataset::getDatasetId).forEach(arg_0 -> ((IntOpenHashSet)validDatasetIds).add(arg_0));
        }
        ICcApplicationContext ccAppCtx = (ICcApplicationContext)this.serviceCtx.getApplicationContext();
        ArrayList<String> ncs = new ArrayList<String>(ccAppCtx.getClusterStateManager().getParticipantNodes());
        CCMessageBroker messageBroker = (CCMessageBroker)ccAppCtx.getServiceContext().getMessageBroker();
        long reqId = messageBroker.newRequestId();
        ArrayList<StorageCleanupRequestMessage> requests = new ArrayList<StorageCleanupRequestMessage>();
        for (int i = 0; i < ncs.size(); ++i) {
            requests.add(new StorageCleanupRequestMessage(reqId, validDatasetIds));
        }
        messageBroker.sendSyncRequestToNCs(reqId, ncs, requests, TimeUnit.SECONDS.toMillis(storageGlobalCleanupTimeoutSecs), false);
    }

    protected MetadataTransactionContext doRecovery(ICcApplicationContext appCtx, MetadataTransactionContext mdTxnCtx) throws Exception {
        for (Dataverse dataverse : MetadataManager.INSTANCE.getDataverses(mdTxnCtx)) {
            MetadataManager.INSTANCE.getDataverse(mdTxnCtx, dataverse.getDatabaseName(), dataverse.getDataverseName());
        }
        return mdTxnCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyStateChange(IClusterManagementWork.ClusterState newState) {
        GlobalRecoveryManager globalRecoveryManager = this;
        synchronized (globalRecoveryManager) {
            if (this.recovering && newState == IClusterManagementWork.ClusterState.UNUSABLE && this.recoveryFuture != null) {
                this.recoveryFuture.cancel(true);
            }
        }
        if (newState != IClusterManagementWork.ClusterState.ACTIVE && newState != IClusterManagementWork.ClusterState.RECOVERING) {
            this.recoveryCompleted = false;
        }
    }

    public boolean isRecoveryCompleted() {
        return this.recoveryCompleted;
    }
}

