/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.functions;

import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;

public class AlgebricksBuiltinFunctions {
    public static final String ALGEBRICKS_NS = "algebricks";
    public static final String ALGEBRICKS_DB = "algebricks";
    public static final FunctionIdentifier EQ = FunctionIdentifier.newAlgebricks("eq", 2);
    public static final FunctionIdentifier LE = FunctionIdentifier.newAlgebricks("le", 2);
    public static final FunctionIdentifier GE = FunctionIdentifier.newAlgebricks("ge", 2);
    public static final FunctionIdentifier LT = FunctionIdentifier.newAlgebricks("lt", 2);
    public static final FunctionIdentifier GT = FunctionIdentifier.newAlgebricks("gt", 2);
    public static final FunctionIdentifier NEQ = FunctionIdentifier.newAlgebricks("neq", 2);
    public static final FunctionIdentifier NOT = FunctionIdentifier.newAlgebricks("not", 1);
    public static final FunctionIdentifier AND = FunctionIdentifier.newAlgebricks("and", -1);
    public static final FunctionIdentifier OR = FunctionIdentifier.newAlgebricks("or", -1);
    public static final FunctionIdentifier NUMERIC_ADD = FunctionIdentifier.newAlgebricks("numeric-add", 2);
    public static final FunctionIdentifier IS_MISSING = FunctionIdentifier.newAlgebricks("is-missing", 1);
    public static final FunctionIdentifier IS_NULL = FunctionIdentifier.newAlgebricks("is-null", 1);
    private static final Map<FunctionIdentifier, ComparisonKind> comparisonFunctions = new HashMap<FunctionIdentifier, ComparisonKind>();

    public static ComparisonKind getComparisonType(FunctionIdentifier fi) {
        return comparisonFunctions.get(fi);
    }

    public static boolean isComparisonFunction(FunctionIdentifier fi) {
        return comparisonFunctions.get(fi) != null;
    }

    static {
        comparisonFunctions.put(EQ, ComparisonKind.EQ);
        comparisonFunctions.put(LE, ComparisonKind.LE);
        comparisonFunctions.put(GE, ComparisonKind.GE);
        comparisonFunctions.put(LT, ComparisonKind.LT);
        comparisonFunctions.put(GT, ComparisonKind.GT);
        comparisonFunctions.put(NEQ, ComparisonKind.NEQ);
    }

    public static enum ComparisonKind {
        EQ,
        LE,
        GE,
        LT,
        GT,
        NEQ;

    }
}

