/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.IExternalDataRuntimeContext;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.parser.AbstractDataParser;
import org.apache.asterix.external.parser.jackson.ParserContext;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.api.IValueReference;

public class AvroDataParser
extends AbstractDataParser
implements IRecordDataParser<GenericRecord> {
    private final ParserContext parserContext = new ParserContext();

    public AvroDataParser(IExternalDataRuntimeContext context) {
    }

    @Override
    public boolean parse(IRawRecord<? extends GenericRecord> record, DataOutput out) throws HyracksDataException {
        try {
            this.parseObject(record.get(), out);
            return true;
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private final void parseObject(GenericRecord record, DataOutput out) throws IOException {
        Schema schema = record.getSchema();
        IMutableValueStorage valueBuffer = this.parserContext.enterObject();
        IARecordBuilder objectBuilder = this.parserContext.getObjectBuilder(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
        for (Schema.Field field : schema.getFields()) {
            valueBuffer.reset();
            this.parseValue(field.schema(), record.get(field.name()), valueBuffer.getDataOutput());
            objectBuilder.addField((IValueReference)this.parserContext.getSerializedFieldName(field.name()), (IValueReference)valueBuffer);
        }
        objectBuilder.write(out, true);
        this.parserContext.exitObject(valueBuffer, null, objectBuilder);
    }

    private final void parseArray(Schema arraySchema, Collection<?> elements, DataOutput out) throws IOException {
        Schema elementSchema = arraySchema.getElementType();
        IMutableValueStorage valueBuffer = this.parserContext.enterCollection();
        IAsterixListBuilder arrayBuilder = this.parserContext.getCollectionBuilder((AbstractCollectionType)DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE);
        for (Object element : elements) {
            valueBuffer.reset();
            this.parseValue(elementSchema, element, valueBuffer.getDataOutput());
            arrayBuilder.addItem((IValueReference)valueBuffer);
        }
        arrayBuilder.write(out, true);
        this.parserContext.exitCollection(valueBuffer, arrayBuilder);
    }

    private void parseValue(Schema schema, Object value, DataOutput out) throws IOException {
        Schema.Type type = schema.getType();
        switch (type) {
            case RECORD: {
                this.parseObject((GenericRecord)value, out);
                break;
            }
            case ARRAY: {
                this.parseArray(schema, (Collection)value, out);
                break;
            }
            case MAP: 
            case UNION: 
            case ENUM: 
            case FIXED: 
            case NULL: {
                this.nullSerde.serialize((Object)ANull.NULL, out);
                break;
            }
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                this.serializeNumeric(value, type, out);
                break;
            }
            case STRING: {
                this.serializeString(value, type, out);
                break;
            }
            case BYTES: {
                this.serializeBinary(value, type, out);
                break;
            }
            case BOOLEAN: {
                if (((Boolean)value).booleanValue()) {
                    this.booleanSerde.serialize((Object)ABoolean.TRUE, out);
                    break;
                }
                this.booleanSerde.serialize((Object)ABoolean.FALSE, out);
                break;
            }
            default: {
                throw new RuntimeDataException(ErrorCode.PARSE_ERROR, new Serializable[]{value.toString()});
            }
        }
    }

    private void serializeNumeric(Object value, Schema.Type type, DataOutput out) throws IOException {
        switch (type) {
            case INT: {
                this.aInt32.setValue(((Integer)value).intValue());
                this.int32Serde.serialize((Object)this.aInt32, out);
                break;
            }
            case LONG: {
                this.aInt64.setValue(((Long)value).longValue());
                this.int64Serde.serialize((Object)this.aInt64, out);
                break;
            }
            case FLOAT: {
                this.aFloat.setValue(((Float)value).floatValue());
                this.floatSerde.serialize((Object)this.aFloat, out);
                break;
            }
            case DOUBLE: {
                this.aDouble.setValue(((Double)value).doubleValue());
                this.doubleSerde.serialize((Object)this.aDouble, out);
                break;
            }
            default: {
                throw new RuntimeDataException(ErrorCode.TYPE_UNSUPPORTED, new Serializable[]{"Error"});
            }
        }
    }

    private void serializeString(Object value, Schema.Type type, DataOutput out) throws IOException {
        switch (type) {
            case STRING: {
                this.aString.setValue(value.toString());
                this.stringSerde.serialize((Object)this.aString, out);
                break;
            }
            default: {
                throw new RuntimeDataException(ErrorCode.TYPE_UNSUPPORTED, new Serializable[]{"Error"});
            }
        }
    }

    private void serializeBinary(Object value, Schema.Type type, DataOutput out) throws IOException {
        switch (type) {
            case BYTES: {
                this.aBinary.setValue(((ByteBuffer)value).array(), 0, ((ByteBuffer)value).array().length);
                this.binarySerde.serialize((Object)this.aBinary, out);
                break;
            }
            default: {
                throw new RuntimeDataException(ErrorCode.TYPE_UNSUPPORTED, new Serializable[]{"Error"});
            }
        }
    }
}

